/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.ScatteredStructure;

public abstract class MowzieStructure
extends ScatteredStructure<NoFeatureConfig> {
    public MowzieStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    protected int func_204030_a(ChunkGenerator<?> chunkGenerator) {
        return (Integer)this.getGenerationConfig().generationDistance.get();
    }

    protected int func_211745_b(ChunkGenerator<?> chunkGenerator) {
        return (Integer)this.getGenerationConfig().generationSeparation.get();
    }

    public int func_202367_b() {
        return 0;
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (this.func_204030_a(generator) == -1 || this.func_211745_b(generator) == -1) {
            return false;
        }
        List dimensionNames = (List)this.getGenerationConfig().dimensions.get();
        ResourceLocation currDimensionName = worldIn.func_201675_m().func_186058_p().getRegistryName();
        if (currDimensionName == null || !dimensionNames.contains(currDimensionName.toString())) {
            return false;
        }
        if (this.checkHeightLimitAgainstSurface()) {
            int surfaceY = generator.func_222529_a(pos.func_177958_n(), pos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
            if ((float)surfaceY < ((Float)this.getGenerationConfig().heightMin.get()).floatValue()) {
                return false;
            }
            if ((float)surfaceY > ((Float)this.getGenerationConfig().heightMax.get()).floatValue()) {
                return false;
            }
        }
        return super.func_212245_a(worldIn, generator, rand, pos, (IFeatureConfig)config);
    }

    public abstract ConfigHandler.GenerationConfig getGenerationConfig();

    public boolean checkHeightLimitAgainstSurface() {
        return true;
    }
}

