/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client;

import com.bobmowzie.mowziesmobs.client.render.entity.RenderPlayerAnimated;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.FrozenCapability;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrozenController;
import com.bobmowzie.mowziesmobs.server.item.ItemBlowgun;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public enum ClientEventHandler {
    INSTANCE;

    private static final ResourceLocation MARIO;
    private static final ResourceLocation FROZEN_BLUR;
    long startWroughtnautHitTime;
    long lastWroughtnautHitTime;

    @SubscribeEvent
    public void onHandRender(RenderHandEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY);
        if (playerCapability != null && event.getHand() == Hand.MAIN_HAND && playerCapability.getUntilAxeSwing() > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        if (player == null) {
            return;
        }
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY);
        float delta = event.getPartialRenderTick();
        boolean shouldAnimate = playerCapability != null && playerCapability.getUntilAxeSwing() > 0;
        shouldAnimate = shouldAnimate || playerCapability != null && playerCapability.getGeomancy().tunneling;
        boolean bl = shouldAnimate = shouldAnimate || player.func_70644_a((Effect)PotionHandler.FROZEN);
        if (shouldAnimate) {
            event.setCanceled(true);
            RenderPlayerAnimated renderPlayerAnimated = new RenderPlayerAnimated(event.getRenderer().func_177068_d(), ((AbstractClientPlayerEntity)event.getEntity()).func_175154_l().equals("slim"));
            renderPlayerAnimated.func_225623_a_((AbstractClientPlayerEntity)event.getEntity(), event.getEntity().field_70177_z, delta, event.getMatrixStack(), event.getBuffers(), event.getLight());
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            FrozenCapability.IFrozenCapability frozenCapability;
            PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY);
            if (playerCapability != null && playerCapability.getGeomancy().canUse((PlayerEntity)player) && playerCapability.getGeomancy().isSpawningBoulder() && playerCapability.getGeomancy().getSpawnBoulderCharge() > 2) {
                Vector3d lookPos = playerCapability.getGeomancy().getLookPos();
                Vector3d playerEyes = player.func_174824_e(Minecraft.func_71410_x().func_184121_ak());
                Vector3d vec = playerEyes.func_178788_d(lookPos).func_72432_b();
                float yaw = (float)Math.atan2(vec.field_72449_c, vec.field_72450_a);
                float pitch = (float)Math.asin(vec.field_72448_b);
                player.field_70177_z = (float)((double)(yaw * 180.0f) / Math.PI + 90.0);
                player.field_70125_A = (float)((double)(pitch * 180.0f) / Math.PI);
                player.field_70759_as = player.field_70177_z;
                player.field_70126_B = player.field_70177_z;
                player.field_70127_C = player.field_70125_A;
                player.field_70758_at = player.field_70759_as;
            }
            if ((frozenCapability = CapabilityHandler.getCapability((Entity)player, FrozenCapability.FrozenProvider.FROZEN_CAPABILITY)) != null && player.func_70644_a((Effect)PotionHandler.FROZEN) && frozenCapability.getPrevFrozen()) {
                player.field_70177_z = frozenCapability.getFrozenYaw();
                player.field_70125_A = frozenCapability.getFrozenPitch();
                player.field_70759_as = frozenCapability.getFrozenYawHead();
                player.field_70126_B = player.field_70177_z;
                player.field_70127_C = player.field_70125_A;
                player.field_70758_at = player.field_70759_as;
            }
        }
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        FrozenCapability.IFrozenCapability frozenCapability = CapabilityHandler.getCapability((Entity)entity, FrozenCapability.FrozenProvider.FROZEN_CAPABILITY);
        if (frozenCapability != null && entity.func_70644_a((Effect)PotionHandler.FROZEN) && frozenCapability.getPrevFrozen()) {
            entity.field_70177_z = entity.field_70126_B = frozenCapability.getFrozenYaw();
            entity.field_70125_A = entity.field_70127_C = frozenCapability.getFrozenPitch();
            entity.field_70759_as = entity.field_70758_at = frozenCapability.getFrozenYawHead();
            entity.field_70761_aq = entity.field_70760_ar = frozenCapability.getFrozenRenderYawOffset();
            entity.field_70733_aJ = entity.field_70732_aI = frozenCapability.getFrozenSwingProgress();
            entity.field_70721_aZ = entity.field_184618_aE = frozenCapability.getFrozenLimbSwingAmount();
            entity.func_226284_e_(false);
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post e) {
        int startTime = 210;
        int pointStart = 1200;
        int timePerMillis = 22;
        if (e.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_70644_a((Effect)PotionHandler.FROZEN) && Minecraft.func_71410_x().field_71474_y.func_243230_g() != PointOfView.FIRST_PERSON) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(FROZEN_BLUR);
            MainWindow res = e.getWindow();
            AbstractGui.func_238463_a_((MatrixStack)e.getMatrixStack(), (int)0, (int)0, (float)0.0f, (float)0.0f, (int)res.func_198107_o(), (int)res.func_198087_p(), (int)res.func_198107_o(), (int)res.func_198087_p());
        }
    }

    @SubscribeEvent
    public void onRenderHUD(RenderGameOverlayEvent.Pre event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.func_184218_aH() && player.func_184187_bx() instanceof EntityFrozenController) {
            if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HEALTHMOUNT)) {
                event.setCanceled(true);
            }
            if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
                Minecraft.func_71410_x().field_71456_v.func_175188_a((ITextComponent)new TranslationTextComponent(""), false);
            }
        }
    }

    @SubscribeEvent
    public void updateFOV(FOVUpdateEvent event) {
        PlayerEntity player = event.getEntity();
        if (player.func_184587_cr() && player.func_184607_cu().func_77973_b() instanceof ItemBlowgun) {
            int i = player.func_184612_cw();
            float f1 = (float)i / 5.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            event.setNewfov(1.0f - f1 * 0.15f);
        }
    }

    static {
        MARIO = new ResourceLocation("mowziesmobs", "textures/gui/mario.png");
        FROZEN_BLUR = new ResourceLocation("mowziesmobs", "textures/gui/frozenblur.png");
    }
}

