/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client;

import com.bobmowzie.mowziesmobs.client.ClientEventHandler;
import com.bobmowzie.mowziesmobs.client.MMModels;
import com.bobmowzie.mowziesmobs.client.gui.GuiBarakoTrade;
import com.bobmowzie.mowziesmobs.client.gui.GuiBarakoayaTrade;
import com.bobmowzie.mowziesmobs.client.render.entity.FrozenRenderHandler;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderAxeAttack;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderBarako;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderBarakoa;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderBoulder;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderDart;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderFallingBlock;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderFoliaath;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderFoliaathBaby;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderFrostmaw;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderGrottol;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderIceBall;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderLantern;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderNaga;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderNothing;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderPoisonBall;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderSolarBeam;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderSunstrike;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderSuperNova;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderWroughtnaut;
import com.bobmowzie.mowziesmobs.client.sound.BlackPinkSound;
import com.bobmowzie.mowziesmobs.client.sound.IceBreathSound;
import com.bobmowzie.mowziesmobs.client.sound.NagaSwoopSound;
import com.bobmowzie.mowziesmobs.client.sound.SpawnBoulderChargeSound;
import com.bobmowzie.mowziesmobs.client.sound.SunstrikeSound;
import com.bobmowzie.mowziesmobs.server.ServerProxy;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBoulder;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.bobmowzie.mowziesmobs.server.entity.naga.EntityNaga;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerHandler;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends ServerProxy {
    private Entity referencedMob = null;

    @Override
    public void init(IEventBus modbus) {
        super.init(modbus);
        modbus.register(MMModels.class);
        MinecraftForge.EVENT_BUS.register((Object)ClientEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)FrozenRenderHandler.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.BABY_FOLIAATH, RenderFoliaathBaby::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.FOLIAATH, RenderFoliaath::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.WROUGHTNAUT, RenderWroughtnaut::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.BARAKO, RenderBarako::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.BARAKOANA, RenderBarakoa::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.BARAKOAN_TO_BARAKOANA, RenderBarakoa::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.BARAKOAYA, RenderBarakoa::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.BARAKOAN_TO_PLAYER, RenderBarakoa::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.FROSTMAW, RenderFrostmaw::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.GROTTOL, RenderGrottol::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.LANTERN, RenderLantern::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.NAGA, RenderNaga::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.DART, RenderDart::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.SUNSTRIKE, RenderSunstrike::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.SOLAR_BEAM, RenderSolarBeam::new);
        for (EntityType<EntityBoulder> entityType : EntityHandler.BOULDERS) {
            RenderingRegistry.registerEntityRenderingHandler(entityType, RenderBoulder::new);
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.AXE_ATTACK, RenderAxeAttack::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.POISON_BALL, RenderPoisonBall::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.ICE_BALL, RenderIceBall::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.ICE_BREATH, RenderNothing::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.FROZEN_CONTROLLER, RenderNothing::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.SUPER_NOVA, RenderSuperNova::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.FALLING_BLOCK, RenderFallingBlock::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHandler.BLOCK_SWAPPER, RenderNothing::new);
        ScreenManager.func_216911_a(ContainerHandler.CONTAINER_BARAKOAYA_TRADE, GuiBarakoayaTrade::new);
        ScreenManager.func_216911_a(ContainerHandler.CONTAINER_BARAKO_TRADE, GuiBarakoTrade::new);
        ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation("mowziesmobs:wrought_axe_in_hand", "inventory"));
        for (MaskType maskType : MaskType.values()) {
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation("mowziesmobs:barakoa_mask_" + maskType.name + "_frame", "inventory"));
        }
    }

    @Override
    public void onLateInit(IEventBus modbus) {
        for (EntityRenderer entity : Minecraft.func_71410_x().func_175598_ae().field_78729_o.values()) {
            if (!(entity instanceof LivingRenderer)) continue;
            ((LivingRenderer)entity).func_177094_a(new FrozenRenderHandler.LayerFrozen((LivingRenderer)entity));
        }
    }

    @Override
    public void playSunstrikeSound(EntitySunstrike strike) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SunstrikeSound(strike));
    }

    @Override
    public void playIceBreathSound(Entity entity) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new IceBreathSound(entity));
    }

    @Override
    public void playBoulderChargeSound(PlayerEntity player) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SpawnBoulderChargeSound(player));
    }

    @Override
    public void playNagaSwoopSound(EntityNaga naga) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new NagaSwoopSound((Entity)naga));
    }

    @Override
    public void playBlackPinkSound(AbstractMinecartEntity entity) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new BlackPinkSound(entity));
    }

    @Override
    public void minecartParticles(ClientWorld world, AbstractMinecartEntity minecart, float scale, double x, double y, double z, BlockState state, BlockPos pos) {
        int size = 3;
        float offset = -0.5f * scale;
        for (int ix = 0; ix < 3; ++ix) {
            for (int iy = 0; iy < 3; ++iy) {
                for (int iz = 0; iz < 3; ++iz) {
                    double dx = (double)ix / 3.0 * (double)scale;
                    double dy = (double)iy / 3.0 * (double)scale;
                    double dz = (double)iz / 3.0 * (double)scale;
                    Vector3d minecartMotion = minecart.func_213322_ci();
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new DiggingParticle(world, x + dx + (double)offset, y + dy + (double)offset, z + dz + (double)offset, dx + minecartMotion.func_82615_a(), dy + minecartMotion.func_82617_b(), dz + minecartMotion.func_82616_c(), state){}.func_174846_a(pos));
                }
            }
        }
    }

    @Override
    public void solarBeamHitWroughtnaught(LivingEntity caster) {
        if (caster == Minecraft.func_71410_x().field_71439_g) {
            long now = System.currentTimeMillis();
            if (now - ClientEventHandler.INSTANCE.lastWroughtnautHitTime > 500L) {
                ClientEventHandler.INSTANCE.startWroughtnautHitTime = now;
            }
            ClientEventHandler.INSTANCE.lastWroughtnautHitTime = now;
        }
    }

    @Override
    public void setTPS(float tickRate) {
    }

    @Override
    public Entity getReferencedMob() {
        return this.referencedMob;
    }

    @Override
    public void setReferencedMob(Entity referencedMob) {
        this.referencedMob = referencedMob;
    }
}

