/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.bobmowzie.mowziesmobs.client.particle.util.RibbonComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.RibbonParticleData;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleRibbon
extends AdvancedParticleBase {
    public Vector3d[] positions;
    public Vector3d[] prevPositions;

    protected ParticleRibbon(ClientWorld worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double motionX, double motionY, double motionZ, ParticleRotation rotation, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, int length, ParticleComponent[] components) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, motionX, motionY, motionZ, rotation, scale, r, g, b, a, drag, duration, emissive, components);
        this.positions = new Vector3d[length];
        this.prevPositions = new Vector3d[length];
        this.positions[0] = new Vector3d(this.getPosX(), this.getPosY(), this.getPosZ());
        this.prevPositions[0] = this.getPrevPos();
    }

    @Override
    public void func_189213_a() {
        super.func_189213_a();
        for (int i = this.positions.length - 1; i > 0; --i) {
            this.positions[i] = this.positions[i - 1];
            this.prevPositions[i] = this.prevPositions[i - 1];
        }
        this.positions[0] = new Vector3d(this.getPosX(), this.getPosY(), this.getPosZ());
        this.prevPositions[0] = this.getPrevPos();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        void var22_33;
        this.field_82339_as = this.prevAlpha + (this.alpha - this.prevAlpha) * partialTicks;
        if ((double)this.field_82339_as < 0.01) {
            this.field_82339_as = 0.01f;
        }
        this.field_70552_h = this.prevRed + (this.red - this.prevRed) * partialTicks;
        this.field_70553_i = this.prevGreen + (this.green - this.prevGreen) * partialTicks;
        this.field_70551_j = this.prevBlue + (this.blue - this.prevBlue) * partialTicks;
        this.field_70544_f = this.prevScale + (this.scale - this.prevScale) * partialTicks;
        for (ParticleComponent component : this.components) {
            component.preRender(this, partialTicks);
        }
        float f = this.func_217563_c();
        float f1 = this.func_217564_d();
        float f2 = this.func_217562_e();
        float f3 = this.func_217560_f();
        int j = this.func_189214_a(partialTicks);
        float r = this.field_70552_h;
        float g = this.field_70553_i;
        float b = this.field_70551_j;
        float a = this.field_82339_as;
        float scale = this.field_70544_f;
        float prevR = r;
        float prevG = g;
        float prevB = b;
        float prevA = a;
        float prevScale = scale;
        for (ParticleComponent particleComponent : this.components) {
            if (!(particleComponent instanceof RibbonComponent.PropertyOverLength)) continue;
            RibbonComponent.PropertyOverLength pOverLength = (RibbonComponent.PropertyOverLength)particleComponent;
            float value = pOverLength.evaluate(0.0f);
            if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.SCALE) {
                prevScale *= value;
                continue;
            }
            if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.RED) {
                prevR *= value;
                continue;
            }
            if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.GREEN) {
                prevG *= value;
                continue;
            }
            if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.BLUE) {
                prevB *= value;
                continue;
            }
            if (pOverLength.getProperty() != RibbonComponent.PropertyOverLength.EnumRibbonProperty.ALPHA) continue;
            prevA *= value;
        }
        Vector3d offsetDir = new Vector3d(0.0, 0.0, 0.0);
        for (int index = 0; index < this.positions.length - 1; ++index) {
            if (this.positions[index] == null || this.positions[index + 1] == null) continue;
            r = this.field_70552_h;
            g = this.field_70553_i;
            b = this.field_70551_j;
            scale = this.field_70544_f;
            float t = ((float)index + 1.0f) / ((float)this.positions.length - 1.0f);
            for (ParticleComponent component : this.components) {
                if (!(component instanceof RibbonComponent.PropertyOverLength)) continue;
                RibbonComponent.PropertyOverLength pOverLength = (RibbonComponent.PropertyOverLength)component;
                float value = pOverLength.evaluate(t);
                if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.SCALE) {
                    scale *= value;
                    continue;
                }
                if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.RED) {
                    r *= value;
                    continue;
                }
                if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.GREEN) {
                    g *= value;
                    continue;
                }
                if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.BLUE) {
                    b *= value;
                    continue;
                }
                if (pOverLength.getProperty() != RibbonComponent.PropertyOverLength.EnumRibbonProperty.ALPHA) continue;
                a *= value;
            }
            Vector3d vector3d = renderInfo.func_216785_c();
            Vector3d p1 = this.prevPositions[index].func_178787_e(this.positions[index].func_178788_d(this.prevPositions[index]).func_186678_a((double)partialTicks)).func_178788_d(vector3d);
            Vector3d p2 = this.prevPositions[index + 1].func_178787_e(this.positions[index + 1].func_178788_d(this.prevPositions[index + 1]).func_186678_a((double)partialTicks)).func_178788_d(vector3d);
            if (index == 0) {
                Vector3d moveDir = p2.func_178788_d(p1).func_72432_b();
                if (this.rotation instanceof ParticleRotation.FaceCamera) {
                    Vector3d viewVec = new Vector3d(renderInfo.func_227996_l_());
                    offsetDir = moveDir.func_72431_c(viewVec).func_72432_b();
                } else {
                    offsetDir = moveDir.func_72431_c(new Vector3d(0.0, 1.0, 0.0)).func_72432_b();
                }
                offsetDir = offsetDir.func_186678_a((double)prevScale);
            }
            Vector3d[] aVector3d2 = new Vector3d[]{offsetDir.func_186678_a(-1.0), offsetDir, null, null};
            Vector3d moveDir = p2.func_178788_d(p1).func_72432_b();
            if (this.rotation instanceof ParticleRotation.FaceCamera) {
                Vector3d viewVec = new Vector3d(renderInfo.func_227996_l_());
                offsetDir = moveDir.func_72431_c(viewVec).func_72432_b();
            } else {
                offsetDir = moveDir.func_72431_c(new Vector3d(0.0, 1.0, 0.0)).func_72432_b();
            }
            aVector3d2[2] = offsetDir = offsetDir.func_186678_a((double)scale);
            aVector3d2[3] = offsetDir.func_186678_a(-1.0);
            Vector4f[] vertices2 = new Vector4f[]{new Vector4f((float)aVector3d2[0].field_72450_a, (float)aVector3d2[0].field_72448_b, (float)aVector3d2[0].field_72449_c, 1.0f), new Vector4f((float)aVector3d2[1].field_72450_a, (float)aVector3d2[1].field_72448_b, (float)aVector3d2[1].field_72449_c, 1.0f), new Vector4f((float)aVector3d2[2].field_72450_a, (float)aVector3d2[2].field_72448_b, (float)aVector3d2[2].field_72449_c, 1.0f), new Vector4f((float)aVector3d2[3].field_72450_a, (float)aVector3d2[3].field_72448_b, (float)aVector3d2[3].field_72449_c, 1.0f)};
            Matrix4f boxTranslate = Matrix4f.func_226599_b_((float)((float)p1.field_72450_a), (float)((float)p1.field_72448_b), (float)((float)p1.field_72449_c));
            vertices2[0].func_229372_a_(boxTranslate);
            vertices2[1].func_229372_a_(boxTranslate);
            boxTranslate = Matrix4f.func_226599_b_((float)((float)p2.field_72450_a), (float)((float)p2.field_72448_b), (float)((float)p2.field_72449_c));
            vertices2[2].func_229372_a_(boxTranslate);
            vertices2[3].func_229372_a_(boxTranslate);
            buffer.func_225582_a_((double)vertices2[0].func_195910_a(), (double)vertices2[0].func_195913_b(), (double)vertices2[0].func_195914_c()).func_225583_a_(f1, f3).func_227885_a_(prevR, prevG, prevB, prevA).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)vertices2[1].func_195910_a(), (double)vertices2[1].func_195913_b(), (double)vertices2[1].func_195914_c()).func_225583_a_(f1, f2).func_227885_a_(prevR, prevG, prevB, prevA).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)vertices2[2].func_195910_a(), (double)vertices2[2].func_195913_b(), (double)vertices2[2].func_195914_c()).func_225583_a_(f, f2).func_227885_a_(r, g, b, a).func_227886_a_(j).func_181675_d();
            buffer.func_225582_a_((double)vertices2[3].func_195910_a(), (double)vertices2[3].func_195913_b(), (double)vertices2[3].func_195914_c()).func_225583_a_(f, f3).func_227885_a_(r, g, b, a).func_227886_a_(j).func_181675_d();
            prevR = r;
            prevG = g;
            prevB = b;
            prevA = a;
        }
        ParticleComponent[] particleComponentArray = this.components;
        int n = particleComponentArray.length;
        boolean bl = false;
        while (var22_33 < n) {
            ParticleComponent component = particleComponentArray[var22_33];
            component.postRender(this, buffer, renderInfo, partialTicks, j);
            ++var22_33;
        }
    }

    public static void spawnRibbon(World world, ParticleType<? extends RibbonParticleData> particle, int length, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive) {
        ParticleRibbon.spawnRibbon(world, particle, length, x, y, z, motionX, motionY, motionZ, faceCamera, yaw, pitch, roll, scale, r, g, b, a, drag, duration, emissive, new ParticleComponent[0]);
    }

    public static void spawnRibbon(World world, ParticleType<? extends RibbonParticleData> particle, int length, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, ParticleComponent[] components) {
        ParticleRotation rotation = faceCamera ? new ParticleRotation.FaceCamera(0.0f) : new ParticleRotation.EulerAngles((float)yaw, (float)pitch, (float)roll);
        world.func_195594_a((IParticleData)new RibbonParticleData(particle, rotation, scale, r, g, b, a, drag, duration, emissive, length, components), x, y, z, motionX, motionY, motionZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Factory
    implements IParticleFactory<RibbonParticleData> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle makeParticle(RibbonParticleData typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleRibbon particle = new ParticleRibbon(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getRotation(), typeIn.getScale(), typeIn.getRed(), typeIn.getGreen(), typeIn.getBlue(), typeIn.getAlpha(), typeIn.getAirDrag(), typeIn.getDuration(), typeIn.isEmissive(), typeIn.getLength(), typeIn.getComponents());
            particle.func_217566_b(this.spriteSet);
            return particle;
        }
    }
}

