/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle.util;

import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AdvancedParticleData
implements IParticleData {
    public static final IParticleData.IDeserializer<AdvancedParticleData> DESERIALIZER = new IParticleData.IDeserializer<AdvancedParticleData>(){

        public AdvancedParticleData deserialize(ParticleType<AdvancedParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double airDrag = reader.readDouble();
            reader.expect(' ');
            double red = reader.readDouble();
            reader.expect(' ');
            double green = reader.readDouble();
            reader.expect(' ');
            double blue = reader.readDouble();
            reader.expect(' ');
            double alpha = reader.readDouble();
            reader.expect(' ');
            String rotationMode = reader.readString();
            reader.expect(' ');
            double scale = reader.readDouble();
            reader.expect(' ');
            double yaw = reader.readDouble();
            reader.expect(' ');
            double pitch = reader.readDouble();
            reader.expect(' ');
            double roll = reader.readDouble();
            reader.expect(' ');
            boolean emissive = reader.readBoolean();
            reader.expect(' ');
            double duration = reader.readDouble();
            reader.expect(' ');
            double faceCameraAngle = reader.readDouble();
            ParticleRotation rotation = rotationMode.equals("face_camera") ? new ParticleRotation.FaceCamera((float)faceCameraAngle) : (rotationMode.equals("euler") ? new ParticleRotation.EulerAngles((float)yaw, (float)pitch, (float)roll) : new ParticleRotation.OrientVector(new Vector3d(yaw, pitch, roll)));
            return new AdvancedParticleData(particleTypeIn, rotation, scale, red, green, blue, alpha, airDrag, duration, emissive);
        }

        public AdvancedParticleData read(ParticleType<AdvancedParticleData> particleTypeIn, PacketBuffer buffer) {
            double airDrag = buffer.readFloat();
            double red = buffer.readFloat();
            double green = buffer.readFloat();
            double blue = buffer.readFloat();
            double alpha = buffer.readFloat();
            String rotationMode = buffer.func_218666_n();
            double scale = buffer.readFloat();
            double yaw = buffer.readFloat();
            double pitch = buffer.readFloat();
            double roll = buffer.readFloat();
            boolean emissive = buffer.readBoolean();
            double duration = buffer.readFloat();
            double faceCameraAngle = buffer.readFloat();
            ParticleRotation rotation = rotationMode.equals("face_camera") ? new ParticleRotation.FaceCamera((float)faceCameraAngle) : (rotationMode.equals("euler") ? new ParticleRotation.EulerAngles((float)yaw, (float)pitch, (float)roll) : new ParticleRotation.OrientVector(new Vector3d(yaw, pitch, roll)));
            return new AdvancedParticleData(particleTypeIn, rotation, scale, red, green, blue, alpha, airDrag, duration, emissive);
        }
    };
    private final ParticleType<? extends AdvancedParticleData> type;
    private final float airDrag;
    private final float red;
    private final float green;
    private final float blue;
    private final float alpha;
    private final ParticleRotation rotation;
    private final float scale;
    private final boolean emissive;
    private final float duration;
    private final ParticleComponent[] components;

    public AdvancedParticleData(ParticleType<? extends AdvancedParticleData> type, ParticleRotation rotation, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive) {
        this(type, rotation, scale, r, g, b, a, drag, duration, emissive, new ParticleComponent[0]);
    }

    public AdvancedParticleData(ParticleType<? extends AdvancedParticleData> type, ParticleRotation rotation, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, ParticleComponent[] components) {
        this.type = type;
        this.rotation = rotation;
        this.scale = (float)scale;
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
        this.alpha = (float)a;
        this.emissive = emissive;
        this.airDrag = (float)drag;
        this.duration = (float)duration;
        this.components = components;
    }

    public void func_197553_a(PacketBuffer buffer) {
        String rotationMode;
        float faceCameraAngle = 0.0f;
        float yaw = 0.0f;
        float pitch = 0.0f;
        float roll = 0.0f;
        if (this.rotation instanceof ParticleRotation.FaceCamera) {
            rotationMode = "face_camera";
            faceCameraAngle = ((ParticleRotation.FaceCamera)this.rotation).faceCameraAngle;
        } else if (this.rotation instanceof ParticleRotation.EulerAngles) {
            rotationMode = "euler";
            yaw = ((ParticleRotation.EulerAngles)this.rotation).yaw;
            pitch = ((ParticleRotation.EulerAngles)this.rotation).pitch;
            roll = ((ParticleRotation.EulerAngles)this.rotation).roll;
        } else {
            rotationMode = "orient";
            Vector3d vec = ((ParticleRotation.OrientVector)this.rotation).orientation;
            yaw = (float)vec.field_72450_a;
            pitch = (float)vec.field_72448_b;
            roll = (float)vec.field_72449_c;
        }
        buffer.writeFloat(this.airDrag);
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
        buffer.writeFloat(this.alpha);
        buffer.func_180714_a(rotationMode);
        buffer.writeFloat(this.scale);
        buffer.writeFloat(yaw);
        buffer.writeFloat(pitch);
        buffer.writeFloat(roll);
        buffer.writeBoolean(this.emissive);
        buffer.writeFloat(this.duration);
        buffer.writeFloat(faceCameraAngle);
    }

    public String func_197555_a() {
        String rotationMode;
        float faceCameraAngle = 0.0f;
        float yaw = 0.0f;
        float pitch = 0.0f;
        float roll = 0.0f;
        if (this.rotation instanceof ParticleRotation.FaceCamera) {
            rotationMode = "face_camera";
            faceCameraAngle = ((ParticleRotation.FaceCamera)this.rotation).faceCameraAngle;
        } else if (this.rotation instanceof ParticleRotation.EulerAngles) {
            rotationMode = "euler";
            yaw = ((ParticleRotation.EulerAngles)this.rotation).yaw;
            pitch = ((ParticleRotation.EulerAngles)this.rotation).pitch;
            roll = ((ParticleRotation.EulerAngles)this.rotation).roll;
        } else {
            rotationMode = "orient";
            Vector3d vec = ((ParticleRotation.OrientVector)this.rotation).orientation;
            yaw = (float)vec.field_72450_a;
            pitch = (float)vec.field_72448_b;
            roll = (float)vec.field_72449_c;
        }
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %s %.2f %.2f %.2f %.2f %b %.2f %.2f", Registry.field_212632_u.func_177774_c(this.func_197554_b()), Float.valueOf(this.airDrag), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha), rotationMode, Float.valueOf(this.scale), Float.valueOf(yaw), Float.valueOf(pitch), Float.valueOf(roll), this.emissive, Float.valueOf(this.duration), Float.valueOf(faceCameraAngle));
    }

    public ParticleType<? extends AdvancedParticleData> func_197554_b() {
        return this.type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getRed() {
        return this.red;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getGreen() {
        return this.green;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getBlue() {
        return this.blue;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getAlpha() {
        return this.alpha;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getAirDrag() {
        return this.airDrag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ParticleRotation getRotation() {
        return this.rotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getScale() {
        return this.scale;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEmissive() {
        return this.emissive;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getDuration() {
        return this.duration;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ParticleComponent[] getComponents() {
        return this.components;
    }

    public static Codec<AdvancedParticleData> CODEC(ParticleType<AdvancedParticleData> particleType) {
        return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.DOUBLE.fieldOf("scale").forGetter(AdvancedParticleData::getScale), (App)Codec.DOUBLE.fieldOf("r").forGetter(AdvancedParticleData::getRed), (App)Codec.DOUBLE.fieldOf("g").forGetter(AdvancedParticleData::getGreen), (App)Codec.DOUBLE.fieldOf("b").forGetter(AdvancedParticleData::getBlue), (App)Codec.DOUBLE.fieldOf("a").forGetter(AdvancedParticleData::getAlpha), (App)Codec.DOUBLE.fieldOf("drag").forGetter(AdvancedParticleData::getAirDrag), (App)Codec.DOUBLE.fieldOf("duration").forGetter(AdvancedParticleData::getDuration), (App)Codec.BOOL.fieldOf("emissive").forGetter(AdvancedParticleData::isEmissive)).apply((Applicative)codecBuilder, (scale, r, g, b, a, drag, duration, emissive) -> new AdvancedParticleData((ParticleType<? extends AdvancedParticleData>)particleType, new ParticleRotation.FaceCamera(0.0f), (double)scale, (double)r, (double)g, (double)b, (double)a, (double)drag, (double)duration, (boolean)emissive, new ParticleComponent[0])));
    }
}

