/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle.util;

import com.bobmowzie.mowziesmobs.client.particle.ParticleRibbon;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.RibbonParticleData;
import net.minecraft.particles.ParticleType;

public class RibbonComponent
extends ParticleComponent {
    int length;
    ParticleType<? extends RibbonParticleData> ribbon;
    double yaw;
    double pitch;
    double roll;
    double scale;
    double r;
    double g;
    double b;
    double a;
    boolean faceCamera;
    boolean emissive;
    ParticleComponent[] components;

    public RibbonComponent(ParticleType<? extends RibbonParticleData> particle, int length, double yaw, double pitch, double roll, double scale, double r, double g, double b, double a, boolean faceCamera, boolean emissive, ParticleComponent[] components) {
        this.length = length;
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
        this.scale = scale;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.emissive = emissive;
        this.faceCamera = faceCamera;
        this.components = components;
        this.ribbon = particle;
    }

    @Override
    public void init(AdvancedParticleBase particle) {
        super.init(particle);
        if (particle != null) {
            ParticleComponent[] newComponents = new ParticleComponent[this.components.length + 1];
            System.arraycopy(this.components, 0, newComponents, 0, this.components.length);
            newComponents[this.components.length] = new AttachToParticle(particle);
            ParticleRibbon.spawnRibbon(particle.getWorld(), this.ribbon, this.length, particle.getPosX(), particle.getPosY(), particle.getPosZ(), 0.0, 0.0, 0.0, this.faceCamera, this.yaw, this.pitch, this.roll, this.scale, this.r, this.g, this.b, this.a, 0.0, particle.func_206254_h() + this.length, this.emissive, newComponents);
        }
    }

    public static class PropertyOverLength
    extends ParticleComponent {
        private final ParticleComponent.AnimData animData;
        private final EnumRibbonProperty property;

        public PropertyOverLength(EnumRibbonProperty property, ParticleComponent.AnimData animData) {
            this.animData = animData;
            this.property = property;
        }

        public float evaluate(float t) {
            return this.animData.evaluate(t);
        }

        public EnumRibbonProperty getProperty() {
            return this.property;
        }

        public static enum EnumRibbonProperty {
            RED,
            GREEN,
            BLUE,
            ALPHA,
            SCALE;

        }
    }

    private static class AttachToParticle
    extends ParticleComponent {
        AdvancedParticleBase attachedParticle;

        public AttachToParticle(AdvancedParticleBase attachedParticle) {
            this.attachedParticle = attachedParticle;
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            super.init(particle);
            this.attachedParticle.ribbon = (ParticleRibbon)particle;
        }
    }
}

