/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.FrozenCapability;
import com.bobmowzie.mowziesmobs.server.capability.LastDamageCapability;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrostmaw;
import com.bobmowzie.mowziesmobs.server.entity.naga.EntityNaga;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemNagaFangDagger;
import com.bobmowzie.mowziesmobs.server.item.ItemSpear;
import com.bobmowzie.mowziesmobs.server.message.MessageDaggerCrit;
import com.bobmowzie.mowziesmobs.server.message.MessagePlayerAttackMob;
import com.bobmowzie.mowziesmobs.server.message.MessagePlayerSolarBeam;
import com.bobmowzie.mowziesmobs.server.message.MessagePlayerSummonSunstrike;
import com.bobmowzie.mowziesmobs.server.message.MessageUnfreezeEntity;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import com.bobmowzie.mowziesmobs.server.power.Power;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.PacketDistributor;

public final class ServerEventHandler {
    private static final int SUNSTRIKE_COOLDOWN = 55;
    private static final int SOLARBEAM_COOLDOWN = 110;

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ZombieEntity) {
            ((CreatureEntity)entity).field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((CreatureEntity)entity), EntityFoliaath.class, 0, true, false, null));
            ((CreatureEntity)entity).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((CreatureEntity)entity), EntityBarakoa.class, 0, true, false, null));
            ((CreatureEntity)entity).field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((CreatureEntity)entity), EntityBarako.class, 0, true, false, null));
        }
        if (entity instanceof SkeletonEntity) {
            ((CreatureEntity)entity).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((CreatureEntity)entity), EntityBarakoa.class, 0, true, false, null));
            ((CreatureEntity)entity).field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((CreatureEntity)entity), EntityBarako.class, 0, true, false, null));
        }
        if (entity instanceof ParrotEntity) {
            ((CreatureEntity)entity).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)entity, EntityFoliaath.class, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof AnimalEntity) {
            ((CreatureEntity)entity).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)entity, EntityFoliaath.class, 6.0f, 1.0, 1.2));
            ((CreatureEntity)entity).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)entity, EntityBarakoa.class, 6.0f, 1.0, 1.2));
            ((CreatureEntity)entity).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)entity, EntityBarako.class, 6.0f, 1.0, 1.2));
            ((CreatureEntity)entity).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)entity, EntityNaga.class, 10.0f, 1.0, 1.2));
            ((CreatureEntity)entity).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)entity, EntityFrostmaw.class, 10.0f, 1.0, 1.2));
        }
        if (entity instanceof VillagerEntity) {
            ((CreatureEntity)entity).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)entity, EntityBarakoa.class, 6.0f, 1.0, 1.2));
            ((CreatureEntity)entity).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)entity, EntityBarako.class, 6.0f, 1.0, 1.2));
            ((CreatureEntity)entity).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)entity, EntityNaga.class, 10.0f, 1.0, 1.2));
            ((CreatureEntity)entity).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)entity, EntityFrostmaw.class, 10.0f, 1.0, 1.2));
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            FrozenCapability.IFrozenCapability frozenCapability;
            LivingEntity entity = (LivingEntity)event.getEntity();
            if (entity.func_70660_b((Effect)PotionHandler.POISON_RESIST) != null && entity.func_70660_b(Effects.field_76436_u) != null) {
                entity.func_184596_c(Effects.field_76436_u);
            }
            if ((frozenCapability = CapabilityHandler.getCapability((Entity)entity, FrozenCapability.FrozenProvider.FROZEN_CAPABILITY)) != null) {
                frozenCapability.tick(entity);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player == null) {
            return;
        }
        PlayerEntity player = event.player;
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY);
        if (playerCapability != null) {
            Power[] powers;
            playerCapability.tick(event);
            for (Power power : powers = playerCapability.getPowers()) {
                power.tick(event);
            }
        }
    }

    @SubscribeEvent
    public void onUseItem(LivingEntityUseItemEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (event.isCancelable() && living.func_70644_a((Effect)PotionHandler.FROZEN)) {
            event.setCanceled(true);
        }
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            ItemStack item = event.getItem();
            if (item.func_77973_b() == Items.field_151033_d) {
                List<EntityBarako> barakos = this.getEntitiesNearby((Entity)player, EntityBarako.class, 20.0);
                for (EntityBarako barako : barakos) {
                    if (barako.func_70638_az() != null && barako.func_70638_az() instanceof PlayerEntity || barako.func_70638_az() != null && barako.func_70638_az() instanceof PlayerEntity || !barako.func_213336_c(living)) continue;
                    barako.func_70624_b(living);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            BlockState block;
            LivingEntity living = (LivingEntity)entity;
            if (event.isCancelable() && living.func_70644_a((Effect)PotionHandler.FROZEN)) {
                event.setCanceled(true);
            }
            if ((block = event.getPlacedBlock()) == Blocks.field_150480_ab.func_176223_P()) {
                List<EntityBarako> barakos = this.getEntitiesNearby(entity, EntityBarako.class, 20.0);
                for (EntityBarako barako : barakos) {
                    if (barako.func_70638_az() != null && barako.func_70638_az() instanceof PlayerEntity || !barako.func_213336_c(living)) continue;
                    barako.func_70624_b(living);
                }
            }
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living != null) {
            if (event.isCancelable() && living.func_70644_a((Effect)PotionHandler.FROZEN)) {
                event.setCanceled(true);
            }
            if (event.getEmptyBucket().func_77973_b() == Items.field_151129_at) {
                List<EntityBarako> barakos = this.getEntitiesNearby((Entity)living, EntityBarako.class, 20.0);
                for (EntityBarako barako : barakos) {
                    if (barako.func_70638_az() != null && barako.func_70638_az() instanceof PlayerEntity || barako.func_70638_az() != null && barako.func_70638_az() instanceof PlayerEntity || !barako.func_213336_c(living)) continue;
                    barako.func_70624_b(living);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.isCancelable() && event.getPlayer().func_70644_a((Effect)PotionHandler.FROZEN)) {
            event.setCanceled(true);
        }
        PlayerEntity player = event.getPlayer();
        BlockState block = event.getState();
        if (block == Blocks.field_150340_R.func_176223_P()) {
            List<EntityBarako> barakos = this.getEntitiesNearby((Entity)player, EntityBarako.class, 10.0);
            for (EntityBarako barako : barakos) {
                if (barako.func_70638_az() != null && barako.func_70638_az() instanceof PlayerEntity || !barako.func_213336_c((LivingEntity)player)) continue;
                barako.func_70624_b((LivingEntity)player);
            }
        }
    }

    public <T extends Entity> List<T> getEntitiesNearby(Entity startEntity, Class<T> entityClass, double r) {
        return startEntity.field_70170_p.func_175647_a(entityClass, startEntity.func_174813_aQ().func_72314_b(r, r, r), e -> e != startEntity && (double)startEntity.func_70032_d(e) <= r);
    }

    private List<LivingEntity> getEntityLivingBaseNearby(LivingEntity user, double distanceX, double distanceY, double distanceZ, double radius) {
        List list = user.field_70170_p.func_72839_b((Entity)user, user.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        ArrayList nearEntities = list.stream().filter(entityNeighbor -> entityNeighbor instanceof LivingEntity && (double)user.func_70032_d(entityNeighbor) <= radius).map(entityNeighbor -> (LivingEntity)entityNeighbor).collect(Collectors.toCollection(ArrayList::new));
        return nearEntities;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickEmpty event) {
        PlayerEntity player;
        PlayerCapability.IPlayerCapability playerCapability;
        if (event.isCancelable() && event.getEntityLiving().func_70644_a((Effect)PotionHandler.FROZEN)) {
            event.setCanceled(true);
        }
        if ((playerCapability = CapabilityHandler.getCapability((Entity)(player = event.getPlayer()), PlayerCapability.PlayerProvider.PLAYER_CAPABILITY)) != null) {
            Power[] powers;
            if (event.getWorld().field_72995_K && player.field_71071_by.func_70448_g().func_190926_b() && player.func_70644_a((Effect)PotionHandler.SUNS_BLESSING) && playerCapability.getUntilSunstrike() <= 0) {
                if (player.func_225608_bj_()) {
                    MowziesMobs.NETWORK.sendToServer((Object)new MessagePlayerSolarBeam());
                    playerCapability.setUntilSunstrike(110);
                } else {
                    MowziesMobs.NETWORK.sendToServer((Object)new MessagePlayerSummonSunstrike());
                    playerCapability.setUntilSunstrike(55);
                }
            }
            for (Power power : powers = playerCapability.getPowers()) {
                power.onRightClickEmpty(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        PlayerCapability.IPlayerCapability playerCapability;
        if (event.isCancelable() && event.getEntityLiving().func_70644_a((Effect)PotionHandler.FROZEN)) {
            event.setCanceled(true);
        }
        if ((playerCapability = CapabilityHandler.getCapability((Entity)event.getPlayer(), PlayerCapability.PlayerProvider.PLAYER_CAPABILITY)) != null) {
            Power[] powers;
            for (Power power : powers = playerCapability.getPowers()) {
                power.onRightClickEntity(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY);
        if (event.getSide() == LogicalSide.CLIENT && player.field_71071_by.func_70448_g().func_190926_b() && player.func_70644_a((Effect)PotionHandler.SUNS_BLESSING) && playerCapability.getUntilSunstrike() <= 0) {
            if (player.func_225608_bj_()) {
                MowziesMobs.NETWORK.sendToServer((Object)new MessagePlayerSolarBeam());
                playerCapability.setUntilSunstrike(110);
            } else {
                MowziesMobs.NETWORK.sendToServer((Object)new MessagePlayerSummonSunstrike());
                playerCapability.setUntilSunstrike(55);
            }
        }
        if (playerCapability != null) {
            Power[] powers;
            for (Power power : powers = playerCapability.getPowers()) {
                power.onRightClickBlock(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        LivingEntity entityHit;
        double range = 6.5;
        PlayerEntity player = event.getPlayer();
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY);
        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == ItemHandler.SPEAR && (entityHit = ItemSpear.raytraceEntities(player.func_130014_f_(), player, range)) != null) {
            MowziesMobs.NETWORK.sendToServer((Object)new MessagePlayerAttackMob(entityHit));
        }
        if (playerCapability != null) {
            Power[] powers;
            for (Power power : powers = playerCapability.getPowers()) {
                power.onLeftClickEmpty(event);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        LivingEntity living;
        LastDamageCapability.ILastDamageCapability capability;
        PlayerCapability.IPlayerCapability playerCapability;
        if (event.getSource().func_76347_k()) {
            event.getEntityLiving().func_184596_c((Effect)PotionHandler.FROZEN);
            MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> event.getEntity()), (Object)new MessageUnfreezeEntity(event.getEntityLiving()));
        }
        if (event.getEntity() instanceof PlayerEntity && (playerCapability = CapabilityHandler.getCapability(event.getEntity(), PlayerCapability.PlayerProvider.PLAYER_CAPABILITY)) != null) {
            Power[] powers;
            for (Power power : powers = playerCapability.getPowers()) {
                power.onTakeDamage(event);
            }
        }
        if (event.getSource() instanceof EntityDamageSource && event.getSource().func_76346_g() instanceof LivingEntity) {
            Vector3d vecBetween;
            Vector3d lookDir;
            double dot;
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            LivingEntity target = event.getEntityLiving();
            ItemStack weapon = attacker.func_184614_ca();
            if (weapon != null && weapon.func_77973_b() instanceof ItemNagaFangDagger && (dot = (lookDir = new Vector3d(target.func_70040_Z().field_72450_a, 0.0, target.func_70040_Z().field_72449_c).func_72432_b()).func_72430_b(vecBetween = new Vector3d(target.func_226277_ct_() - attacker.func_226277_ct_(), 0.0, target.func_226281_cx_() - attacker.func_226281_cx_()).func_72432_b())) > 0.7) {
                event.setAmount(event.getAmount() + ((Float)ConfigHandler.TOOLS_AND_ABILITIES.NAGA_FANG_DAGGER.bonusDamage.get()).floatValue());
                target.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_ACID_HIT.get(), 1.0f, 1.2f);
                target.func_184185_a(SoundEvents.field_187718_dS, 1.0f, 1.0f);
                MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> target), (Object)new MessageDaggerCrit(target, attacker));
            }
        }
        if (event.getEntityLiving() != null && (capability = CapabilityHandler.getCapability((Entity)(living = event.getEntityLiving()), LastDamageCapability.LastDamageProvider.LAST_DAMAGE_CAPABILITY)) != null) {
            capability.setLastDamage(event.getAmount());
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)event.getPlayer(), PlayerCapability.PlayerProvider.PLAYER_CAPABILITY);
        if (playerCapability != null) {
            Power[] powers;
            for (Power power : powers = playerCapability.getPowers()) {
                power.onRightClickWithItem(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        PlayerCapability.IPlayerCapability playerCapability;
        PlayerEntity player = event.getPlayer();
        if (event.isCancelable() && player.func_70644_a((Effect)PotionHandler.FROZEN)) {
            event.setCanceled(true);
        }
        if ((playerCapability = CapabilityHandler.getCapability((Entity)player, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY)) != null) {
            Power[] powers;
            for (Power power : powers = playerCapability.getPowers()) {
                power.onLeftClickBlock(event);
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        PlayerCapability.IPlayerCapability playerCapability;
        LivingEntity entity;
        if (event.getEntity() instanceof LivingEntity && (entity = (LivingEntity)event.getEntity()).func_70644_a((Effect)PotionHandler.FROZEN) && entity.func_233570_aj_()) {
            entity.func_213317_d(entity.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
        }
        if (event.getEntity() instanceof PlayerEntity && (playerCapability = CapabilityHandler.getCapability(event.getEntity(), PlayerCapability.PlayerProvider.PLAYER_CAPABILITY)) != null) {
            Power[] powers;
            for (Power power : powers = playerCapability.getPowers()) {
                power.onJump(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        PlayerCapability.IPlayerCapability playerCapability;
        if (event.isCancelable() && event.getEntityLiving().func_70644_a((Effect)PotionHandler.FROZEN)) {
            event.setCanceled(true);
        }
        if (event.getEntity() instanceof PlayerEntity && (playerCapability = CapabilityHandler.getCapability((Entity)event.getPlayer(), PlayerCapability.PlayerProvider.PLAYER_CAPABILITY)) != null) {
            Power[] powers;
            for (Power power : powers = playerCapability.getPowers()) {
                power.onLeftClickEntity(event);
            }
            if (!(event.getTarget() instanceof LivingEntity)) {
                return;
            }
            if (event.getTarget() instanceof EntityBarakoanToPlayer) {
                return;
            }
            for (int i = 0; i < playerCapability.getPackSize(); ++i) {
                playerCapability.getTribePack().get(i).func_70624_b((LivingEntity)event.getTarget());
            }
        }
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("mowziesmobs", "frozen"), (ICapabilityProvider)new FrozenCapability.FrozenProvider());
            event.addCapability(new ResourceLocation("mowziesmobs", "last_damage"), (ICapabilityProvider)new LastDamageCapability.LastDamageProvider());
        }
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("mowziesmobs", "player"), (ICapabilityProvider)new PlayerCapability.PlayerProvider());
        }
    }
}

