/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleOrb;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.server.advancement.AdvancementHandler;
import com.bobmowzie.mowziesmobs.server.ai.BarakoaHurtByTargetAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationRadiusAttack;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationSolarBeam;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationSpawnBarakoa;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationSunStrike;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.ai.animation.SimpleAnimationAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySuperNova;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerBarakoTrade;
import com.bobmowzie.mowziesmobs.server.item.BarakoaMask;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.base.Supplier;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityBarako
extends MowzieEntity
implements LeaderSunstrikeImmune,
IMob {
    public static final Animation DIE_ANIMATION = Animation.create(130);
    public static final Animation HURT_ANIMATION = Animation.create(13);
    public static final Animation BELLY_ANIMATION = Animation.create(40);
    public static final Animation TALK_ANIMATION = Animation.create(80);
    public static final Animation SUNSTRIKE_ANIMATION = Animation.create(15);
    public static final Animation ATTACK_ANIMATION = Animation.create(30);
    public static final Animation SPAWN_ANIMATION = Animation.create(20);
    public static final Animation SOLAR_BEAM_ANIMATION = Animation.create(100);
    public static final Animation BLESS_ANIMATION = Animation.create(60);
    public static final Animation SUPERNOVA_ANIMATION = Animation.create(100);
    private static final int MAX_HEALTH = 140;
    private static final int SUNSTRIKE_PAUSE_MAX = 40;
    private static final int SUNSTRIKE_PAUSE_MIN = 20;
    private static final int LASER_PAUSE = 230;
    private static final int SUPERNOVA_PAUSE = 230;
    private static final int BARAKOA_PAUSE = 140;
    private static final int HEAL_PAUSE = 75;
    private static final DataParameter<Integer> DIRECTION = EntityDataManager.func_187226_a(EntityBarako.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DIALOGUE = EntityDataManager.func_187226_a(EntityBarako.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ANGRY = EntityDataManager.func_187226_a(EntityBarako.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> DESIRES = EntityDataManager.func_187226_a(EntityBarako.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<CompoundNBT> TRADED_PLAYERS = EntityDataManager.func_187226_a(EntityBarako.class, (IDataSerializer)DataSerializers.field_192734_n);
    public ControlledAnimation legsUp = new ControlledAnimation(15);
    public ControlledAnimation angryEyebrow = new ControlledAnimation(5);
    private PlayerEntity customer;
    public int barakoaSpawnCount = 0;
    private int direction = 0;
    private boolean blocksByFeet = true;
    private int timeUntilSunstrike = 0;
    private int timeUntilLaser = 0;
    private int timeUntilBarakoa = 0;
    private int timeUntilSupernova = 0;
    private int timeUntilHeal = 0;
    public PlayerEntity blessingPlayer;
    private BarakoaHurtByTargetAI hurtByTargetAI;
    @OnlyIn(value=Dist.CLIENT)
    public Vector3d[] betweenHandPos;
    @OnlyIn(value=Dist.CLIENT)
    public Vector3d[] blessingPlayerPos;
    private static final EntityPredicate GIVE_ACHIEVEMENT_PRED = new EntityPredicate().func_221010_e();
    private static ParticleComponent.KeyTrack superNovaKeyTrack1 = new ParticleComponent.KeyTrack(new float[]{0.0f, 20.0f, 20.0f, 0.0f}, new float[]{0.0f, 0.5f, 0.9f, 1.0f});
    private static ParticleComponent.KeyTrack superNovaKeyTrack2 = ParticleComponent.KeyTrack.oscillate(0.0f, 1.0f, 30);

    public EntityBarako(EntityType<? extends EntityBarako> type, World world) {
        super(type, world);
        if (this.getDirection() == 0) {
            this.setDirection(this.field_70146_Z.nextInt(4) + 1);
        }
        this.field_70728_aV = 45;
        if (world.field_72995_K) {
            this.betweenHandPos = new Vector3d[]{new Vector3d(0.0, 0.0, 0.0)};
            this.blessingPlayerPos = new Vector3d[]{new Vector3d(0.0, 0.0, 0.0)};
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.hurtByTargetAI = new BarakoaHurtByTargetAI(this, true, new Class[0]);
        this.field_70715_bh.func_75776_a(3, (Goal)this.hurtByTargetAI);
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, false, true, target -> {
            if (target instanceof PlayerEntity) {
                if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
                    return false;
                }
                ItemStack headArmorStack = (ItemStack)((PlayerEntity)target).field_71071_by.field_70460_b.get(3);
                return !(headArmorStack.func_77973_b() instanceof BarakoaMask);
            }
            return true;
        }));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieEntity.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, SkeletonEntity.class, 0, true, false, null));
        this.field_70714_bg.func_75776_a(2, new SimpleAnimationAI<EntityBarako>(this, BELLY_ANIMATION, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new SimpleAnimationAI<EntityBarako>(this, TALK_ANIMATION, false){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new SimpleAnimationAI<EntityBarako>(this, BLESS_ANIMATION, false){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityBarako.this.blessingPlayer = EntityBarako.this.getCustomer();
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new SimpleAnimationAI<EntityBarako>(this, SUPERNOVA_ANIMATION, false){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityBarako.this.func_184185_a((SoundEvent)MMSounds.ENTITY_SUPERNOVA_START.get(), 3.0f, 1.0f);
            }

            public void func_75246_d() {
                super.func_75246_d();
                if (((EntityBarako)this.entity).getAnimationTick() == 30) {
                    EntityBarako.this.func_184185_a((SoundEvent)MMSounds.ENTITY_SUPERNOVA_BLACKHOLE.get(), 2.0f, 1.2f);
                }
                if (((EntityBarako)this.entity).getAnimationTick() == 40) {
                    EntityBarako.this.func_184185_a((SoundEvent)MMSounds.ENTITY_BARAKO_SCREAM.get(), 1.5f, 1.0f);
                }
                if (!((EntityBarako)this.entity).field_70170_p.field_72995_K && ((EntityBarako)this.entity).getAnimationTick() == 44) {
                    Vector3d offset = new Vector3d((double)1.1f, 0.0, 0.0);
                    offset = offset.func_178785_b((float)Math.toRadians(-((EntityBarako)this.entity).field_70177_z - 90.0f));
                    EntitySuperNova superNova = new EntitySuperNova(EntityHandler.SUPER_NOVA, ((EntityBarako)this.entity).field_70170_p, (LivingEntity)this.entity, ((EntityBarako)this.entity).func_226277_ct_() + offset.field_72450_a, ((EntityBarako)this.entity).func_226278_cu_() + 0.05, ((EntityBarako)this.entity).func_226281_cx_() + offset.field_72449_c);
                    EntityBarako.this.field_70170_p.func_217376_c((Entity)superNova);
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimationSunStrike<EntityBarako>(this, SUNSTRIKE_ANIMATION){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                if (this.entityTarget != null) {
                    this.prevX = this.entityTarget.func_226277_ct_();
                    this.prevZ = this.entityTarget.func_226281_cx_();
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimationRadiusAttack<EntityBarako>(this, ATTACK_ANIMATION, 4.0f, ((Float)ConfigHandler.MOBS.BARAKO.combatConfig.attackMultiplier.get()).floatValue(), 3.0f, 12, true){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityBarako.this.func_184185_a((SoundEvent)MMSounds.ENTITY_BARAKO_BURST.get(), 1.7f, 1.5f);
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimationSpawnBarakoa(this, SPAWN_ANIMATION));
        this.field_70714_bg.func_75776_a(2, new AnimationSolarBeam<EntityBarako>(this, SOLAR_BEAM_ANIMATION));
        this.field_70714_bg.func_75776_a(3, new AnimationTakeDamage<EntityBarako>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityBarako>(this));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.4f;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MowzieEntity.createAttributes().func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233818_a_, (double)(140.0f * ((Float)ConfigHandler.MOBS.BARAKO.combatConfig.healthMultiplier.get()).floatValue())).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233819_b_, 40.0);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_213392_I() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        if (this.getAnimation() == NO_ANIMATION) {
            if (this.func_70638_az() == null && !this.func_175446_cd()) {
                int soundType = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)9);
                if (soundType < MMSounds.ENTITY_BARAKO_TALK.size()) {
                    this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_BARAKO_TALK.get(soundType)).get(), 2.0f, 1.0f);
                    this.setWhichDialogue(soundType + 1);
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, TALK_ANIMATION);
                }
            } else {
                int soundType = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)1, (int)10);
                if (soundType < 7) {
                    this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_BARAKO_ANGRY.get(soundType - 1)).get(), 2.0f, 1.0f);
                }
            }
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)MMSounds.ENTITY_BARAKO_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        this.func_184185_a((SoundEvent)MMSounds.ENTITY_BARAKO_DIE.get(), 2.0f, 1.0f);
        return null;
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    @Override
    public void func_70071_h_() {
        double oz;
        double oy;
        double ox;
        super.func_70071_h_();
        if (this.field_70173_aa == 1) {
            this.direction = this.getDirection();
        }
        if (this.getAnimation() != ATTACK_ANIMATION || this.getAnimationTick() < 12 || this.getAnimationTick() > 14) {
            this.repelEntities(1.2f, 1.2f, 1.2f, 1.2f);
        }
        this.field_70761_aq = this.field_70177_z = (float)((this.direction - 1) * 90);
        this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, 0.0);
        if (this.func_70638_az() != null) {
            boolean targetComingCloser;
            LivingEntity target = this.func_70638_az();
            this.setAngry(true);
            float entityHitAngle = (float)((Math.atan2(target.func_226281_cx_() - this.func_226281_cx_(), target.func_226277_ct_() - this.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.field_70177_z % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = Math.abs(entityHitAngle - entityAttackingAngle);
            Vector3d betweenEntitiesVec = this.func_213303_ch().func_178788_d(target.func_213303_ch());
            boolean bl = targetComingCloser = target.func_213322_ci().func_72430_b(betweenEntitiesVec) > 0.0;
            if (this.getAnimation() == NO_ANIMATION && !this.func_175446_cd() && this.field_70146_Z.nextInt(80) == 0 && this.getEntitiesNearby(EntityBarakoa.class, 25.0).size() < 5 && (double)this.targetDistance > 4.5 && this.timeUntilBarakoa <= 0) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, SPAWN_ANIMATION);
                this.timeUntilBarakoa = 140;
            } else if (this.getAnimation() == NO_ANIMATION && !this.func_175446_cd() && (double)this.getHealthRatio() <= 0.6 && this.timeUntilLaser <= 0 && (entityRelativeAngle < 60.0f || entityRelativeAngle > 300.0f) && this.func_70635_at().func_75522_a((Entity)target)) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, SOLAR_BEAM_ANIMATION);
                this.timeUntilLaser = 230;
            } else if (this.getAnimation() == NO_ANIMATION && !this.func_175446_cd() && (double)this.getHealthRatio() <= 0.6 && this.timeUntilSupernova <= 0 && (double)this.targetDistance <= 10.5) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, SUPERNOVA_ANIMATION);
                this.timeUntilSupernova = 230;
            } else if (this.getAnimation() == NO_ANIMATION && !this.func_175446_cd() && (this.targetDistance <= 6.0f && targetComingCloser || this.targetDistance < 4.0f)) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, ATTACK_ANIMATION);
            } else if (this.getAnimation() == NO_ANIMATION && !this.func_175446_cd() && this.timeUntilSunstrike <= 0) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, SUNSTRIKE_ANIMATION);
                this.timeUntilSunstrike = this.getTimeUntilSunstrike();
            }
            if (!this.hurtByTargetAI.func_75253_b()) {
                this.hurtByTargetAI.func_75251_c();
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.setAngry(false);
        }
        if (this.field_70173_aa % 20 == 0) {
            this.blocksByFeet = this.checkBlocksByFeet();
        }
        if (this.blocksByFeet) {
            this.legsUp.increaseTimer();
        } else {
            this.legsUp.decreaseTimer();
        }
        if (this.getAngry()) {
            this.angryEyebrow.increaseTimer();
        } else {
            this.angryEyebrow.decreaseTimer();
        }
        if (this.getAnimation() == NO_ANIMATION && !this.func_175446_cd() && this.func_70638_az() == null && this.field_70146_Z.nextInt(200) == 0) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, BELLY_ANIMATION);
        }
        if (this.getAnimation() == BELLY_ANIMATION && (this.getAnimationTick() == 9 || this.getAnimationTick() == 29)) {
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_BARAKO_BELLY.get(), 3.0f, 1.0f);
        }
        if (this.getAnimation() == ATTACK_ANIMATION) {
            this.field_70759_as = this.field_70177_z;
            if (this.getAnimationTick() == 10) {
                if (this.field_70170_p.field_72995_K) {
                    this.spawnExplosionParticles(30);
                }
                this.func_184185_a((SoundEvent)MMSounds.ENTITY_BARAKO_ATTACK.get(), 1.7f, 0.9f);
            }
            if (this.getAnimationTick() <= 6 && this.field_70170_p.field_72995_K) {
                int particleCount = 8;
                while (--particleCount != 0) {
                    double radius = 2.0;
                    double yaw = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                    double pitch = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                    ox = radius * Math.sin(yaw) * Math.sin(pitch);
                    oy = radius * Math.cos(pitch);
                    oz = radius * Math.cos(yaw) * Math.sin(pitch);
                    float offsetX = (float)(-0.3 * Math.sin((double)this.field_70177_z * Math.PI / 180.0));
                    float offsetZ = (float)(-0.3 * Math.cos((double)this.field_70177_z * Math.PI / 180.0));
                    float offsetY = 1.0f;
                    this.field_70170_p.func_195594_a((IParticleData)new ParticleOrb.OrbData((float)this.func_226277_ct_() + offsetX, (float)this.func_226278_cu_() + offsetY, (float)this.func_226281_cx_() + offsetZ, 6.0f), this.func_226277_ct_() + ox + (double)offsetX, this.func_226278_cu_() + (double)offsetY + oy, this.func_226281_cx_() + oz + (double)offsetZ, 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.getAnimation() == BLESS_ANIMATION) {
            this.field_70759_as = this.field_70177_z;
            if (this.getAnimationTick() == 1) {
                this.blessingPlayer = this.getCustomer();
            }
            if (this.field_70170_p.field_72995_K && this.blessingPlayer != null) {
                this.blessingPlayerPos[0] = this.blessingPlayer.func_213303_ch().func_178787_e(new Vector3d(0.0, (double)(this.blessingPlayer.func_213302_cg() / 2.0f), 0.0));
                if (this.getAnimationTick() > 5 && this.getAnimationTick() < 40) {
                    int particleCount = 2;
                    while (--particleCount != 0) {
                        double radius = 0.7f;
                        double yaw = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                        double pitch = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                        ox = radius * Math.sin(yaw) * Math.sin(pitch);
                        oy = radius * Math.cos(pitch);
                        oz = radius * Math.cos(yaw) * Math.sin(pitch);
                        AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.ORB2.get()), this.func_226277_ct_() + ox, this.func_226278_cu_() + (double)0.8f + oy, this.func_226281_cx_() + oz, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 20.0, true, new ParticleComponent[]{new ParticleComponent.Attractor(this.blessingPlayerPos, 0.5f, 0.2f, ParticleComponent.Attractor.EnumAttractorBehavior.LINEAR), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_X, new ParticleComponent.Oscillator(0.0f, (float)ox, 6.0f, 2.5f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, new ParticleComponent.Oscillator(0.0f, (float)oy, 6.0f, 2.5f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Z, new ParticleComponent.Oscillator(0.0f, (float)oz, 6.0f, 2.5f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{0.0f, 1.0f}, new float[]{0.0f, 0.8f}), false)});
                    }
                }
                if (this.getAnimationTick() % 15 == 0) {
                    AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), this.func_226277_ct_(), this.func_226278_cu_() + (double)0.8f, this.func_226281_cx_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 3.5, 1.0, 0.8745098114013672, 0.25882354378700256, 1.0, 1.0, 15.0, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(5.0f, 35.0f), false)});
                }
            }
        }
        if (this.getAnimation() == SUPERNOVA_ANIMATION) {
            if (this.field_70170_p.field_72995_K && this.betweenHandPos.length > 0) {
                this.superNovaEffects();
            }
            if (this.getAnimationTick() < 30) {
                List<LivingEntity> entities = this.getEntityLivingBaseNearby(16.0, 16.0, 16.0, 16.0);
                for (LivingEntity inRange : entities) {
                    if (inRange instanceof LeaderSunstrikeImmune || inRange instanceof PlayerEntity && inRange.func_190530_aW()) continue;
                    Vector3d diff = inRange.func_213303_ch().func_178788_d(this.func_213303_ch().func_72441_c(0.0, 3.0, 0.0));
                    diff = diff.func_72432_b().func_186678_a(0.2);
                    inRange.func_213317_d(this.func_213322_ci().func_178788_d(diff));
                    if (!(inRange.func_226278_cu_() < this.func_226278_cu_() + 3.0)) continue;
                    inRange.func_213317_d(inRange.func_213322_ci().func_72441_c(0.0, 0.075, 0.0));
                }
            }
        }
        if (this.field_70173_aa % 40 == 0) {
            for (PlayerEntity player : this.getPlayersNearby(15.0, 15.0, 15.0, 15.0)) {
                ItemStack headArmorStack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
                if (this.func_70638_az() == player || !this.func_213344_a((LivingEntity)player, GIVE_ACHIEVEMENT_PRED) || !(headArmorStack.func_77973_b() instanceof BarakoaMask) || !(player instanceof ServerPlayerEntity)) continue;
                AdvancementHandler.SNEAK_VILLAGE_TRIGGER.trigger((ServerPlayerEntity)player);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.getAnimation() != SOLAR_BEAM_ANIMATION && this.getAnimation() != SUPERNOVA_ANIMATION) {
            --this.timeUntilHeal;
            if (((Boolean)ConfigHandler.MOBS.BARAKO.healsOutOfBattle.get()).booleanValue() && this.timeUntilHeal <= 0) {
                this.func_70691_i(0.3f);
            }
        } else {
            this.timeUntilHeal = 75;
        }
        if (this.timeUntilSunstrike > 0) {
            --this.timeUntilSunstrike;
        }
        if (this.timeUntilLaser > 0 && this.getAnimation() != SUPERNOVA_ANIMATION) {
            --this.timeUntilLaser;
        }
        if (this.timeUntilBarakoa > 0) {
            --this.timeUntilBarakoa;
        }
        if (this.timeUntilSupernova > 0 && this.getAnimation() != SOLAR_BEAM_ANIMATION) {
            --this.timeUntilSupernova;
        }
    }

    private void superNovaEffects() {
        double value;
        int i;
        if (this.getAnimationTick() == 1) {
            superNovaKeyTrack1 = new ParticleComponent.KeyTrack(new float[]{0.0f, 25.0f, 32.0f, 0.0f}, new float[]{0.0f, 0.6f, 0.85f, 1.0f});
            superNovaKeyTrack2 = ParticleComponent.KeyTrack.oscillate(0.0f, 7.0f, 24);
            AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.SUN.get()), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 33.0, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.betweenHandPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, superNovaKeyTrack1, false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, superNovaKeyTrack2, true)});
        }
        if (this.getAnimationTick() == 33) {
            AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.SUN_NOVA.get()), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 20.0, 1.0, 1.0, 1.0, 0.0, 1.0, 13.0, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.betweenHandPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{11.0f, 7.0f, 5.5f, 1.0f, 30.0f}, new float[]{0.0f, 0.15f, 0.8f, 0.89f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{0.0f, 1.0f, 1.0f, 0.0f}, new float[]{0.0f, 0.15f, 0.89f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.PARTICLE_ANGLE, ParticleComponent.KeyTrack.startAndEnd(0.0f, -6.0f), false)});
        }
        if (this.getAnimationTick() == 32) {
            AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.FLARE.get()), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 0.7, 1.0, 3.0, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.betweenHandPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, ParticleComponent.constant(-0.15f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 22.0f, 0.0f}, new float[]{0.0f, 0.2f, 1.0f}), false)});
        }
        if (this.getAnimationTick() > 30 && this.getAnimationTick() < 41) {
            for (i = 0; i < 6; ++i) {
                float phaseOffset = this.field_70146_Z.nextFloat();
                value = this.field_70146_Z.nextDouble() * 0.3 + 0.05;
                AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), this.betweenHandPos[0].field_72450_a, this.betweenHandPos[0].field_72448_b, this.betweenHandPos[0].field_72449_c, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, value, value, value, 1.0, 1.0, 6.0, false, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 3.0f}, new float[]{0.0f, 0.2f}), false), new ParticleComponent.Orbit(this.betweenHandPos, ParticleComponent.KeyTrack.startAndEnd(0.0f + phaseOffset, -0.4f + phaseOffset), ParticleComponent.KeyTrack.startAndEnd(0.5f + this.field_70146_Z.nextFloat(), 0.0f), ParticleComponent.constant(0.0f), ParticleComponent.constant(0.0f), ParticleComponent.constant(0.0f), true)});
            }
        }
        if (this.getAnimationTick() > 1 && this.getAnimationTick() < 27) {
            for (i = 0; i < 6; ++i) {
                Vector3d particlePos = new Vector3d((double)(this.field_70146_Z.nextFloat() * 5.0f), 0.0, 0.0);
                particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.func_178787_e(this.betweenHandPos[0]);
                value = this.field_70146_Z.nextDouble() * 0.5 + 0.1;
                AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, value, value, value, 1.0, 1.0, 7.0, false, new ParticleComponent[]{new ParticleComponent.Attractor(this.betweenHandPos, 1.1f, 1.0f, ParticleComponent.Attractor.EnumAttractorBehavior.EXPONENTIAL), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 3.5f}, new float[]{0.0f, 0.2f}), false)});
            }
        }
        float timeFrac = Math.min((float)this.getAnimationTick() / 20.0f, 1.0f);
        if (this.getAnimationTick() > 1 && this.getAnimationTick() < 25 && this.getAnimationTick() % (int)(4.0f * (1.0f - timeFrac) + 1.0f) == 0) {
            AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING_SPARKS.get()), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 6.0f + this.field_70146_Z.nextFloat() * 3.0f, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.betweenHandPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(10.0f + 20.0f * timeFrac * timeFrac + 10.0f * this.field_70146_Z.nextFloat() * timeFrac, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.0f, 0.7f), false)});
        }
        if (this.getAnimationTick() == 14) {
            AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.FLARE.get()), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 18.0, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.betweenHandPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, ParticleComponent.constant(-0.1f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 35.0f, 0.0f}, new float[]{0.0f, 0.8f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.Oscillator(-5.0f, 5.0f, 42.0f, 0.0f), true)});
        }
        if (this.getAnimationTick() == 32) {
            AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.BURST_IN.get()), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 1.0, 1.0, 10.0, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.betweenHandPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(25.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.0f, 1.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.Oscillator(-2.0f, 2.0f, 42.0f, 0.0f), true)});
        }
        if (this.getAnimationTick() == 44) {
            float scale = 85.0f;
            AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING_BIG.get()), this.betweenHandPos[0].field_72450_a, this.betweenHandPos[0].field_72448_b, this.betweenHandPos[0].field_72449_c, 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 40.0, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f * scale, 0.59f * scale, 0.87f * scale, 0.974f * scale, 0.998f * scale, 1.0f * scale}, new float[]{0.0f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false)});
            scale = 120.0f;
            AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.GLOW.get()), this.betweenHandPos[0].field_72450_a, this.betweenHandPos[0].field_72448_b, this.betweenHandPos[0].field_72449_c, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 0.95, 0.9, 0.35, 1.0, 1.0, 40.0, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f * scale, 0.59f * scale, 0.87f * scale, 0.974f * scale, 0.998f * scale, 1.0f * scale}, new float[]{0.0f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false)});
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        this.timeUntilHeal = 75;
        return super.func_70097_a(source, damage);
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    private boolean checkBlocksByFeet() {
        BlockState blockRight;
        BlockState blockLeft;
        if (this.direction == 1) {
            BlockPos posLeft = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()) + 1, Math.round((float)(this.func_226278_cu_() - 1.0)), MathHelper.func_76128_c((double)this.func_226281_cx_()) + 1);
            BlockPos posRight = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()) - 1, Math.round((float)(this.func_226278_cu_() - 1.0)), MathHelper.func_76128_c((double)this.func_226281_cx_()) + 1);
            blockLeft = this.field_70170_p.func_180495_p(posLeft);
            blockRight = this.field_70170_p.func_180495_p(posRight);
        } else if (this.direction == 2) {
            BlockPos posLeft = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()) - 1, Math.round((float)(this.func_226278_cu_() - 1.0)), MathHelper.func_76128_c((double)this.func_226281_cx_()) + 1);
            BlockPos posRight = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()) - 1, Math.round((float)(this.func_226278_cu_() - 1.0)), MathHelper.func_76128_c((double)this.func_226281_cx_()) - 1);
            blockLeft = this.field_70170_p.func_180495_p(posLeft);
            blockRight = this.field_70170_p.func_180495_p(posRight);
        } else if (this.direction == 3) {
            BlockPos posLeft = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()) - 1, Math.round((float)(this.func_226278_cu_() - 1.0)), MathHelper.func_76128_c((double)this.func_226281_cx_()) - 1);
            BlockPos posRight = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()) + 1, Math.round((float)(this.func_226278_cu_() - 1.0)), MathHelper.func_76128_c((double)this.func_226281_cx_()) - 1);
            blockLeft = this.field_70170_p.func_180495_p(posLeft);
            blockRight = this.field_70170_p.func_180495_p(posRight);
        } else if (this.direction == 4) {
            BlockPos posLeft = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()) + 1, Math.round((float)(this.func_226278_cu_() - 1.0)), MathHelper.func_76128_c((double)this.func_226281_cx_()) - 1);
            BlockPos posRight = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()) + 1, Math.round((float)(this.func_226278_cu_() - 1.0)), MathHelper.func_76128_c((double)this.func_226281_cx_()) + 1);
            blockLeft = this.field_70170_p.func_180495_p(posLeft);
            blockRight = this.field_70170_p.func_180495_p(posRight);
        } else {
            return false;
        }
        return blockLeft.func_185904_a().func_76230_c() || blockRight.func_185904_a().func_76230_c();
    }

    private void spawnExplosionParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            float velocity = 0.25f;
            float yaw = (float)i * ((float)Math.PI * 2 / (float)amount);
            float vy = this.field_70146_Z.nextFloat() * 0.1f - 0.05f;
            float vx = 0.25f * MathHelper.func_76134_b((float)yaw);
            float vz = 0.25f * MathHelper.func_76126_a((float)yaw);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), (double)vx, (double)vy, (double)vz);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DIRECTION, (Object)0);
        this.func_184212_Q().func_187214_a(DIALOGUE, (Object)0);
        this.func_184212_Q().func_187214_a(ANGRY, (Object)false);
        this.func_184212_Q().func_187214_a(DESIRES, (Object)new ItemStack((IItemProvider)Items.field_221696_bj, 7));
        this.func_184212_Q().func_187214_a(TRADED_PLAYERS, (Object)new CompoundNBT());
    }

    public int getDirection() {
        return (Integer)this.func_184212_Q().func_187225_a(DIRECTION);
    }

    public void setDirection(int direction) {
        this.func_184212_Q().func_187227_b(DIRECTION, (Object)direction);
    }

    public int getWhichDialogue() {
        return (Integer)this.func_184212_Q().func_187225_a(DIALOGUE);
    }

    public void setWhichDialogue(int dialogue) {
        this.func_184212_Q().func_187227_b(DIALOGUE, (Object)dialogue);
    }

    public boolean getAngry() {
        return (Boolean)this.func_184212_Q().func_187225_a(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.func_184212_Q().func_187227_b(ANGRY, (Object)angry);
    }

    public void setDesires(ItemStack stack) {
        this.func_184212_Q().func_187227_b(DESIRES, (Object)stack);
    }

    public ItemStack getDesires() {
        return (ItemStack)this.func_184212_Q().func_187225_a(DESIRES);
    }

    public void setTradedPlayersCompound(ListNBT players) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("players", (INBT)players);
        this.func_184212_Q().func_187227_b(TRADED_PLAYERS, (Object)compound);
    }

    public Set<UUID> getTradedPlayers() {
        HashSet<UUID> tradedPlayers = new HashSet<UUID>();
        CompoundNBT compound = (CompoundNBT)this.func_184212_Q().func_187225_a(TRADED_PLAYERS);
        ListNBT players = compound.func_150295_c("players", 10);
        for (int i = 0; i < players.size(); ++i) {
            tradedPlayers.add(NBTUtil.func_186860_b((INBT)players.func_150305_b(i)));
        }
        return tradedPlayers;
    }

    public boolean doesItemSatisfyDesire(ItemStack stack) {
        return EntityBarako.canPayFor(stack, this.getDesires());
    }

    public boolean fulfillDesire(Slot input) {
        ItemStack desires = this.getDesires();
        if (EntityBarako.canPayFor(input.func_75211_c(), desires)) {
            input.func_75209_a(desires.func_190916_E());
            return true;
        }
        return false;
    }

    public boolean hasTradedWith(PlayerEntity player) {
        return this.getTradedPlayers().contains(PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()));
    }

    public void rememberTrade(PlayerEntity player) {
        UUID uuid = PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH());
        CompoundNBT compound = (CompoundNBT)this.func_184212_Q().func_187225_a(TRADED_PLAYERS);
        ListNBT players = compound.func_150295_c("players", 10);
        players.add((Object)NBTUtil.func_240626_a_((UUID)uuid));
        compound.func_218657_a("players", (INBT)players);
        this.func_184212_Q().func_187227_b(TRADED_PLAYERS, (Object)compound);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("direction", this.getDirection());
        CompoundNBT compoundTradedPlayers = (CompoundNBT)this.func_184212_Q().func_187225_a(TRADED_PLAYERS);
        ListNBT players = compoundTradedPlayers.func_150295_c("players", 10);
        compound.func_218657_a("players", (INBT)players);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setDirection(compound.func_74762_e("direction"));
        ListNBT players = compound.func_150295_c("players", 10);
        this.setTradedPlayersCompound(players);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockState) {
    }

    private int getTimeUntilSunstrike() {
        float damageRatio = 1.0f - this.getHealthRatio();
        if ((double)damageRatio > 0.6) {
            damageRatio = 0.6f;
        }
        return (int)(40.0f - damageRatio / 0.6f * 20.0f);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{DIE_ANIMATION, HURT_ANIMATION, BELLY_ANIMATION, TALK_ANIMATION, SUNSTRIKE_ANIMATION, ATTACK_ANIMATION, SPAWN_ANIMATION, SOLAR_BEAM_ANIMATION, BLESS_ANIMATION, SUPERNOVA_ANIMATION};
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        List<EntityBarakoa> barakoa = this.getEntitiesNearby(EntityBarakoa.class, 20.0, 10.0, 20.0, 20.0);
        for (EntityBarakoa entityBarakoa : barakoa) {
            if (!entityBarakoa.isBarakoDevoted()) continue;
            entityBarakoa.timeUntilDeath = this.field_70146_Z.nextInt(20);
        }
        super.func_70645_a(cause);
    }

    public boolean isTrading() {
        return this.customer != null;
    }

    public PlayerEntity getCustomer() {
        return this.customer;
    }

    public void setCustomer(PlayerEntity customer) {
        this.customer = customer;
    }

    public void openGUI(PlayerEntity playerEntity) {
        this.setCustomer(playerEntity);
        MowziesMobs.PROXY.setReferencedMob((Entity)this);
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.func_70089_S()) {
            playerEntity.func_213829_a(new INamedContainerProvider(){

                public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
                    return new ContainerBarakoTrade(id, EntityBarako.this, playerInventory);
                }

                public ITextComponent func_145748_c_() {
                    return EntityBarako.this.func_145748_c_();
                }
            });
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (this.canTradeWith(player) && this.func_70638_az() == null && this.func_70089_S()) {
            this.openGUI(player);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean canTradeWith(PlayerEntity player) {
        if (this.isTrading() || this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        ItemStack headStack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        return headStack.func_77973_b() instanceof BarakoaMask;
    }

    private static boolean canPayFor(ItemStack stack, ItemStack worth) {
        return stack.func_77973_b() == worth.func_77973_b() && stack.func_190916_E() >= worth.func_190916_E();
    }

    @Override
    protected boolean hasBossBar() {
        return (Boolean)ConfigHandler.MOBS.BARAKO.hasBossBar.get();
    }

    @Override
    protected BossInfo.Color bossBarColor() {
        return BossInfo.Color.YELLOW;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.BARAKO;
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData livingData, CompoundNBT compound) {
        List<PlayerEntity> players;
        if (reason == SpawnReason.SPAWN_EGG && !(players = this.getPlayersNearby(5.0, 5.0, 5.0, 5.0)).isEmpty()) {
            PlayerEntity closestPlayer = players.get(0);
            float closestPlayerDist = 6.0f;
            for (PlayerEntity player : players) {
                float thisDist;
                if (player.func_184614_ca().func_77973_b() != ItemHandler.BARAKO_SPAWN_EGG && player.func_184614_ca().func_77973_b() != ItemHandler.BARAKO_SPAWN_EGG || !((thisDist = this.func_70032_d((Entity)player)) < closestPlayerDist)) continue;
                closestPlayer = player;
                closestPlayerDist = thisDist;
            }
            float angle = (float)this.getAngleBetweenEntities((Entity)this, (Entity)closestPlayer) + 225.0f;
            int direction = (int)(angle / 90.0f) % 4 + 1;
            this.setDirection(direction);
        }
        return super.func_213386_a(world, difficulty, reason, livingData, compound);
    }
}

