/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityBoulder
extends Entity {
    private LivingEntity caster;
    private boolean travelling = false;
    public BlockState storedBlock;
    private static final DataParameter<Optional<BlockState>> BLOCK_STATE = EntityDataManager.func_187226_a(EntityBoulder.class, (IDataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> SHOULD_EXPLODE = EntityDataManager.func_187226_a(EntityBoulder.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(EntityBoulder.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> DEATH_TIME = EntityDataManager.func_187226_a(EntityBoulder.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(EntityBoulder.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float animationOffset = 0.0f;
    private final List<Entity> ridingEntities = new ArrayList<Entity>();
    public BoulderSizeEnum boulderSize = BoulderSizeEnum.SMALL;
    private float speed = 1.5f;
    private int damage = 8;
    private int finishedRisingTick = 4;

    public EntityBoulder(EntityType<? extends EntityBoulder> type, World world) {
        super(type, world);
        this.animationOffset = this.field_70146_Z.nextFloat() * 8.0f;
        this.setOrigin(this.func_233580_cy_());
    }

    public EntityBoulder(EntityType<? extends EntityBoulder> type, World world, LivingEntity caster, BlockState blockState, BlockPos pos) {
        this(type, world);
        this.caster = caster;
        if (type == EntityHandler.BOULDER_SMALL) {
            this.setBoulderSize(BoulderSizeEnum.SMALL);
        } else if (type == EntityHandler.BOULDER_MEDIUM) {
            this.setBoulderSize(BoulderSizeEnum.MEDIUM);
        } else if (type == EntityHandler.BOULDER_LARGE) {
            this.setBoulderSize(BoulderSizeEnum.LARGE);
        } else if (type == EntityHandler.BOULDER_HUGE) {
            this.setBoulderSize(BoulderSizeEnum.HUGE);
        }
        this.setSizeParams();
        if (!world.field_72995_K && blockState != null) {
            Block block = blockState.func_177230_c();
            BlockState newBlock = blockState;
            Material mat = blockState.func_185904_a();
            if (blockState.func_177230_c() == Blocks.field_196658_i || blockState.func_177230_c() == Blocks.field_150391_bh || mat == Material.field_151578_c) {
                newBlock = Blocks.field_150346_d.func_176223_P();
            } else if (mat == Material.field_151576_e) {
                if (block.getRegistryName() != null && block.getRegistryName().func_110623_a().contains("ore")) {
                    newBlock = Blocks.field_150348_b.func_176223_P();
                }
                if (blockState.func_177230_c() == Blocks.field_196766_fg) {
                    newBlock = Blocks.field_150424_aL.func_176223_P();
                }
                if (blockState.func_177230_c() == Blocks.field_150460_al || blockState.func_177230_c() == Blocks.field_150367_z || blockState.func_177230_c() == Blocks.field_150409_cd) {
                    newBlock = Blocks.field_150347_e.func_176223_P();
                }
            } else if (mat == Material.field_151571_B) {
                if (blockState.func_177230_c() == Blocks.field_150435_aG) {
                    newBlock = Blocks.field_150405_ch.func_176223_P();
                }
            } else if (mat == Material.field_151595_p) {
                if (blockState.func_177230_c() == Blocks.field_150354_m) {
                    newBlock = Blocks.field_150322_A.func_176223_P();
                } else if (blockState.func_177230_c() == Blocks.field_196611_F) {
                    newBlock = Blocks.field_180395_cM.func_176223_P();
                } else if (blockState.func_177230_c() == Blocks.field_150351_n) {
                    newBlock = Blocks.field_150347_e.func_176223_P();
                } else if (blockState.func_177230_c() == Blocks.field_150425_aM) {
                    newBlock = Blocks.field_150424_aL.func_176223_P();
                }
            }
            if (!newBlock.func_215686_e((IBlockReader)world, pos)) {
                newBlock = Blocks.field_150348_b.func_176223_P();
            }
            this.setBlock(newBlock);
        }
    }

    public PushReaction func_184192_z() {
        return PushReaction.BLOCK;
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean checkCanSpawn() {
        if (!this.field_70170_p.func_217357_a(EntityBoulder.class, this.func_174813_aQ()).isEmpty()) {
            return false;
        }
        return this.field_70170_p.func_226665_a__((Entity)this, this.func_174813_aQ());
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(BLOCK_STATE, Optional.of(Blocks.field_150346_d.func_176223_P()));
        this.func_184212_Q().func_187214_a(SHOULD_EXPLODE, (Object)false);
        this.func_184212_Q().func_187214_a(ORIGIN, (Object)new BlockPos(0, 0, 0));
        this.func_184212_Q().func_187214_a(DEATH_TIME, (Object)1200);
        this.func_184212_Q().func_187214_a(SIZE, (Object)0);
    }

    public void setSizeParams() {
        BoulderSizeEnum size = this.getBoulderSize();
        if (size == BoulderSizeEnum.MEDIUM) {
            this.finishedRisingTick = 8;
            this.damage = 12;
            this.speed = 1.2f;
        } else if (size == BoulderSizeEnum.LARGE) {
            this.finishedRisingTick = 12;
            this.damage = 16;
            this.speed = 1.0f;
        } else if (size == BoulderSizeEnum.HUGE) {
            this.finishedRisingTick = 90;
            this.damage = 20;
            this.speed = 0.65f;
        }
        if (this.caster instanceof PlayerEntity) {
            this.damage = (int)((float)this.damage * ((Float)ConfigHandler.TOOLS_AND_ABILITIES.geomancyAttackMultiplier.get()).floatValue());
        }
    }

    public boolean func_174814_R() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void func_70071_h_() {
        void var4_15;
        int dripNumber;
        if (this.field_70148_d) {
            this.setSizeParams();
            this.boulderSize = this.getBoulderSize();
        }
        if (this.storedBlock == null) {
            this.storedBlock = this.getBlock();
        }
        if (this.getShouldExplode()) {
            this.explode();
        }
        if (!this.travelling) {
            this.func_174826_a(this.func_200600_R().func_220328_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()).func_72321_a(0.0, -0.5, 0.0));
        }
        super.func_70071_h_();
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        if (this.ridingEntities != null) {
            this.ridingEntities.clear();
        }
        List onTopOfEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_191195_a(0.0, (double)(this.func_213302_cg() - 1.0f), 0.0).func_191194_a(new Vector3d(0.0, (double)this.func_213302_cg() - 0.5, 0.0)).func_72314_b(0.6, 0.5, 0.6));
        for (Entity entity : onTopOfEntities) {
            if (entity == null || !entity.func_70067_L() || entity instanceof EntityBoulder || !(entity.func_226278_cu_() >= this.func_226278_cu_() + 0.2)) continue;
            this.ridingEntities.add(entity);
        }
        if (this.travelling) {
            for (Entity entity : this.ridingEntities) {
                entity.func_213315_a(MoverType.SHULKER_BOX, this.func_213322_ci());
            }
        }
        if (this.boulderSize == BoulderSizeEnum.HUGE && this.field_70173_aa < this.finishedRisingTick) {
            float f = this.func_213311_cf() / 2.0f;
            Iterator<Object> aabb = new AxisAlignedBB(this.func_226277_ct_() - (double)f, this.func_226278_cu_() - 0.5, this.func_226281_cx_() - (double)f, this.func_226277_ct_() + (double)f, this.func_226278_cu_() + (double)Math.min((float)this.field_70173_aa / (float)this.finishedRisingTick * 3.5f, 3.5f), this.func_226281_cx_() + (double)f);
            this.func_174826_a((AxisAlignedBB)aabb);
        }
        if (this.field_70173_aa < this.finishedRisingTick) {
            List popUpEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
            for (Entity entity : popUpEntities) {
                if (!entity.func_70067_L() || entity instanceof EntityBoulder) continue;
                if (this.boulderSize != BoulderSizeEnum.HUGE) {
                    entity.func_213315_a(MoverType.SHULKER_BOX, new Vector3d(0.0, 2.0 * Math.pow(2.0, (double)(-this.field_70173_aa) * (0.6 - 0.1 * (double)this.boulderSize.ordinal())), 0.0));
                    continue;
                }
                entity.func_213315_a(MoverType.SHULKER_BOX, new Vector3d(0.0, (double)0.6f, 0.0));
            }
        }
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(1.7);
        if (this.travelling && !entitiesHit.isEmpty()) {
            for (Entity entity : entitiesHit) {
                if (this.field_70170_p.field_72995_K || entity == this.caster || this.ridingEntities.contains(entity)) continue;
                if (this.caster != null) {
                    entity.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)this.caster), (float)this.damage);
                } else {
                    entity.func_70097_a(DamageSource.field_82729_p, (float)this.damage);
                }
                if (!this.func_70089_S() || this.boulderSize == BoulderSizeEnum.HUGE) continue;
                this.setShouldExplode(true);
            }
        }
        List bouldersHit = this.field_70170_p.func_217357_a(EntityBoulder.class, this.func_174813_aQ().func_72314_b(0.2, 0.2, 0.2).func_191194_a(this.func_213322_ci().func_72432_b().func_186678_a(0.5)));
        if (this.travelling && !bouldersHit.isEmpty()) {
            for (EntityBoulder entity : bouldersHit) {
                if (entity.travelling) continue;
                entity.func_85031_j(this);
                this.explode();
            }
        }
        if (this.travelling && !this.field_70170_p.func_234865_b_((Entity)this, this.func_174813_aQ().func_186662_g(0.1), e -> this.ridingEntities.contains(e))) {
            this.setShouldExplode(true);
        }
        if (this.field_70173_aa == 1) {
            void var4_13;
            boolean bl = false;
            while ((float)var4_13 < 20.0f * this.func_213311_cf()) {
                Vector3d particlePos = new Vector3d((double)this.field_70146_Z.nextFloat() * 1.3 * (double)this.func_213311_cf(), 0.0, 0.0);
                particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.storedBlock), this.func_226277_ct_() + particlePos.field_72450_a, this.func_226278_cu_() - 1.0, this.func_226281_cx_() + particlePos.field_72449_c, particlePos.field_72450_a, 2.0, particlePos.field_72449_c);
                ++var4_13;
            }
            if (this.boulderSize == BoulderSizeEnum.SMALL) {
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_SMALL_CRASH.get(), 1.5f, 1.3f);
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 1.0f);
            } else if (this.boulderSize == BoulderSizeEnum.MEDIUM) {
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_2.get(), 1.5f, 1.5f);
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.8f);
            } else if (this.boulderSize == BoulderSizeEnum.LARGE) {
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1.get(), 1.5f, 0.9f);
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 1.5f, 1.5f);
            } else if (this.boulderSize == BoulderSizeEnum.HUGE) {
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 2.0f, 0.5f);
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_1.get(), 2.0f, 0.8f);
            }
            if (this.field_70170_p.field_72995_K) {
                AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), this.func_226277_ct_(), this.func_226278_cu_() - (double)0.9f, this.func_226281_cx_(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, (int)(5.0f + 2.0f * this.func_213311_cf()), true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(0.0f, (1.0f + 0.5f * this.func_213311_cf()) * 10.0f), false)});
            }
        }
        if (this.field_70173_aa == 30 && this.boulderSize == BoulderSizeEnum.HUGE) {
            this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_2.get(), 2.0f, 0.7f);
        }
        int n = this.field_70173_aa - 2;
        if (this.boulderSize == BoulderSizeEnum.HUGE) {
            var4_15 -= 20;
        }
        if ((dripNumber = (int)((double)(this.func_213311_cf() * 6.0f) * Math.pow(1.03 + 0.04 / (double)this.func_213311_cf(), (double)(-var4_15)))) >= 1 && var4_15 > 0) {
            dripNumber = (int)((float)dripNumber * this.field_70146_Z.nextFloat());
            for (int i = 0; i < dripNumber; ++i) {
                Vector3d particlePos = new Vector3d((double)this.field_70146_Z.nextFloat() * 0.6 * (double)this.func_213311_cf(), 0.0, 0.0);
                particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                float offsetY = this.boulderSize == BoulderSizeEnum.HUGE && this.field_70173_aa < this.finishedRisingTick ? this.field_70146_Z.nextFloat() * (this.func_213302_cg() - 1.0f) - this.func_213302_cg() * (float)(this.finishedRisingTick - this.field_70173_aa) / (float)this.finishedRisingTick : this.field_70146_Z.nextFloat() * (this.func_213302_cg() - 1.0f);
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.storedBlock), this.func_226277_ct_() + particlePos.field_72450_a, this.func_226278_cu_() + (double)offsetY, this.func_226281_cx_() + particlePos.field_72449_c, 0.0, -1.0, 0.0);
            }
        }
        int newDeathTime = this.getDeathTime() - 1;
        this.setDeathTime(newDeathTime);
        if (newDeathTime < 0) {
            this.explode();
        }
    }

    private void explode() {
        block4: {
            Vector3d particlePos;
            int i;
            block6: {
                block5: {
                    block3: {
                        this.func_70106_y();
                        i = 0;
                        while ((float)i < 40.0f * this.func_213311_cf()) {
                            particlePos = new Vector3d((double)this.field_70146_Z.nextFloat() * 0.7 * (double)this.func_213311_cf(), 0.0, 0.0);
                            particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                            particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.storedBlock), this.func_226277_ct_() + particlePos.field_72450_a, this.func_226278_cu_() + 0.5 + particlePos.field_72448_b, this.func_226281_cx_() + particlePos.field_72449_c, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c);
                            ++i;
                        }
                        if (this.boulderSize != BoulderSizeEnum.SMALL) break block3;
                        this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.9f);
                        this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK.get(), 1.5f, 1.0f);
                        break block4;
                    }
                    if (this.boulderSize != BoulderSizeEnum.MEDIUM) break block5;
                    this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.7f);
                    this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM_3.get(), 1.5f, 1.5f);
                    break block4;
                }
                if (this.boulderSize != BoulderSizeEnum.LARGE) break block6;
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 1.5f, 1.0f);
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM_1.get(), 1.5f, 0.9f);
                for (i = 0; i < 5; ++i) {
                    particlePos = new Vector3d((double)(this.field_70146_Z.nextFloat() * 2.0f), 0.0, 0.0);
                    particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    particlePos = particlePos.func_178787_e(new Vector3d(0.0, (double)(this.func_213302_cg() / 4.0f), 0.0));
                    EntityFallingBlock fallingBlock = new EntityFallingBlock(EntityHandler.FALLING_BLOCK, this.field_70170_p, 70, this.getBlock());
                    fallingBlock.func_70107_b(this.func_226277_ct_() + particlePos.field_72450_a, this.func_226278_cu_() + 0.5 + particlePos.field_72448_b, this.func_226281_cx_() + particlePos.field_72449_c);
                    fallingBlock.func_213293_j((float)particlePos.field_72450_a * 0.3f, 0.2f + this.field_70146_Z.nextFloat() * 0.6f, (float)particlePos.field_72449_c * 0.3f);
                    this.field_70170_p.func_217376_c((Entity)fallingBlock);
                }
                break block4;
            }
            if (this.boulderSize != BoulderSizeEnum.HUGE) break block4;
            this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 1.5f, 0.5f);
            this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 1.5f, 0.5f);
            for (i = 0; i < 7; ++i) {
                particlePos = new Vector3d((double)(this.field_70146_Z.nextFloat() * 2.5f), 0.0, 0.0);
                particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.func_178787_e(new Vector3d(0.0, (double)(this.func_213302_cg() / 4.0f), 0.0));
                EntityFallingBlock fallingBlock = new EntityFallingBlock(EntityHandler.FALLING_BLOCK, this.field_70170_p, 70, this.getBlock());
                fallingBlock.func_70107_b(this.func_226277_ct_() + particlePos.field_72450_a, this.func_226278_cu_() + 0.5 + particlePos.field_72448_b, this.func_226281_cx_() + particlePos.field_72449_c);
                fallingBlock.func_213293_j((float)particlePos.field_72450_a * 0.3f, 0.2f + this.field_70146_Z.nextFloat() * 0.6f, (float)particlePos.field_72449_c * 0.3f);
                this.field_70170_p.func_217376_c((Entity)fallingBlock);
            }
        }
    }

    public BlockState getBlock() {
        Optional bsOp = (Optional)this.func_184212_Q().func_187225_a(BLOCK_STATE);
        return bsOp.orElse(null);
    }

    public void setBlock(BlockState block) {
        this.func_184212_Q().func_187227_b(BLOCK_STATE, Optional.of(block));
        this.storedBlock = block;
    }

    public boolean getShouldExplode() {
        return (Boolean)this.func_184212_Q().func_187225_a(SHOULD_EXPLODE);
    }

    public void setShouldExplode(boolean shouldExplode) {
        this.func_184212_Q().func_187227_b(SHOULD_EXPLODE, (Object)shouldExplode);
    }

    public void setOrigin(BlockPos pos) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)pos);
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    public int getDeathTime() {
        return (Integer)this.field_70180_af.func_187225_a(DEATH_TIME);
    }

    public void setDeathTime(int deathTime) {
        this.field_70180_af.func_187227_b(DEATH_TIME, (Object)deathTime);
    }

    public BoulderSizeEnum getBoulderSize() {
        return BoulderSizeEnum.values()[(Integer)this.field_70180_af.func_187225_a(SIZE)];
    }

    public void setBoulderSize(BoulderSizeEnum size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)size.ordinal());
        this.boulderSize = size;
    }

    public void func_213281_b(CompoundNBT compound) {
        BlockState blockState = this.getBlock();
        if (blockState != null) {
            compound.func_218657_a("block", (INBT)NBTUtil.func_190009_a((BlockState)blockState));
        }
        compound.func_74768_a("deathTime", this.getDeathTime());
        compound.func_74768_a("size", this.getBoulderSize().ordinal());
    }

    public void func_70037_a(CompoundNBT compound) {
        INBT blockStateCompound = compound.func_74781_a("block");
        if (blockStateCompound != null) {
            BlockState blockState = NBTUtil.func_190008_d((CompoundNBT)((CompoundNBT)blockStateCompound));
            this.setBlock(blockState);
        }
        this.setDeathTime(compound.func_74762_e("deathTime"));
        this.setBoulderSize(BoulderSizeEnum.values()[compound.func_74762_e("size")]);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_85031_j(Entity entityIn) {
        if (this.field_70173_aa > this.finishedRisingTick - 1 && !this.travelling) {
            if (entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).field_71071_by.func_70448_g().func_190926_b() && ((PlayerEntity)entityIn).func_70644_a((Effect)PotionHandler.GEOMANCY)) {
                PlayerEntity player = (PlayerEntity)entityIn;
                if (this.ridingEntities.contains(player)) {
                    Vector3d lateralLookVec = Vector3d.func_189986_a((float)0.0f, (float)player.field_70177_z).func_72432_b();
                    this.func_213293_j((double)this.speed * 0.5 * lateralLookVec.field_72450_a, this.func_213322_ci().field_72448_b, (double)this.speed * 0.5 * lateralLookVec.field_72449_c);
                } else {
                    this.func_213317_d(player.func_70040_Z().func_186678_a((double)this.speed * 0.5));
                }
            } else if (entityIn instanceof EntityBoulder && ((EntityBoulder)entityIn).travelling) {
                EntityBoulder boulder = (EntityBoulder)entityIn;
                Vector3d thisPos = this.func_213303_ch();
                Vector3d boulderPos = boulder.func_213303_ch();
                Vector3d velVec = thisPos.func_178788_d(boulderPos).func_72432_b();
                this.func_213317_d(velVec.func_186678_a((double)this.speed * 0.5));
            } else {
                return super.func_85031_j(entityIn);
            }
            if (!this.travelling) {
                this.setDeathTime(60);
            }
            this.travelling = true;
            this.func_174826_a(this.func_200600_R().func_220328_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
            if (this.boulderSize == BoulderSizeEnum.SMALL) {
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_SMALL.get(), 1.5f, 1.3f);
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.9f);
            } else if (this.boulderSize == BoulderSizeEnum.MEDIUM) {
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_SMALL.get(), 1.5f, 0.9f);
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.5f);
            } else if (this.boulderSize == BoulderSizeEnum.LARGE) {
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_SMALL.get(), 1.5f, 0.5f);
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 1.5f, 1.3f);
            } else if (this.boulderSize == BoulderSizeEnum.HUGE) {
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1.get(), 1.5f, 1.0f);
                this.func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 1.5f, 0.9f);
            }
            if (this.field_70170_p.field_72995_K) {
                Vector3d ringOffset = this.func_213322_ci().func_186678_a(-1.0).func_72432_b();
                ParticleRotation.OrientVector rotation = new ParticleRotation.OrientVector(ringOffset);
                AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), (float)this.func_226277_ct_() + (float)ringOffset.field_72450_a, (float)this.func_226278_cu_() + 0.5f + (float)ringOffset.field_72448_b, (float)this.func_226281_cx_() + (float)ringOffset.field_72449_c, 0.0, 0.0, 0.0, rotation, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, (int)(5.0f + 2.0f * this.func_213311_cf()), true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.7f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(0.0f, (1.0f + 0.5f * this.func_213311_cf()) * 8.0f), false)});
            }
        }
        return super.func_85031_j(entityIn);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double radius) {
        return this.getEntitiesNearby(LivingEntity.class, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double r) {
        return this.field_70170_p.func_175647_a(entityClass, this.func_174813_aQ().func_72314_b(r, r, r), e -> e != this && (double)this.func_70032_d((Entity)e) <= r + (double)(e.func_213311_cf() / 2.0f));
    }

    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.func_226281_cx_() - first.func_226281_cx_(), second.func_226277_ct_() - first.func_226277_ct_()) * 57.29577951308232 + 90.0;
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        super.func_184185_a(soundIn, volume, pitch + this.field_70146_Z.nextFloat() * 0.25f - 0.125f);
    }

    public static enum BoulderSizeEnum {
        SMALL,
        MEDIUM,
        LARGE,
        HUGE;

    }
}

