/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.particle.ParticleCloud;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleRing;
import com.bobmowzie.mowziesmobs.client.particle.ParticleSnowFlake;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.FrozenCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBlockSwapper;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrostmaw;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class EntityIceBreath
extends EntityMagicEffect {
    private static final int RANGE = 10;
    private static final int ARC = 45;
    private static final int DAMAGE_PER_HIT = 1;

    public EntityIceBreath(EntityType<? extends EntityIceBreath> type, World world) {
        super(type, world);
    }

    public EntityIceBreath(EntityType<? extends EntityIceBreath> type, World world, LivingEntity caster) {
        super(type, world);
        if (!world.field_72995_K) {
            this.setCasterID(caster.func_145782_y());
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa == 1 && this.field_70170_p.field_72995_K) {
            MowziesMobs.PROXY.playIceBreathSound(this);
        }
        if (this.caster != null && !this.caster.func_70089_S()) {
            this.func_70106_y();
        }
        if (this.field_70173_aa == 1) {
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_FROSTMAW_ICEBREATH_START.get(), 1.0f, 0.6f);
        }
        if (this.caster instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)this.caster;
            this.func_70080_a(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_213348_b(player.func_213283_Z(), player.func_213305_a(player.func_213283_Z())) - 0.5, player.func_226281_cx_(), player.field_70177_z, player.field_70125_A);
        }
        float yaw = (float)Math.toRadians(-this.field_70177_z);
        float pitch = (float)Math.toRadians(-this.field_70125_A);
        float spread = 0.25f;
        float speed = 0.56f;
        float xComp = (float)(Math.sin(yaw) * Math.cos(pitch));
        float yComp = (float)Math.sin(pitch);
        float zComp = (float)(Math.cos(yaw) * Math.cos(pitch));
        if (this.field_70170_p.field_72995_K) {
            double zSpeed;
            double ySpeed;
            double xSpeed;
            int i;
            if (this.field_70173_aa % 8 == 0) {
                this.field_70170_p.func_195594_a((IParticleData)new ParticleRing.RingData(yaw, -pitch, 40, 1.0f, 1.0f, 1.0f, 1.0f, 110.0f * spread, false, ParticleRing.EnumRingBehavior.GROW), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)(0.5f * xComp), (double)(0.5f * yComp), (double)(0.5f * zComp));
            }
            for (i = 0; i < 6; ++i) {
                xSpeed = speed * 1.0f * xComp;
                ySpeed = speed * 1.0f * yComp;
                zSpeed = speed * 1.0f * zComp;
                this.field_70170_p.func_195594_a((IParticleData)new ParticleSnowFlake.SnowflakeData(37.0f, true), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), xSpeed, ySpeed, zSpeed);
            }
            for (i = 0; i < 5; ++i) {
                xSpeed = (double)(speed * xComp) + (double)spread * 0.7 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * Math.sqrt(1.0f - xComp * xComp);
                ySpeed = (double)(speed * yComp) + (double)spread * 0.7 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * Math.sqrt(1.0f - yComp * yComp);
                zSpeed = (double)(speed * zComp) + (double)spread * 0.7 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * Math.sqrt(1.0f - zComp * zComp);
                float value = this.field_70146_Z.nextFloat() * 0.15f;
                this.field_70170_p.func_195594_a((IParticleData)new ParticleCloud.CloudData((ParticleType<ParticleCloud.CloudData>)((ParticleType)ParticleHandler.CLOUD.get()), 0.75f + value, 0.75f + value, 1.0f, 10.0f + this.field_70146_Z.nextFloat() * 20.0f, 40, ParticleCloud.EnumCloudBehavior.GROW, 1.0f), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), xSpeed, ySpeed, zSpeed);
            }
        }
        if (this.field_70173_aa > 10) {
            this.hitEntities();
        }
        if (this.field_70173_aa > 10) {
            this.freezeBlocks();
        }
        if (this.field_70173_aa > 65 && !(this.caster instanceof PlayerEntity)) {
            this.func_70106_y();
        }
    }

    public void hitEntities() {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(10.0, 10.0, 10.0, 10.0);
        float damage = 1.0f;
        if (this.caster instanceof EntityFrostmaw) {
            damage *= ((Float)ConfigHandler.MOBS.FROSTMAW.combatConfig.attackMultiplier.get()).floatValue();
        }
        if (this.caster instanceof PlayerEntity) {
            damage *= ((Float)ConfigHandler.TOOLS_AND_ABILITIES.ICE_CRYSTAL.attackMultiplier.get()).floatValue();
        }
        for (LivingEntity entityHit : entitiesHit) {
            Vector3d to;
            Vector3d from;
            BlockRayTraceResult result;
            boolean pitchCheck;
            ResourceLocation mobName;
            List freezeImmune;
            if (entityHit == this.caster || (freezeImmune = (List)ConfigHandler.GENERAL.freeze_blacklist.get()).contains((mobName = EntityType.func_200718_a((EntityType)entityHit.func_200600_R())).toString())) continue;
            float entityHitYaw = (float)((Math.atan2(entityHit.func_226281_cx_() - this.func_226281_cx_(), entityHit.func_226277_ct_() - this.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingYaw = this.field_70177_z % 360.0f;
            if (entityHitYaw < 0.0f) {
                entityHitYaw += 360.0f;
            }
            if (entityAttackingYaw < 0.0f) {
                entityAttackingYaw += 360.0f;
            }
            float entityRelativeYaw = entityHitYaw - entityAttackingYaw;
            float xzDistance = (float)Math.sqrt((entityHit.func_226281_cx_() - this.func_226281_cx_()) * (entityHit.func_226281_cx_() - this.func_226281_cx_()) + (entityHit.func_226277_ct_() - this.func_226277_ct_()) * (entityHit.func_226277_ct_() - this.func_226277_ct_()));
            float entityHitPitch = (float)(Math.atan2(entityHit.func_226278_cu_() - this.func_226278_cu_(), xzDistance) * 57.29577951308232 % 360.0);
            float entityAttackingPitch = -this.field_70125_A % 360.0f;
            if (entityHitPitch < 0.0f) {
                entityHitPitch += 360.0f;
            }
            if (entityAttackingPitch < 0.0f) {
                entityAttackingPitch += 360.0f;
            }
            float entityRelativePitch = entityHitPitch - entityAttackingPitch;
            float entityHitDistance = (float)Math.sqrt((entityHit.func_226281_cx_() - this.func_226281_cx_()) * (entityHit.func_226281_cx_() - this.func_226281_cx_()) + (entityHit.func_226277_ct_() - this.func_226277_ct_()) * (entityHit.func_226277_ct_() - this.func_226277_ct_()) + (entityHit.func_226278_cu_() - this.func_226278_cu_()) * (entityHit.func_226278_cu_() - this.func_226278_cu_()));
            boolean inRange = entityHitDistance <= 10.0f;
            boolean yawCheck = entityRelativeYaw <= 22.5f && entityRelativeYaw >= -22.5f || entityRelativeYaw >= 337.5f || entityRelativeYaw <= -337.5f;
            boolean bl = pitchCheck = entityRelativePitch <= 22.5f && entityRelativePitch >= -22.5f || entityRelativePitch >= 337.5f || entityRelativePitch <= -337.5f;
            if (!inRange || !yawCheck || !pitchCheck || (result = this.field_70170_p.func_217299_a(new RayTraceContext(from = this.func_213303_ch(), to = entityHit.func_213303_ch().func_72441_c(0.0, (double)(entityHit.func_213302_cg() / 2.0f), 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this))).func_216346_c() == RayTraceResult.Type.BLOCK || !entityHit.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.caster), damage)) continue;
            entityHit.func_213317_d(entityHit.func_213322_ci().func_216372_d(0.25, 1.0, 0.25));
            FrozenCapability.IFrozenCapability capability = CapabilityHandler.getCapability((Entity)entityHit, FrozenCapability.FrozenProvider.FROZEN_CAPABILITY);
            if (capability == null) continue;
            capability.addFreezeProgress(entityHit, 0.23f);
        }
    }

    public void freezeBlocks() {
        int checkDist = 10;
        for (int i = (int)this.func_226277_ct_() - checkDist; i < (int)this.func_226277_ct_() + checkDist; ++i) {
            for (int j = (int)this.func_226278_cu_() - checkDist; j < (int)this.func_226278_cu_() + checkDist; ++j) {
                for (int k = (int)this.func_226281_cx_() - checkDist; k < (int)this.func_226281_cx_() + checkDist; ++k) {
                    boolean pitchCheck;
                    BlockPos pos = new BlockPos(i, j, k);
                    BlockState blockState = this.field_70170_p.func_180495_p(pos);
                    BlockState blockStateAbove = this.field_70170_p.func_180495_p(pos.func_177984_a());
                    if (blockState.func_177230_c() != Blocks.field_150355_j || blockStateAbove.func_177230_c() != Blocks.field_150350_a) continue;
                    float blockHitYaw = (float)((Math.atan2((double)pos.func_177952_p() - this.func_226281_cx_(), (double)pos.func_177958_n() - this.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
                    float entityAttackingYaw = this.field_70177_z % 360.0f;
                    if (blockHitYaw < 0.0f) {
                        blockHitYaw += 360.0f;
                    }
                    if (entityAttackingYaw < 0.0f) {
                        entityAttackingYaw += 360.0f;
                    }
                    float blockRelativeYaw = blockHitYaw - entityAttackingYaw;
                    float xzDistance = (float)Math.sqrt(((double)pos.func_177952_p() - this.func_226281_cx_()) * ((double)pos.func_177952_p() - this.func_226281_cx_()) + ((double)pos.func_177958_n() - this.func_226277_ct_()) * ((double)pos.func_177958_n() - this.func_226277_ct_()));
                    float blockHitPitch = (float)(Math.atan2((double)pos.func_177956_o() - this.func_226278_cu_(), xzDistance) * 57.29577951308232 % 360.0);
                    float entityAttackingPitch = -this.field_70125_A % 360.0f;
                    if (blockHitPitch < 0.0f) {
                        blockHitPitch += 360.0f;
                    }
                    if (entityAttackingPitch < 0.0f) {
                        entityAttackingPitch += 360.0f;
                    }
                    float blockRelativePitch = blockHitPitch - entityAttackingPitch;
                    float blockHitDistance = (float)Math.sqrt(((double)pos.func_177952_p() - this.func_226281_cx_()) * ((double)pos.func_177952_p() - this.func_226281_cx_()) + ((double)pos.func_177958_n() - this.func_226277_ct_()) * ((double)pos.func_177958_n() - this.func_226277_ct_()) + ((double)pos.func_177956_o() - this.func_226278_cu_()) * ((double)pos.func_177956_o() - this.func_226278_cu_()));
                    boolean inRange = blockHitDistance <= 10.0f;
                    boolean yawCheck = blockRelativeYaw <= 22.5f && blockRelativeYaw >= -22.5f || blockRelativeYaw >= 337.5f || blockRelativeYaw <= -337.5f;
                    boolean bl = pitchCheck = blockRelativePitch <= 22.5f && blockRelativePitch >= -22.5f || blockRelativePitch >= 337.5f || blockRelativePitch <= -337.5f;
                    if (!inRange || !yawCheck || !pitchCheck) continue;
                    EntityBlockSwapper.swapBlock(this.field_70170_p, pos, Blocks.field_150432_aD.func_176223_P(), 140, false, false);
                }
            }
        }
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.field_70170_p.func_175647_a(entityClass, this.func_174813_aQ().func_72314_b(dX, dY, dZ), e -> e != this && (double)this.func_70032_d((Entity)e) <= r + (double)(e.func_213311_cf() / 2.0f) && e.func_226278_cu_() <= this.func_226278_cu_() + dY);
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
    }
}

