/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.client.particle.ParticleOrb;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.damage.DamageUtil;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.wroughtnaut.EntityWroughtnaut;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntitySolarBeam
extends Entity {
    private final double RADIUS = 20.0;
    public LivingEntity caster;
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public ControlledAnimation appear = new ControlledAnimation(3);
    public boolean on = true;
    public Direction blockSide = null;
    private static final DataParameter<Float> YAW = EntityDataManager.func_187226_a(EntitySolarBeam.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> PITCH = EntityDataManager.func_187226_a(EntitySolarBeam.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> DURATION = EntityDataManager.func_187226_a(EntitySolarBeam.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HAS_PLAYER = EntityDataManager.func_187226_a(EntitySolarBeam.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> CASTER = EntityDataManager.func_187226_a(EntitySolarBeam.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntitySolarBeam(EntityType<? extends EntitySolarBeam> type, World world) {
        super(type, world);
        this.field_70158_ak = true;
    }

    public EntitySolarBeam(EntityType<? extends EntitySolarBeam> type, World world, LivingEntity caster, double x, double y, double z, float yaw, float pitch, int duration) {
        this(type, world);
        this.caster = caster;
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setDuration(duration);
        this.func_70107_b(x, y, z);
        this.calculateEndPos();
        this.func_184185_a((SoundEvent)MMSounds.LASER.get(), 2.0f, 1.0f);
        if (!world.field_72995_K) {
            this.setCasterID(caster.func_145782_y());
        }
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa == 1 && this.field_70170_p.field_72995_K) {
            this.caster = (LivingEntity)this.field_70170_p.func_73045_a(this.getCasterID());
        }
        if (!this.field_70170_p.field_72995_K && this.getHasPlayer()) {
            this.updateWithPlayer();
        }
        if (!this.on && this.appear.getTimer() == 0) {
            this.func_70106_y();
        }
        if (this.on && this.field_70173_aa > 20) {
            this.appear.increaseTimer();
        } else {
            this.appear.decreaseTimer();
        }
        if (this.caster != null && !this.caster.func_70089_S()) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && this.field_70173_aa <= 10) {
            int particleCount = 8;
            while (--particleCount != 0) {
                double radius = 2.0;
                double yaw = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                double pitch = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                double ox = radius * Math.sin(yaw) * Math.sin(pitch);
                double oy = radius * Math.cos(pitch);
                double oz = radius * Math.cos(yaw) * Math.sin(pitch);
                float offsetX = (float)(-2.0 * Math.cos(this.getYaw()));
                float offsetZ = (float)(-2.0 * Math.sin(this.getYaw()));
                if (this.getHasPlayer()) {
                    offsetZ = 0.0f;
                    offsetX = 0.0f;
                }
                this.field_70170_p.func_195594_a((IParticleData)new ParticleOrb.OrbData((float)this.func_226277_ct_() + offsetX, (float)this.func_226278_cu_() + 0.3f, (float)this.func_226281_cx_() + offsetZ, 10.0f), this.func_226277_ct_() + ox + (double)offsetX, this.func_226278_cu_() + oy + 0.3, this.func_226281_cx_() + oz + (double)offsetZ, 0.0, 0.0, 0.0);
            }
        }
        if (this.field_70173_aa > 20) {
            this.calculateEndPos();
            List hit = this.raytraceEntities(this.field_70170_p, new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()), new Vector3d(this.endPosX, this.endPosY, this.endPosZ), false, true, true).entities;
            if (this.blockSide != null) {
                this.spawnExplosionParticles(2);
            }
            if (!this.field_70170_p.field_72995_K) {
                for (LivingEntity target : hit) {
                    if (this.caster instanceof EntityBarako && target instanceof LeaderSunstrikeImmune) continue;
                    float damageFire = 1.5f;
                    float damageMob = 3.0f;
                    if (this.caster instanceof EntityBarako) {
                        damageFire *= ((Float)ConfigHandler.MOBS.BARAKO.combatConfig.attackMultiplier.get()).floatValue();
                        damageMob *= ((Float)ConfigHandler.MOBS.BARAKO.combatConfig.attackMultiplier.get()).floatValue();
                    }
                    if (this.caster instanceof PlayerEntity) {
                        damageFire *= ((Float)ConfigHandler.TOOLS_AND_ABILITIES.sunsBlessingAttackMultiplier.get()).floatValue();
                        damageMob *= ((Float)ConfigHandler.TOOLS_AND_ABILITIES.sunsBlessingAttackMultiplier.get()).floatValue();
                    }
                    DamageUtil.dealMixedDamage(target, DamageSource.func_76358_a((LivingEntity)this.caster), damageMob, DamageSource.field_76370_b, damageFire);
                }
            } else {
                for (LivingEntity e : hit) {
                    if (!(e instanceof EntityWroughtnaut)) continue;
                    MowziesMobs.PROXY.solarBeamHitWroughtnaught(this.caster);
                    break;
                }
                if (this.field_70173_aa - 15 < this.getDuration()) {
                    double o2z;
                    double o2y;
                    double oz;
                    double oy;
                    double ox;
                    double pitch;
                    double yaw;
                    int particleCount = 4;
                    while (particleCount-- > 0) {
                        double radius = 1.0;
                        yaw = (float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI);
                        pitch = (float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI);
                        ox = (float)(radius * Math.sin(yaw) * Math.sin(pitch));
                        oy = (float)(radius * Math.cos(pitch));
                        oz = (float)(radius * Math.cos(yaw) * Math.sin(pitch));
                        double o2x = (float)(-1.0 * Math.cos(this.getYaw()) * Math.cos(this.getPitch()));
                        o2y = (float)(-1.0 * Math.sin(this.getPitch()));
                        o2z = (float)(-1.0 * Math.sin(this.getYaw()) * Math.cos(this.getPitch()));
                        this.field_70170_p.func_195594_a((IParticleData)new ParticleOrb.OrbData((float)(this.collidePosX + o2x + ox), (float)(this.collidePosY + o2y + oy), (float)(this.collidePosZ + o2z + oz), 15.0f), this.func_226277_ct_() + o2x + ox, this.func_226278_cu_() + o2y + oy, this.func_226281_cx_() + o2z + oz, 0.0, 0.0, 0.0);
                    }
                    particleCount = 4;
                    while (particleCount-- > 0) {
                        double radius = 2.0;
                        yaw = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                        pitch = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                        ox = radius * Math.sin(yaw) * Math.sin(pitch);
                        oy = radius * Math.cos(pitch);
                        oz = radius * Math.cos(yaw) * Math.sin(pitch);
                        double o2x = -1.0 * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
                        o2y = -1.0 * Math.sin(this.getPitch());
                        o2z = -1.0 * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
                        this.field_70170_p.func_195594_a((IParticleData)new ParticleOrb.OrbData((float)(this.collidePosX + o2x + ox), (float)(this.collidePosY + o2y + oy), (float)(this.collidePosZ + o2z + oz), 20.0f), this.collidePosX + o2x, this.collidePosY + o2y, this.collidePosZ + o2z, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        if (this.field_70173_aa - 20 > this.getDuration()) {
            this.on = false;
        }
    }

    private void spawnExplosionParticles(int amount) {
        int i;
        for (i = 0; i < amount; ++i) {
            float velocity = 0.1f;
            float yaw = (float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI);
            float motionY = this.field_70146_Z.nextFloat() * 0.08f;
            float motionX = 0.1f * MathHelper.func_76134_b((float)yaw);
            float motionZ = 0.1f * MathHelper.func_76126_a((float)yaw);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, (double)motionX, (double)motionY, (double)motionZ);
        }
        for (i = 0; i < amount / 2; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, 0.0, 0.0, 0.0);
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(YAW, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(PITCH, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(DURATION, (Object)0);
        this.func_184212_Q().func_187214_a(HAS_PLAYER, (Object)false);
        this.func_184212_Q().func_187214_a(CASTER, (Object)-1);
    }

    public float getYaw() {
        return ((Float)this.func_184212_Q().func_187225_a(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.func_184212_Q().func_187227_b(YAW, (Object)Float.valueOf(yaw));
    }

    public float getPitch() {
        return ((Float)this.func_184212_Q().func_187225_a(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.func_184212_Q().func_187227_b(PITCH, (Object)Float.valueOf(pitch));
    }

    public int getDuration() {
        return (Integer)this.func_184212_Q().func_187225_a(DURATION);
    }

    public void setDuration(int duration) {
        this.func_184212_Q().func_187227_b(DURATION, (Object)duration);
    }

    public boolean getHasPlayer() {
        return (Boolean)this.func_184212_Q().func_187225_a(HAS_PLAYER);
    }

    public void setHasPlayer(boolean player) {
        this.func_184212_Q().func_187227_b(HAS_PLAYER, (Object)player);
    }

    public int getCasterID() {
        return (Integer)this.func_184212_Q().func_187225_a(CASTER);
    }

    public void setCasterID(int id) {
        this.func_184212_Q().func_187227_b(CASTER, (Object)id);
    }

    protected void func_70037_a(CompoundNBT nbt) {
    }

    protected void func_213281_b(CompoundNBT nbt) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void calculateEndPos() {
        this.endPosX = this.func_226277_ct_() + 20.0 * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
        this.endPosZ = this.func_226281_cx_() + 20.0 * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
        this.endPosY = this.func_226278_cu_() + 20.0 * Math.sin(this.getPitch());
    }

    public HitResult raytraceEntities(World world, Vector3d from, Vector3d to, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        HitResult result = new HitResult();
        result.setBlockHit((RayTraceResult)world.func_217299_a(new RayTraceContext(from, to, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)));
        if (result.blockHit != null) {
            Vector3d hitVec = result.blockHit.func_216347_e();
            this.collidePosX = hitVec.field_72450_a;
            this.collidePosY = hitVec.field_72448_b;
            this.collidePosZ = hitVec.field_72449_c;
            this.blockSide = result.blockHit.func_216354_b();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = null;
        }
        List entities = world.func_217357_a(LivingEntity.class, new AxisAlignedBB(Math.min(this.func_226277_ct_(), this.collidePosX), Math.min(this.func_226278_cu_(), this.collidePosY), Math.min(this.func_226281_cx_(), this.collidePosZ), Math.max(this.func_226277_ct_(), this.collidePosX), Math.max(this.func_226278_cu_(), this.collidePosY), Math.max(this.func_226281_cx_(), this.collidePosZ)).func_72314_b(1.0, 1.0, 1.0));
        for (LivingEntity entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.func_70111_Y() + 0.5f;
            AxisAlignedBB aabb = entity.func_174813_aQ().func_72314_b((double)pad, (double)pad, (double)pad);
            Optional hit = aabb.func_216365_b(from, to);
            if (aabb.func_72318_a(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public void func_70108_f(Entity entityIn) {
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70112_a(double distance) {
        return distance < 1024.0;
    }

    private void updateWithPlayer() {
        this.setYaw((float)((double)(this.caster.field_70759_as + 90.0f) * Math.PI / 180.0));
        this.setPitch((float)((double)(-this.caster.field_70125_A) * Math.PI / 180.0));
        this.func_70107_b(this.caster.func_226277_ct_(), this.caster.func_226278_cu_() + (double)1.2f, this.caster.func_226281_cx_());
    }

    public static class HitResult {
        private BlockRayTraceResult blockHit;
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public BlockRayTraceResult getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(RayTraceResult rayTraceResult) {
            if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                this.blockHit = (BlockRayTraceResult)rayTraceResult;
            }
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

