/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.grottol;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.server.advancement.AdvancementHandler;
import com.bobmowzie.mowziesmobs.server.ai.EntityAIGrottolFindMinecart;
import com.bobmowzie.mowziesmobs.server.ai.MMAIAvoidEntity;
import com.bobmowzie.mowziesmobs.server.ai.MMEntityMoveHelper;
import com.bobmowzie.mowziesmobs.server.ai.MMPathNavigateGround;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.ai.animation.SimpleAnimationAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.grottol.BlackPinkRailLine;
import com.bobmowzie.mowziesmobs.server.entity.grottol.ai.EntityAIGrottolIdle;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import com.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityGrottol
extends MowzieEntity
implements IMob {
    public static final Animation DIE_ANIMATION = Animation.create(73);
    public static final Animation HURT_ANIMATION = Animation.create(10);
    public static final Animation IDLE_ANIMATION = EntityAIGrottolIdle.animation();
    public static final Animation BURROW_ANIMATION = Animation.create(20);
    private static final Animation[] ANIMATIONS = new Animation[]{DIE_ANIMATION, HURT_ANIMATION, IDLE_ANIMATION, BURROW_ANIMATION};
    public int fleeTime = 0;
    private int timeSinceFlee = 50;
    private int timeSinceMinecart = 0;
    private final BlackPinkRailLine reader = BlackPinkRailLine.create();
    private EnumDeathType death = EnumDeathType.NORMAL;
    private int timeSinceDeflectSound = 0;

    public EntityGrottol(EntityType<? extends EntityGrottol> type, World world) {
        super(type, world);
        this.field_70728_aV = 20;
        this.field_70138_W = 1.15f;
        this.field_70765_h = new MMEntityMoveHelper((MobEntity)this, 45.0f);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.func_184644_a(PathNodeType.DANGER_OTHER, 1.0f);
        this.func_184644_a(PathNodeType.WATER, 3.0f);
        this.func_184644_a(PathNodeType.LAVA, 1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 1.0f);
        this.func_184644_a(PathNodeType.DANGER_CACTUS, 1.0f);
        this.field_70714_bg.func_75776_a(3, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.3));
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAIGrottolFindMinecart(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MMAIAvoidEntity<EntityGrottol, PlayerEntity>(this, PlayerEntity.class, 16.0f, 0.5, 0.7){
            private int fleeCheckCounter;
            {
                this.fleeCheckCounter = 0;
            }

            @Override
            protected void onSafe() {
                this.fleeCheckCounter = 0;
            }

            @Override
            protected void onPathNotFound() {
                if (this.fleeCheckCounter < 4) {
                    ++this.fleeCheckCounter;
                } else if (EntityGrottol.this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    AnimationHandler.INSTANCE.sendAnimationMessage(this.entity, BURROW_ANIMATION);
                }
            }

            @Override
            public void func_75246_d() {
                super.func_75246_d();
                ++((EntityGrottol)this.entity).fleeTime;
            }

            @Override
            public void func_75251_c() {
                super.func_75251_c();
                ((EntityGrottol)this.entity).timeSinceFlee = 0;
                this.fleeCheckCounter = 0;
            }
        });
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(1, new AnimationTakeDamage<EntityGrottol>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityGrottol>(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new EntityAIGrottolIdle(this));
        this.field_70714_bg.func_75776_a(2, new SimpleAnimationAI<EntityGrottol>(this, BURROW_ANIMATION, false));
    }

    public int func_82143_as() {
        return 256;
    }

    protected PathNavigator func_175447_b(World world) {
        return new MMPathNavigateGround(this, world);
    }

    public float func_180484_a(BlockPos pos) {
        return (float)pos.func_218138_a((IPosition)this.func_213303_ch(), true);
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_70613_aW() {
        return super.func_70613_aW() && !this.isInMinecart();
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MowzieEntity.createAttributes().func_233815_a_(Attributes.field_233818_a_, (double)(20.0f * ((Float)ConfigHandler.MOBS.GROTTOL.healthMultiplier.get()).floatValue())).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    @Override
    protected ConfigHandler.SpawnConfig getSpawnConfig() {
        return ConfigHandler.MOBS.GROTTOL.spawnConfig;
    }

    @Override
    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        return this.getEntitiesNearby(EntityGrottol.class, 20.0, 20.0, 20.0, 20.0).isEmpty() && super.func_213380_a(world, reason);
    }

    public boolean func_85031_j(Entity entity) {
        PlayerEntity player;
        if (entity instanceof PlayerEntity && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)(player = (PlayerEntity)entity).func_184614_ca()) > 0) {
            if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
                this.func_70099_a(ItemHandler.CAPTURED_GROTTOL.create(this), 0.0f);
                BlockState state = Blocks.field_150348_b.func_176223_P();
                SoundType sound = state.func_177230_c().getSoundType(state, (IWorldReader)this.field_70170_p, this.func_233580_cy_(), entity);
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), sound.func_185845_c(), this.func_184176_by(), (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
                if (this.field_70170_p instanceof ServerWorld) {
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() / 2.0, this.func_226281_cx_(), 32, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
                }
                this.func_70106_y();
                if (player instanceof ServerPlayerEntity) {
                    AdvancementHandler.GROTTOL_KILL_SILK_TOUCH_TRIGGER.trigger((ServerPlayerEntity)player);
                }
            }
            return true;
        }
        return super.func_85031_j(entity);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (player.func_184614_ca().func_150998_b(Blocks.field_150482_ag.func_176223_P())) {
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca()) > 0) {
                    this.death = EnumDeathType.FORTUNE_PICKAXE;
                    if (player instanceof ServerPlayerEntity) {
                        AdvancementHandler.GROTTOL_KILL_FORTUNE_TRIGGER.trigger((ServerPlayerEntity)player);
                    }
                } else {
                    this.death = EnumDeathType.PICKAXE;
                }
                return super.func_70097_a(source, this.func_110143_aJ());
            }
            if (this.timeSinceDeflectSound >= 5) {
                this.timeSinceDeflectSound = 0;
                this.func_184185_a((SoundEvent)MMSounds.ENTITY_GROTTOL_UNDAMAGED.get(), 0.4f, 2.0f);
            }
            return false;
        }
        if (entity instanceof MobEntity) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_70071_h_() {
        BlockState blockBeneath;
        Entity e;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && EntityGrottol.isMinecart(e = this.func_184187_bx())) {
            AbstractMinecartEntity minecart = (AbstractMinecartEntity)e;
            this.reader.accept(minecart);
            boolean onRail = EntityGrottol.isBlockRail(this.field_70170_p.func_180495_p(e.func_233580_cy_()).func_177230_c());
            if (this.timeSinceMinecart > 3 && e.func_213322_ci().func_72433_c() < 0.001 || !onRail) {
                minecart.func_184226_ay();
                this.timeSinceMinecart = 0;
            } else if (onRail) {
                minecart.func_213317_d(minecart.func_189651_aD().func_186678_a(2.7));
                ++this.timeSinceMinecart;
            }
        }
        if (this.field_70170_p.field_72995_K && this.func_70089_S() && this.field_70146_Z.nextInt(15) == 0) {
            double x = this.func_226277_ct_() + (double)(0.5f * (2.0f * this.field_70146_Z.nextFloat() - 1.0f));
            double y = this.func_226278_cu_() + (double)0.8f + (double)(0.3f * (2.0f * this.field_70146_Z.nextFloat() - 1.0f));
            double z = this.func_226281_cx_() + (double)(0.5f * (2.0f * this.field_70146_Z.nextFloat() - 1.0f));
            if (this.isBlackPinkInYourArea()) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197597_H, x, y, z, this.field_70146_Z.nextDouble() / 2.0, 0.0, 0.0);
            } else {
                this.field_70170_p.func_195594_a((IParticleData)ParticleHandler.SPARKLE.get(), x, y, z, 0.0, 0.0, 0.0);
            }
        }
        float moveX = (float)(this.func_226277_ct_() - this.field_70169_q);
        float moveZ = (float)(this.func_226281_cx_() - this.field_70166_s);
        float speed = MathHelper.func_76129_c((float)(moveX * moveX + moveZ * moveZ));
        if (this.frame % 6 == 0 && (double)speed > 0.05) {
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_GROTTOL_STEP.get(), 1.0f, 1.8f);
        }
        if (this.timeSinceFlee < 50) {
            ++this.timeSinceFlee;
        } else {
            this.fleeTime = 0;
        }
        if (this.timeSinceDeflectSound < 5) {
            ++this.timeSinceDeflectSound;
        }
        if (!this.field_70170_p.field_72995_K && this.fleeTime >= 55 && this.getAnimation() == NO_ANIMATION && !this.func_175446_cd() && !this.func_70644_a(PotionHandler.FROZEN) && this.isBlockDiggable(blockBeneath = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()))) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, BURROW_ANIMATION);
        }
        if (!this.field_70170_p.field_72995_K && this.getAnimation() == BURROW_ANIMATION && this.getAnimationTick() % 4 == 3) {
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_GROTTOL_BURROW.get(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            blockBeneath = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b());
            Material mat = blockBeneath.func_185904_a();
            if (mat == Material.field_151578_c || mat == Material.field_151595_p || mat == Material.field_151571_B || mat == Material.field_151576_e) {
                Vector3d pos = new Vector3d(0.7, 0.05, 0.0).func_178785_b((float)Math.toRadians(-this.field_70761_aq - 90.0f));
                if (this.field_70170_p instanceof ServerWorld) {
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockBeneath), this.func_226277_ct_() + pos.field_72450_a, this.func_226278_cu_() + pos.field_72448_b, this.func_226281_cx_() + pos.field_72449_c, 8, 0.25, 0.025, 0.25, 0.1);
                }
            }
        }
    }

    @Override
    protected void onAnimationFinish(Animation animation) {
        if (animation == BURROW_ANIMATION) {
            this.func_70106_y();
        }
    }

    public static boolean isBlockRail(Block block) {
        return block == Blocks.field_150448_aq || block == Blocks.field_150408_cc || block == Blocks.field_196552_aC || block == Blocks.field_150319_E;
    }

    private boolean isBlackPinkInYourArea() {
        Entity e = this.func_184187_bx();
        return false;
    }

    public boolean isInMinecart() {
        return EntityGrottol.isMinecart(this.func_184187_bx());
    }

    private static boolean isMinecart(Entity entity) {
        return entity instanceof MinecartEntity;
    }

    protected void func_82167_n(Entity entity) {
        if (!EntityGrottol.isMinecart(entity)) {
            super.func_82167_n(entity);
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return super.func_184205_a(entity, force);
    }

    public void func_184210_p() {
        super.func_184210_p();
    }

    protected SoundEvent func_184615_bR() {
        this.func_184185_a((SoundEvent)MMSounds.ENTITY_GROTTOL_DIE.get(), 1.0f, 1.3f);
        return null;
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    @Override
    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    public EnumDeathType getDeathType() {
        return this.death;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.GROTTOL;
    }

    public boolean isBlockDiggable(BlockState blockState) {
        Material mat = blockState.func_185904_a();
        if (mat != Material.field_151577_b && mat != Material.field_151578_c && mat != Material.field_151576_e && mat != Material.field_151571_B && mat != Material.field_151595_p) {
            return false;
        }
        return blockState.func_177230_c() != Blocks.field_150407_cf && blockState.func_177230_c() != Blocks.field_189878_dg && !(blockState.func_177230_c() instanceof FenceBlock) && blockState.func_177230_c() != Blocks.field_150474_ac && blockState.func_177230_c() != Blocks.field_189880_di && blockState.func_177230_c() != Blocks.field_150381_bn && blockState.func_177230_c() != Blocks.field_150378_br && blockState.func_177230_c() != Blocks.field_150477_bB && blockState.func_177230_c() != Blocks.field_180399_cE && blockState.func_177230_c() != Blocks.field_150438_bZ && !blockState.hasTileEntity();
    }

    public static enum EnumDeathType {
        NORMAL,
        PICKAXE,
        FORTUNE_PICKAXE;

    }
}

