/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.lantern;

import com.bobmowzie.mowziesmobs.client.particle.ParticleCloud;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleOrb;
import com.bobmowzie.mowziesmobs.client.particle.ParticleVanillaCloudExtended;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.ai.animation.SimpleAnimationAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityLantern
extends MowzieEntity {
    public static final Animation DIE_ANIMATION = Animation.create(25);
    public static final Animation HURT_ANIMATION = Animation.create(10);
    public static final Animation PUFF_ANIMATION = Animation.create(28);
    private static final Animation[] ANIMATIONS = new Animation[]{DIE_ANIMATION, HURT_ANIMATION, PUFF_ANIMATION};
    public Vector3d dir = null;
    private int groundDist = 1;
    @OnlyIn(value=Dist.CLIENT)
    private Vector3d[] pos;

    public EntityLantern(EntityType<? extends EntityLantern> type, World world) {
        super(type, world);
        if (world.field_72995_K) {
            this.pos = new Vector3d[1];
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, new SimpleAnimationAI<EntityLantern>(this, PUFF_ANIMATION, false));
        this.field_70714_bg.func_75776_a(3, new AnimationTakeDamage<EntityLantern>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityLantern>(this));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MowzieEntity.createAttributes().func_233815_a_(Attributes.field_233818_a_, 4.0 * (double)((Float)ConfigHandler.MOBS.LANTERN.healthMultiplier.get()).floatValue()).func_233815_a_(Attributes.field_233822_e_, 0.3).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    public float func_70013_c() {
        return 1.572888E7f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getAnimation() == PUFF_ANIMATION && this.getAnimationTick() == 7) {
            if (this.groundDist == 0) {
                this.groundDist = 1;
            }
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.2 + 0.2 / (double)this.groundDist, 0.0));
            if (this.field_70170_p.field_72995_K) {
                int i;
                for (i = 0; i < 5; ++i) {
                    ParticleVanillaCloudExtended.spawnVanillaCloud(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.3, this.func_226281_cx_(), -this.func_213322_ci().func_82615_a() * 0.2 + 0.1 * ((double)this.field_70146_Z.nextFloat() - 0.5), -this.func_213322_ci().func_82617_b() * 0.2 + 0.1 * ((double)this.field_70146_Z.nextFloat() - 0.5), -this.func_213322_ci().func_82616_c() * 0.2 + 0.1 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.8 + this.field_70146_Z.nextDouble() * 1.0, 0.63671875, 0.96484375, 0.2890625, 0.95, 30.0);
                }
                for (i = 0; i < 8; ++i) {
                    AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), this.func_226277_ct_(), this.func_226278_cu_() + 0.3, this.func_226281_cx_(), -this.func_213322_ci().func_82615_a() * 0.2 + 0.2 * ((double)this.field_70146_Z.nextFloat() - 0.5), -this.func_213322_ci().func_82617_b() * 0.2 + 0.1 * ((double)this.field_70146_Z.nextFloat() - 0.5), -this.func_213322_ci().func_82616_c() * 0.2 + 0.2 * ((double)this.field_70146_Z.nextFloat() - 0.5), true, 0.0, 0.0, 0.0, 0.0, 4.0, 0.63671875, 0.96484375, 0.2890625, 1.0, 0.9, 17.0f + this.field_70146_Z.nextFloat() * 10.0f, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{4.0f, 0.0f}, new float[]{0.8f, 1.0f}), false)});
                }
            }
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_LANTERN_PUFF.get(), 0.6f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        if (!this.field_70170_p.field_72995_K && this.getAnimation() == NO_ANIMATION && (this.groundDist < 5 || this.field_70146_Z.nextInt(13) == 0 && this.groundDist < 16)) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, PUFF_ANIMATION);
        }
        if (this.groundDist >= 2) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.0055, 0.0));
        }
        if (this.field_70173_aa % 5 == 0) {
            int i;
            BlockPos checkPos = this.func_233580_cy_();
            for (i = 0; i < 16 && this.field_70170_p.func_180495_p(checkPos).func_177230_c() == Blocks.field_150350_a; ++i) {
                checkPos = checkPos.func_177977_b();
            }
            this.groundDist = i;
        }
        if (this.field_70170_p.field_72995_K && ((Boolean)ConfigHandler.CLIENT.glowEffect.get()).booleanValue()) {
            this.pos[0] = this.func_213303_ch().func_72441_c(0.0, (double)this.func_213302_cg() * 0.8, 0.0);
            if (this.field_70173_aa % 70 == 0) {
                AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.GLOW.get()), this.pos[0].field_72450_a, this.pos[0].field_72448_b, this.pos[0].field_72449_c, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 20.0, 0.8, 0.95, 0.35, 1.0, 1.0, 70.0, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{0.0f, 0.8f, 0.0f}, new float[]{0.0f, 0.5f, 1.0f}), false), new ParticleComponent.PinLocation(this.pos)});
            }
        }
    }

    @Override
    protected void onDeathAIUpdate() {
        super.onDeathAIUpdate();
        if (this.getAnimationTick() == 1 && this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197592_C, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.2 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.2 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.2 * ((double)this.field_70146_Z.nextFloat() - 0.5));
                this.field_70170_p.func_195594_a((IParticleData)new ParticleCloud.CloudData((ParticleType<ParticleCloud.CloudData>)((ParticleType)ParticleHandler.CLOUD.get()), 0.63671875f, 0.96484375f, 0.2890625f, 10.0f + this.field_70146_Z.nextFloat() * 20.0f, 30, ParticleCloud.EnumCloudBehavior.GROW, 0.9f), this.func_226277_ct_(), this.func_226278_cu_() + 0.3, this.func_226281_cx_(), 0.25 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.25 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.25 * ((double)this.field_70146_Z.nextFloat() - 0.5));
                this.field_70170_p.func_195594_a((IParticleData)new ParticleOrb.OrbData(0.63671875f, 0.96484375f, 0.2890625f, 1.5f, 25), this.func_226277_ct_(), this.func_226278_cu_() + 0.3, this.func_226281_cx_(), (double)(0.2f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(0.2f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(0.2f * (this.field_70146_Z.nextFloat() - 0.5f)));
            }
        }
        if (this.getAnimationTick() == 2) {
            this.func_184185_a((SoundEvent)MMSounds.ENTITY_LANTERN_POP.get(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        }
    }

    public void fall(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void func_213352_e(Vector3d movement) {
        if (this.func_70090_H()) {
            this.func_213309_a(0.02f, movement);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)0.8f));
        } else if (this.func_180799_ab()) {
            this.func_213309_a(0.02f, movement);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
        } else {
            BlockPos ground = new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b - 1.0, this.func_226281_cx_());
            float f = 0.91f;
            if (this.func_233570_aj_()) {
                f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.func_233570_aj_()) {
                f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            this.func_213309_a(this.func_233570_aj_() ? 0.1f * f1 : 0.02f, movement);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)f));
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.func_226277_ct_() - this.field_70169_q;
        double d0 = this.func_226281_cx_() - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    @Override
    protected ConfigHandler.SpawnConfig getSpawnConfig() {
        return ConfigHandler.MOBS.LANTERN.spawnConfig;
    }

    public boolean func_70617_f_() {
        return false;
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    @Override
    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.LANTERN;
    }
}

