/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message;

import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerBarakoTrade;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageBarakoTrade {
    private int entityID;

    public MessageBarakoTrade() {
    }

    public MessageBarakoTrade(LivingEntity sender) {
        this.entityID = sender.func_145782_y();
    }

    public static void serialize(MessageBarakoTrade message, PacketBuffer buf) {
        buf.func_150787_b(message.entityID);
    }

    public static MessageBarakoTrade deserialize(PacketBuffer buf) {
        MessageBarakoTrade message = new MessageBarakoTrade();
        message.entityID = buf.func_150792_a();
        return message;
    }

    public static class Handler
    implements BiConsumer<MessageBarakoTrade, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(MessageBarakoTrade message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            ServerPlayerEntity player = context.getSender();
            context.enqueueWork(() -> {
                if (player != null) {
                    Entity entity = player.field_70170_p.func_73045_a(message.entityID);
                    if (!(entity instanceof EntityBarako)) {
                        return;
                    }
                    EntityBarako barako = (EntityBarako)entity;
                    if (barako.getCustomer() != player) {
                        return;
                    }
                    Container container = player.field_71070_bA;
                    if (!(container instanceof ContainerBarakoTrade)) {
                        return;
                    }
                    boolean satisfied = barako.hasTradedWith((PlayerEntity)player);
                    if (!satisfied && (satisfied = barako.fulfillDesire(container.func_75139_a(0)))) {
                        barako.rememberTrade((PlayerEntity)player);
                        ((ContainerBarakoTrade)container).returnItems();
                        container.func_75142_b();
                    }
                    if (satisfied) {
                        player.func_195064_c(new EffectInstance((Effect)PotionHandler.SUNS_BLESSING, 72000, 0, false, false));
                        if (barako.getAnimation() != EntityBarako.BLESS_ANIMATION) {
                            barako.setAnimationTick(0);
                            AnimationHandler.INSTANCE.sendAnimationMessage(barako, EntityBarako.BLESS_ANIMATION);
                            barako.func_184185_a((SoundEvent)MMSounds.ENTITY_BARAKO_BLESS.get(), 2.0f, 1.0f);
                        }
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

