/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message;

import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessagePlayerSummonSunstrike {
    private static final double REACH = 15.0;

    private static BlockRayTraceResult rayTrace(LivingEntity entity, double reach) {
        Vector3d pos = entity.func_174824_e(0.0f);
        Vector3d segment = entity.func_70040_Z();
        segment = pos.func_72441_c(segment.field_72450_a * reach, segment.field_72448_b * reach, segment.field_72449_c * reach);
        return entity.field_70170_p.func_217299_a(new RayTraceContext(pos, segment, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity));
    }

    public static void serialize(MessagePlayerSummonSunstrike message, PacketBuffer buf) {
    }

    public static MessagePlayerSummonSunstrike deserialize(PacketBuffer buf) {
        MessagePlayerSummonSunstrike message = new MessagePlayerSummonSunstrike();
        return message;
    }

    public static class Handler
    implements BiConsumer<MessagePlayerSummonSunstrike, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(MessagePlayerSummonSunstrike message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            ServerPlayerEntity player = context.getSender();
            context.enqueueWork(() -> {
                BlockRayTraceResult raytrace = MessagePlayerSummonSunstrike.rayTrace((LivingEntity)player, 15.0);
                if (raytrace.func_216346_c() == RayTraceResult.Type.BLOCK && raytrace.func_216354_b() == Direction.UP && player.field_71071_by.func_70448_g().func_190926_b() && player.func_70644_a((Effect)PotionHandler.SUNS_BLESSING)) {
                    BlockPos hit = raytrace.func_216350_a();
                    EntitySunstrike sunstrike = new EntitySunstrike(EntityHandler.SUNSTRIKE, player.field_70170_p, (LivingEntity)player, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p());
                    sunstrike.onSummon();
                    player.field_70170_p.func_217376_c((Entity)sunstrike);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

