/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoaya;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import com.bobmowzie.mowziesmobs.server.item.ItemBarakoaMask;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.FeatureHandler;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sun.javafx.geom.Vec2f;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.ScatteredStructurePiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class BarakoaVillagePieces {
    private static final Set<Block> BLOCKS_NEEDING_POSTPROCESSING = ImmutableSet.builder().add((Object)Blocks.field_150386_bk).add((Object)Blocks.field_150478_aa).add((Object)Blocks.field_196591_bQ).add((Object)Blocks.field_180407_aO).add((Object)Blocks.field_180408_aP).add((Object)Blocks.field_180406_aS).add((Object)Blocks.field_180405_aT).add((Object)Blocks.field_180404_aQ).add((Object)Blocks.field_180403_aR).add((Object)Blocks.field_150468_ap).add((Object)Blocks.field_150411_aY).add((Object)Blocks.field_196703_eM).build();
    public static final ResourceLocation HOUSE = new ResourceLocation("mowziesmobs", "barakoa_house");
    public static final ResourceLocation ROOF = new ResourceLocation("mowziesmobs", "barakoa_house_roof");
    public static final ResourceLocation HOUSE_SIDE = new ResourceLocation("mowziesmobs", "barakoa_house_side");
    public static final ResourceLocation THRONE = new ResourceLocation("mowziesmobs", "barako_throne");
    private static final Map<ResourceLocation, BlockPos> OFFSET = ImmutableMap.of((Object)HOUSE, (Object)new BlockPos(-3, 1, -3), (Object)ROOF, (Object)new BlockPos(-3, 5, -3), (Object)HOUSE_SIDE, (Object)new BlockPos(2, 1, -2), (Object)THRONE, (Object)new BlockPos(-3, 0, 0));

    public static StructurePiece addPiece(ResourceLocation resourceLocation, TemplateManager manager, BlockPos pos, Rotation rot, List<StructurePiece> pieces, Random rand) {
        BlockPos placementOffset = OFFSET.get(resourceLocation);
        BlockPos blockPos = pos.func_177971_a((Vector3i)placementOffset.func_190942_a(rot));
        Piece newPiece = new Piece(manager, resourceLocation, blockPos, rot);
        pieces.add((StructurePiece)newPiece);
        return newPiece;
    }

    public static StructurePiece addPieceCheckBounds(ResourceLocation resourceLocation, TemplateManager manager, BlockPos pos, Rotation rot, List<StructurePiece> pieces, Random rand, List<StructurePiece> ignore) {
        BlockPos placementOffset = OFFSET.get(resourceLocation);
        BlockPos blockPos = pos.func_177971_a((Vector3i)placementOffset.func_190942_a(rot));
        Piece newPiece = new Piece(manager, resourceLocation, blockPos, rot);
        for (StructurePiece piece : pieces) {
            if (ignore.contains(piece) || !newPiece.func_74874_b().func_78884_a(piece.func_74874_b())) continue;
            return null;
        }
        pieces.add((StructurePiece)newPiece);
        return newPiece;
    }

    public static StructurePiece addHouse(TemplateManager manager, BlockPos pos, Rotation rot, List<StructurePiece> pieces, Random rand) {
        ResourceLocation resourceLocation = HOUSE;
        BlockPos placementOffset = OFFSET.get(resourceLocation);
        BlockPos blockPos = pos.func_177971_a((Vector3i)placementOffset.func_190942_a(rot));
        HousePiece newPiece = new HousePiece(manager, resourceLocation, blockPos, rot);
        for (StructurePiece piece : pieces) {
            if (!newPiece.func_74874_b().func_78884_a(piece.func_74874_b())) continue;
            return null;
        }
        pieces.add((StructurePiece)newPiece);
        newPiece.tableCorner = rand.nextInt(6);
        newPiece.tableContent = rand.nextInt(4);
        newPiece.bedCorner = rand.nextInt(6);
        newPiece.bedDirection = rand.nextInt(2);
        newPiece.chestCorner = rand.nextInt(6);
        newPiece.chestDirection = rand.nextInt(2);
        return newPiece;
    }

    public static StructurePiece addPieceCheckBounds(ResourceLocation resourceLocation, TemplateManager manager, BlockPos pos, Rotation rot, List<StructurePiece> pieces, Random rand) {
        return BarakoaVillagePieces.addPieceCheckBounds(resourceLocation, manager, pos, rot, pieces, rand, Collections.emptyList());
    }

    public static class AltarPiece
    extends NonTemplatePiece {
        public AltarPiece(Random random, int x, int y, int z) {
            super(FeatureHandler.BARAKOA_VILLAGE_ALTAR, random, x - 2, y - 1, z - 2, 5, 4, 5);
        }

        public AltarPiece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(FeatureHandler.BARAKOA_VILLAGE_STAKE, tagCompound);
        }

        public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            Vec2f[] fenceSkullPositions;
            Vec2f[] groundSkullPositions;
            Vec2f[] hayPositions;
            for (Vec2f pos : hayPositions = new Vec2f[]{new Vec2f(0.0f, 1.0f), new Vec2f(0.0f, 2.0f), new Vec2f(0.0f, 3.0f), new Vec2f(1.0f, 0.0f), new Vec2f(1.0f, 1.0f), new Vec2f(1.0f, 2.0f), new Vec2f(1.0f, 3.0f), new Vec2f(1.0f, 4.0f), new Vec2f(2.0f, 0.0f), new Vec2f(2.0f, 1.0f), new Vec2f(2.0f, 2.0f), new Vec2f(2.0f, 3.0f), new Vec2f(2.0f, 4.0f), new Vec2f(3.0f, 0.0f), new Vec2f(3.0f, 1.0f), new Vec2f(3.0f, 2.0f), new Vec2f(3.0f, 3.0f), new Vec2f(3.0f, 4.0f), new Vec2f(4.0f, 1.0f), new Vec2f(4.0f, 2.0f), new Vec2f(4.0f, 3.0f)}) {
                BlockPos placePos = this.findGround((IWorld)worldIn, (int)pos.x, (int)pos.y).func_177977_b();
                worldIn.func_180501_a(placePos, Blocks.field_150407_cf.func_176223_P(), 2);
            }
            for (Vec2f pos : groundSkullPositions = new Vec2f[]{new Vec2f(0.0f, 1.0f), new Vec2f(0.0f, 3.0f), new Vec2f(2.0f, 4.0f), new Vec2f(3.0f, 3.0f), new Vec2f(4.0f, 2.0f)}) {
                this.setBlockState((IWorld)worldIn, this.findGround((IWorld)worldIn, (int)pos.x, (int)pos.y), (BlockState)Blocks.field_196703_eM.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208138_am, (Comparable)Integer.valueOf(randomIn.nextInt(16))));
            }
            for (Vec2f pos : fenceSkullPositions = new Vec2f[]{new Vec2f(0.0f, 2.0f), new Vec2f(1.0f, 4.0f), new Vec2f(3.0f, 4.0f), new Vec2f(4.0f, 1.0f), new Vec2f(4.0f, 3.0f)}) {
                BlockPos groundPos = this.findGround((IWorld)worldIn, (int)pos.x, (int)pos.y);
                this.setBlockState((IWorld)worldIn, groundPos, Blocks.field_180407_aO.func_176223_P());
                this.setBlockState((IWorld)worldIn, groundPos.func_177984_a(), (BlockState)Blocks.field_196703_eM.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208138_am, (Comparable)Integer.valueOf(randomIn.nextInt(16))));
            }
            return true;
        }

        @Override
        public BlockPos findGround(IWorld worldIn, int x, int z) {
            int i = this.func_74865_a(x, z);
            int k = this.func_74873_b(x, z);
            int j = worldIn.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, i, k);
            return new BlockPos(i, j, k);
        }
    }

    public static class StakePiece
    extends NonTemplatePiece {
        private final boolean skull;
        private final int skullDir;

        public StakePiece(Random random, int x, int y, int z) {
            super(FeatureHandler.BARAKOA_VILLAGE_STAKE, random, x, y, z, 1, 3, 1);
            this.skull = random.nextBoolean();
            this.skullDir = random.nextInt(16);
        }

        public StakePiece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(FeatureHandler.BARAKOA_VILLAGE_STAKE, tagCompound);
            this.skull = tagCompound.func_74767_n("Skull");
            this.skullDir = tagCompound.func_74762_e("SkullDir");
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("Skull", this.skull);
            tagCompound.func_74768_a("SkullDir", this.skullDir);
        }

        public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox mutableBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 0, 1, 0, mutableBoundingBoxIn);
            if (this.skull) {
                this.func_175811_a(worldIn, (BlockState)Blocks.field_196703_eM.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208138_am, (Comparable)Integer.valueOf(this.skullDir)), 0, 2, 0, mutableBoundingBoxIn);
            } else {
                this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P(), 0, 2, 0, mutableBoundingBoxIn);
            }
            this.fillAirLiquidBelowHeightmap((IWorld)worldIn, Blocks.field_180407_aO.func_176223_P(), 0, 0);
            return true;
        }
    }

    public static class FirepitPiece
    extends NonTemplatePiece {
        public FirepitPiece(Random random, int x, int z) {
            super(FeatureHandler.BARAKOA_VILLAGE_FIREPIT, random, x, 64, z, 9, 3, 9);
        }

        public FirepitPiece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(FeatureHandler.BARAKOA_VILLAGE_FIREPIT, tagCompound);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
        }

        public boolean func_230383_a_(ISeedReader worldIn, StructureManager structureManager, ChunkGenerator chunkGenerator, Random randomIn, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            Vec2f[] positions;
            BlockPos centerPos = this.findGround((IWorld)worldIn, 4, 4);
            worldIn.func_180501_a(centerPos, Blocks.field_222433_lV.func_176223_P(), 2);
            this.fillAirLiquidBelowHeightmap((IWorld)worldIn, Blocks.field_196621_O.func_176223_P(), 4, 4);
            for (Vec2f pos : positions = new Vec2f[]{new Vec2f(0.0f, 3.0f), new Vec2f(0.0f, 5.0f), new Vec2f(8.0f, 3.0f), new Vec2f(8.0f, 5.0f), new Vec2f(3.0f, 0.0f), new Vec2f(5.0f, 0.0f), new Vec2f(3.0f, 8.0f), new Vec2f(5.0f, 8.0f), new Vec2f(1.0f, 1.0f), new Vec2f(1.0f, 7.0f), new Vec2f(7.0f, 1.0f), new Vec2f(7.0f, 7.0f)}) {
                worldIn.func_180501_a(this.findGround((IWorld)worldIn, (int)pos.x, (int)pos.y), Blocks.field_196621_O.func_176223_P(), 2);
                this.fillAirLiquidBelowHeightmap((IWorld)worldIn, Blocks.field_196621_O.func_176223_P(), (int)pos.x, (int)pos.y);
            }
            int numBarakoa = randomIn.nextInt(10) + 7;
            block1: for (int i = 1; i <= numBarakoa; ++i) {
                EntityBarakoaya barakoa = new EntityBarakoaya((EntityType<? extends EntityBarakoaya>)EntityHandler.BARAKOAYA, (World)worldIn.func_201672_e());
                for (int j = 1; j <= 20; ++j) {
                    int distance = randomIn.nextInt(10) + 2;
                    int angle = randomIn.nextInt(360);
                    int x = (int)((double)distance * Math.sin(Math.toRadians(angle))) + 4;
                    int z = (int)((double)distance * Math.cos(Math.toRadians(angle))) + 4;
                    BlockPos bPos = this.findGround((IWorld)worldIn, x, z);
                    barakoa.func_70107_b(bPos.func_177958_n(), bPos.func_177956_o(), bPos.func_177952_p());
                    if (bPos.func_177956_o() <= 0 || !barakoa.func_213380_a((IWorld)worldIn, SpawnReason.STRUCTURE) || !worldIn.func_226664_a_(barakoa.func_174813_aQ())) continue;
                    barakoa.func_213386_a((IServerWorld)worldIn, worldIn.func_175649_E(barakoa.func_233580_cy_()), SpawnReason.STRUCTURE, null, null);
                    barakoa.func_213390_a(centerPos, 16);
                    worldIn.func_217376_c((Entity)barakoa);
                    continue block1;
                }
            }
            return true;
        }
    }

    public static abstract class NonTemplatePiece
    extends ScatteredStructurePiece {
        protected NonTemplatePiece(IStructurePieceType structurePieceTypeIn, Random rand, int xIn, int yIn, int zIn, int widthIn, int heightIn, int depthIn) {
            super(structurePieceTypeIn, rand, xIn, yIn, zIn, widthIn, heightIn, depthIn);
        }

        protected NonTemplatePiece(IStructurePieceType structurePieceTypeIn, CompoundNBT nbt) {
            super(structurePieceTypeIn, nbt);
        }

        public BlockPos findGround(IWorld worldIn, int x, int z) {
            int i = this.func_74865_a(x, z);
            int k = this.func_74873_b(x, z);
            int j = worldIn.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, i, k);
            return new BlockPos(i, j, k);
        }

        public void fillAirLiquidBelowHeightmap(IWorld worldIn, BlockState state, int x, int z) {
            int i = this.func_74865_a(x, z);
            int k = this.func_74873_b(x, z);
            for (int j = worldIn.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, i, k) - 2; !Block.func_220064_c((IBlockReader)worldIn, (BlockPos)new BlockPos(i, j, k)) && j > 1; --j) {
                BlockPos pos = new BlockPos(i, j, k);
                FluidState ifluidstate = worldIn.func_204610_c(pos);
                BlockState toPut = state;
                if (!ifluidstate.func_206888_e()) {
                    worldIn.func_205219_F_().func_205360_a(pos, (Object)ifluidstate.func_206886_c(), 0);
                    if (toPut.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                        toPut = (BlockState)toPut.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
                    }
                }
                worldIn.func_180501_a(pos, toPut, 2);
                if (!BLOCKS_NEEDING_POSTPROCESSING.contains(state.func_177230_c())) continue;
                worldIn.func_217349_x(pos).func_201594_d(pos);
            }
        }

        protected void setBlockState(IWorld worldIn, BlockPos pos, BlockState state) {
            FluidState ifluidstate = worldIn.func_204610_c(pos);
            if (!ifluidstate.func_206888_e()) {
                worldIn.func_205219_F_().func_205360_a(pos, (Object)ifluidstate.func_206886_c(), 0);
                if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                    state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
                }
            }
            worldIn.func_180501_a(pos, state, 2);
            if (BLOCKS_NEEDING_POSTPROCESSING.contains(state.func_177230_c())) {
                worldIn.func_217349_x(pos).func_201594_d(pos);
            }
        }
    }

    public static class HousePiece
    extends Piece {
        private int tableCorner;
        private int tableContent;
        private int bedCorner;
        private int bedDirection;
        private int chestCorner;
        private int chestDirection;

        public HousePiece(TemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotationIn) {
            super(templateManagerIn, resourceLocationIn, pos, rotationIn);
        }

        public HousePiece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(templateManagerIn, tagCompound);
            this.tableCorner = tagCompound.func_74762_e("TableCorner");
            this.tableContent = tagCompound.func_74762_e("TableContent");
            this.bedCorner = tagCompound.func_74762_e("BedCorner");
            this.bedDirection = tagCompound.func_74762_e("bedDirection");
            this.chestCorner = tagCompound.func_74762_e("ChestCorner");
            this.chestDirection = tagCompound.func_74762_e("ChestDirection");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("TableCorner", this.tableCorner);
            tagCompound.func_74768_a("TableContent", this.tableContent);
            tagCompound.func_74768_a("BedCorner", this.bedCorner);
            tagCompound.func_74768_a("bedDirection", this.bedDirection);
            tagCompound.func_74768_a("ChestCorner", this.chestCorner);
            tagCompound.func_74768_a("ChestDirection", this.chestDirection);
        }

        @Override
        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            super.func_186175_a(function, pos, worldIn, rand, sbb);
            if ("corner".equals(function.substring(0, function.length() - 1))) {
                this.setBlockState((IWorld)worldIn, pos, Blocks.field_150350_a.func_176223_P());
                pos = pos.func_177977_b();
                int whichCorner = Integer.parseInt(function.substring(function.length() - 1));
                Rotation cornerRotation = Rotation.values()[4 - whichCorner];
                if (whichCorner == this.tableCorner) {
                    this.setBlockState((IWorld)worldIn, pos, (BlockState)Blocks.field_196632_bu.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP));
                    if (this.tableContent <= 1) {
                        this.setBlockState((IWorld)worldIn, pos.func_177984_a(), Blocks.field_150478_aa.func_176223_P());
                    } else if (this.tableContent == 2) {
                        int skullRot = cornerRotation.func_185833_a(this.field_186169_c.func_185833_a(2, 16), 16);
                        this.setBlockState((IWorld)worldIn, pos.func_177984_a(), (BlockState)Blocks.field_196703_eM.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208138_am, (Comparable)Integer.valueOf(skullRot)));
                    }
                } else if (whichCorner == this.bedCorner) {
                    this.setBlockState((IWorld)worldIn, pos, Blocks.field_196731_fL.func_176223_P());
                    BlockPos offset = new BlockPos(1, 0, 0);
                    if (this.bedDirection == 1) {
                        offset = new BlockPos(0, 0, -1);
                    }
                    offset = offset.func_190942_a(this.field_186169_c);
                    offset = offset.func_190942_a(cornerRotation);
                    this.setBlockState((IWorld)worldIn, pos.func_177971_a((Vector3i)offset), Blocks.field_196731_fL.func_176223_P());
                } else if (whichCorner == this.chestCorner) {
                    Direction facing = Direction.NORTH;
                    if (this.chestDirection == 1) {
                        facing = Direction.EAST;
                    }
                    facing = this.field_186169_c.func_185831_a(facing);
                    facing = cornerRotation.func_185831_a(facing);
                    this.func_191080_a(worldIn, sbb, rand, pos, LootTableHandler.BARAKOA_VILLAGE_HOUSE, (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)facing));
                } else {
                    this.setBlockState((IWorld)worldIn, pos, Blocks.field_150350_a.func_176223_P());
                }
            }
            if ("mask".equals(function)) {
                this.setBlockState((IWorld)worldIn, pos, Blocks.field_150350_a.func_176223_P());
                ItemFrameEntity itemFrame = new ItemFrameEntity((World)worldIn.func_201672_e(), pos, this.field_186169_c.func_185831_a(Direction.EAST));
                int i = rand.nextInt(MaskType.values().length);
                MaskType type = MaskType.values()[i];
                ItemBarakoaMask mask = ItemHandler.BARAKOA_MASK_FURY;
                switch (type) {
                    case BLISS: {
                        mask = ItemHandler.BARAKOA_MASK_BLISS;
                        break;
                    }
                    case FEAR: {
                        mask = ItemHandler.BARAKOA_MASK_FEAR;
                        break;
                    }
                    case FURY: {
                        mask = ItemHandler.BARAKOA_MASK_FURY;
                        break;
                    }
                    case MISERY: {
                        mask = ItemHandler.BARAKOA_MASK_MISERY;
                        break;
                    }
                    case RAGE: {
                        mask = ItemHandler.BARAKOA_MASK_RAGE;
                    }
                }
                ItemStack stack = new ItemStack((IItemProvider)mask);
                itemFrame.func_174864_a(stack, false);
                worldIn.func_217376_c((Entity)itemFrame);
            }
        }
    }

    public static class Piece
    extends TemplateStructurePiece {
        protected ResourceLocation resourceLocation;
        protected Rotation field_186169_c;

        public Piece(TemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotationIn) {
            super(FeatureHandler.BARAKOA_VILLAGE_PIECE, 0);
            this.resourceLocation = resourceLocationIn;
            this.field_186178_c = pos;
            this.field_186169_c = rotationIn;
            this.setupPiece(templateManagerIn);
        }

        public Piece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(FeatureHandler.BARAKOA_VILLAGE_PIECE, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.field_186169_c = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.setupPiece(templateManagerIn);
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.field_186169_c.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("support".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_180407_aO.func_176223_P(), 3);
                this.fillAirLiquidDown((IWorld)worldIn, Blocks.field_180407_aO.func_176223_P(), pos.func_177977_b());
            } else if ("leg".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_196621_O.func_176223_P(), 3);
                this.fillAirLiquidDown((IWorld)worldIn, Blocks.field_196621_O.func_176223_P(), pos.func_177977_b());
            } else if ("stairs".equals(function)) {
                Direction stairDirection = Direction.EAST;
                stairDirection = this.field_186169_c.func_185831_a(stairDirection);
                this.setBlockState((IWorld)worldIn, pos.func_177967_a(Direction.UP, 1), Blocks.field_150350_a.func_176223_P());
                this.setBlockState((IWorld)worldIn, pos.func_177967_a(Direction.UP, 2), Blocks.field_150350_a.func_176223_P());
                this.setBlockState((IWorld)worldIn, pos, (BlockState)Blocks.field_150485_bF.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)stairDirection.func_176734_d()));
                pos = pos.func_177972_a(Direction.DOWN);
                this.setBlockState((IWorld)worldIn, pos, (BlockState)((BlockState)Blocks.field_150485_bF.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)stairDirection)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP));
                for (int i = 1; i < 20 && !Block.func_220064_c((IBlockReader)worldIn, (BlockPos)(pos = pos.func_177972_a(stairDirection))); ++i) {
                    this.setBlockState((IWorld)worldIn, pos, (BlockState)Blocks.field_150485_bF.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)stairDirection.func_176734_d()));
                    pos = pos.func_177972_a(Direction.DOWN);
                    this.setBlockState((IWorld)worldIn, pos, (BlockState)((BlockState)Blocks.field_150485_bF.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)stairDirection)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP));
                }
            } else if ("barako".equals(function)) {
                this.setBlockState((IWorld)worldIn, pos, Blocks.field_150350_a.func_176223_P());
                EntityBarako barako = new EntityBarako((EntityType<? extends EntityBarako>)EntityHandler.BARAKO, (World)worldIn.func_201672_e());
                barako.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                int i = this.field_186169_c.func_185833_a(3, 4);
                barako.setDirection(i);
                worldIn.func_217376_c((Entity)barako);
                barako.func_213386_a(worldIn, worldIn.func_175649_E(barako.func_233580_cy_()), SpawnReason.STRUCTURE, null, null);
            }
        }

        protected void setBlockState(IWorld worldIn, BlockPos pos, BlockState state) {
            FluidState ifluidstate = worldIn.func_204610_c(pos);
            if (!ifluidstate.func_206888_e()) {
                worldIn.func_205219_F_().func_205360_a(pos, (Object)ifluidstate.func_206886_c(), 0);
                if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                    state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
                }
            }
            worldIn.func_180501_a(pos, state, 2);
            if (BLOCKS_NEEDING_POSTPROCESSING.contains(state.func_177230_c())) {
                worldIn.func_217349_x(pos).func_201594_d(pos);
            }
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE);
            BlockPos blockpos = (BlockPos)OFFSET.get(this.resourceLocation);
            this.field_186178_c.func_177971_a((Vector3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(0 - blockpos.func_177958_n(), 0, 0 - blockpos.func_177952_p())));
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }

        public void fillAirLiquidDown(IWorld worldIn, BlockState state, BlockPos startPos) {
            int i = startPos.func_177958_n();
            int k = startPos.func_177952_p();
            for (int j = startPos.func_177956_o(); !Block.func_220064_c((IBlockReader)worldIn, (BlockPos)new BlockPos(i, j, k)) && j > 1; --j) {
                BlockPos pos = new BlockPos(i, j, k);
                this.setBlockState(worldIn, pos, state);
            }
        }
    }
}

