/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.BarakoaVillagePieces;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.MowzieStructure;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class BarakoaVillageStructure
extends MowzieStructure {
    public BarakoaVillageStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    @Override
    public ConfigHandler.GenerationConfig getGenerationConfig() {
        return ConfigHandler.MOBS.BARAKO.generationConfig;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistryManager, ChunkGenerator generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            int angle;
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            BlockPos centerPos = new BlockPos(x, 1, z);
            this.field_75075_a.add(new BarakoaVillagePieces.FirepitPiece((Random)this.field_214631_d, x - 4, z - 4));
            BlockPos offset = new BlockPos(0, 0, 9);
            offset = offset.func_190942_a(rotation);
            BlockPos thronePos = this.posToSurface(generator, centerPos.func_177971_a((Vector3i)offset));
            BarakoaVillagePieces.addPiece(BarakoaVillagePieces.THRONE, templateManagerIn, thronePos, rotation, this.field_75075_a, (Random)this.field_214631_d);
            int numHouses = this.field_214631_d.nextInt(4) + 3;
            block0: for (int i = 1; i <= numHouses; ++i) {
                for (int j = 0; j < 30; ++j) {
                    float distance = this.field_214631_d.nextInt(8) + 10;
                    angle = this.field_214631_d.nextInt(360);
                    BlockPos housePos = new BlockPos((double)centerPos.func_177958_n() + (double)distance * Math.sin(Math.toRadians(angle)), 0.0, (double)centerPos.func_177952_p() + (double)distance * Math.cos(Math.toRadians(angle)));
                    housePos = this.posToSurface(generator, housePos);
                    if (this.startHouse(generator, templateManagerIn, housePos = housePos.func_177967_a(Direction.UP, this.field_214631_d.nextInt(2)))) continue block0;
                }
            }
            int numAltars = this.field_214631_d.nextInt(3) + 2;
            block2: for (int i = 1; i <= numAltars; ++i) {
                for (int j = 1; j <= 10; ++j) {
                    int distance = this.field_214631_d.nextInt(15) + 5;
                    angle = this.field_214631_d.nextInt(360);
                    BlockPos altarPos = new BlockPos((double)centerPos.func_177958_n() + (double)distance * Math.sin(Math.toRadians(angle)), 0.0, (double)centerPos.func_177952_p() + (double)distance * Math.cos(Math.toRadians(angle)));
                    altarPos = this.posToSurface(generator, altarPos);
                    BarakoaVillagePieces.AltarPiece altar = new BarakoaVillagePieces.AltarPiece((Random)this.field_214631_d, altarPos.func_177958_n(), altarPos.func_177956_o(), altarPos.func_177952_p());
                    boolean intersects = false;
                    for (StructurePiece piece : this.field_75075_a) {
                        if (!altar.func_74874_b().func_78884_a(piece.func_74874_b())) continue;
                        intersects = true;
                        break;
                    }
                    if (intersects) continue;
                    this.field_75075_a.add(altar);
                    continue block2;
                }
            }
            int numStakes = this.field_214631_d.nextInt(12) + 5;
            block5: for (int i = 1; i <= numStakes; ++i) {
                for (int j = 1; j <= 10; ++j) {
                    int distance = this.field_214631_d.nextInt(15) + 5;
                    int angle2 = this.field_214631_d.nextInt(360);
                    BlockPos stakePos = new BlockPos((double)centerPos.func_177958_n() + (double)distance * Math.sin(Math.toRadians(angle2)), 0.0, (double)centerPos.func_177952_p() + (double)distance * Math.cos(Math.toRadians(angle2)));
                    stakePos = this.posToSurface(generator, stakePos);
                    BarakoaVillagePieces.StakePiece stake = new BarakoaVillagePieces.StakePiece((Random)this.field_214631_d, stakePos.func_177958_n(), stakePos.func_177956_o(), stakePos.func_177952_p());
                    boolean intersects = false;
                    for (StructurePiece piece : this.field_75075_a) {
                        if (!stake.func_74874_b().func_78884_a(piece.func_74874_b())) continue;
                        intersects = true;
                        break;
                    }
                    if (intersects) continue;
                    this.field_75075_a.add(stake);
                    continue block5;
                }
            }
            this.func_202500_a();
        }

        private boolean startHouse(ChunkGenerator generator, TemplateManager templateManagerIn, BlockPos housePos) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            StructurePiece newHouse = BarakoaVillagePieces.addHouse(templateManagerIn, housePos, rotation, this.field_75075_a, (Random)this.field_214631_d);
            if (newHouse != null) {
                Rotation roofRotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
                StructurePiece roof = BarakoaVillagePieces.addPiece(BarakoaVillagePieces.ROOF, templateManagerIn, housePos, roofRotation, this.field_75075_a, (Random)this.field_214631_d);
                int sideHouseDir = this.field_214631_d.nextInt(6) + 1;
                if (sideHouseDir <= 2) {
                    Rotation sideHouseRotation;
                    Rotation rotation2 = sideHouseRotation = sideHouseDir == 1 ? rotation.func_185830_a(Rotation.CLOCKWISE_90) : rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
                    if (BarakoaVillagePieces.addPieceCheckBounds(BarakoaVillagePieces.HOUSE_SIDE, templateManagerIn, housePos, sideHouseRotation, this.field_75075_a, (Random)this.field_214631_d, Arrays.asList(newHouse, roof)) == null) {
                        sideHouseRotation = sideHouseRotation.func_185830_a(Rotation.CLOCKWISE_180);
                        BarakoaVillagePieces.addPieceCheckBounds(BarakoaVillagePieces.HOUSE_SIDE, templateManagerIn, housePos, sideHouseRotation, this.field_75075_a, (Random)this.field_214631_d, Arrays.asList(newHouse, roof));
                    }
                }
                return true;
            }
            return false;
        }

        private BlockPos posToSurface(ChunkGenerator generator, BlockPos pos) {
            int surfaceY = generator.func_222529_a(pos.func_177958_n(), pos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
            return new BlockPos(pos.func_177958_n(), surfaceY, pos.func_177952_p());
        }
    }
}

