/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.world.feature.FeatureHandler;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class FrostmawPieces {
    private static final ResourceLocation FROSTMAW = new ResourceLocation("mowziesmobs", "frostmaw_spawn");
    private static final Map<ResourceLocation, BlockPos> OFFSET = ImmutableMap.of((Object)FROSTMAW, (Object)new BlockPos(0, 1, 0));

    public static void start(TemplateManager manager, BlockPos pos, Rotation rot, List<StructurePiece> pieces, Random rand) {
        BlockPos rotationOffset = new BlockPos(0, 0, 0).func_190942_a(rot);
        BlockPos blockPos = rotationOffset.func_177971_a((Vector3i)pos);
        pieces.add((StructurePiece)new Piece(manager, FROSTMAW, blockPos, rot));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation resourceLocation;
        private final Rotation rotation;

        public Piece(TemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotationIn) {
            super(FeatureHandler.FROSTMAW_PIECE, 0);
            this.resourceLocation = resourceLocationIn;
            this.field_186178_c = pos;
            this.rotation = rotationIn;
            this.setupPiece(templateManagerIn);
        }

        public Piece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(FeatureHandler.FROSTMAW_PIECE, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.setupPiece(templateManagerIn);
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
        }

        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            BlockPos blockpos = (BlockPos)OFFSET.get(this.resourceLocation);
            this.field_186178_c.func_177971_a((Vector3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(0 - blockpos.func_177958_n(), blockpos.func_177956_o(), 0 - blockpos.func_177952_p())));
            return super.func_230383_a_(p_230383_1_, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
        }
    }
}

