/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.spawn;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.world.BiomeChecker;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class SpawnHandler {
    public static void registerSpawnPlacementTypes() {
        EntitySpawnPlacementRegistry.PlacementType.create((String)"MMSPAWN", (TriPredicate)new TriPredicate<IWorldReader, BlockPos, EntityType<? extends MobEntity>>(){

            public boolean test(IWorldReader t, BlockPos pos, EntityType<? extends MobEntity> entityType) {
                BlockState block = t.func_180495_p(pos.func_177977_b());
                if (block.func_177230_c() == Blocks.field_150357_h || block.func_177230_c() == Blocks.field_180401_cv || !block.func_185904_a().func_76230_c()) {
                    return false;
                }
                BlockState iblockstateUp = t.func_180495_p(pos);
                BlockState iblockstateUp2 = t.func_180495_p(pos.func_177984_a());
                return WorldEntitySpawner.func_234968_a_((IBlockReader)t, (BlockPos)pos, (BlockState)iblockstateUp, (FluidState)iblockstateUp.func_204520_s(), entityType) && WorldEntitySpawner.func_234968_a_((IBlockReader)t, (BlockPos)pos.func_177984_a(), (BlockState)iblockstateUp2, (FluidState)iblockstateUp2.func_204520_s(), entityType);
            }
        });
        EntitySpawnPlacementRegistry.PlacementType mmSpawn = EntitySpawnPlacementRegistry.PlacementType.valueOf((String)"MMSPAWN");
        if (mmSpawn != null) {
            EntitySpawnPlacementRegistry.func_209343_a(EntityHandler.FOLIAATH, (EntitySpawnPlacementRegistry.PlacementType)mmSpawn, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, MowzieEntity::spawnPredicate);
            EntitySpawnPlacementRegistry.func_209343_a(EntityHandler.LANTERN, (EntitySpawnPlacementRegistry.PlacementType)mmSpawn, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, MowzieEntity::spawnPredicate);
            EntitySpawnPlacementRegistry.func_209343_a(EntityHandler.BARAKOANA, (EntitySpawnPlacementRegistry.PlacementType)mmSpawn, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MowzieEntity::spawnPredicate);
            EntitySpawnPlacementRegistry.func_209343_a(EntityHandler.NAGA, (EntitySpawnPlacementRegistry.PlacementType)mmSpawn, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MowzieEntity::spawnPredicate);
        }
    }

    public static void onBiomeLoading(BiomeLoadingEvent event) {
        ResourceLocation biomeName = event.getName();
        if (biomeName == null) {
            return;
        }
        if ((Integer)ConfigHandler.MOBS.FOLIAATH.spawnConfig.spawnRate.get() > 0 && BiomeChecker.isBiomeInConfig(ConfigHandler.MOBS.FOLIAATH.spawnConfig.biomeConfig, biomeName)) {
            SpawnHandler.registerEntityWorldSpawn(EntityHandler.FOLIAATH, ConfigHandler.MOBS.FOLIAATH.spawnConfig, EntityClassification.MONSTER, event);
        }
        if ((Integer)ConfigHandler.MOBS.BARAKOA.spawnConfig.spawnRate.get() > 0 && BiomeChecker.isBiomeInConfig(ConfigHandler.MOBS.BARAKOA.spawnConfig.biomeConfig, biomeName)) {
            SpawnHandler.registerEntityWorldSpawn(EntityHandler.BARAKOANA, ConfigHandler.MOBS.BARAKOA.spawnConfig, EntityClassification.MONSTER, event);
        }
        if ((Integer)ConfigHandler.MOBS.GROTTOL.spawnConfig.spawnRate.get() > 0 && BiomeChecker.isBiomeInConfig(ConfigHandler.MOBS.GROTTOL.spawnConfig.biomeConfig, biomeName)) {
            SpawnHandler.registerEntityWorldSpawn(EntityHandler.GROTTOL, ConfigHandler.MOBS.GROTTOL.spawnConfig, EntityClassification.MONSTER, event);
        }
        if ((Integer)ConfigHandler.MOBS.LANTERN.spawnConfig.spawnRate.get() > 0 && BiomeChecker.isBiomeInConfig(ConfigHandler.MOBS.LANTERN.spawnConfig.biomeConfig, biomeName)) {
            SpawnHandler.registerEntityWorldSpawn(EntityHandler.LANTERN, ConfigHandler.MOBS.LANTERN.spawnConfig, EntityClassification.AMBIENT, event);
        }
        if ((Integer)ConfigHandler.MOBS.NAGA.spawnConfig.spawnRate.get() > 0 && BiomeChecker.isBiomeInConfig(ConfigHandler.MOBS.NAGA.spawnConfig.biomeConfig, biomeName)) {
            SpawnHandler.registerEntityWorldSpawn(EntityHandler.NAGA, ConfigHandler.MOBS.NAGA.spawnConfig, EntityClassification.MONSTER, event);
        }
    }

    private static void registerEntityWorldSpawn(EntityType<?> entity, ConfigHandler.SpawnConfig spawnConfig, EntityClassification classification, BiomeLoadingEvent event) {
        event.getSpawns().getSpawner(classification).add(new MobSpawnInfo.Spawners(entity, ((Integer)spawnConfig.spawnRate.get()).intValue(), ((Integer)spawnConfig.minGroupSize.get()).intValue(), ((Integer)spawnConfig.maxGroupSize.get()).intValue()));
    }
}

