/*
 * Decompiled with CFR 0.152.
 */
package com.ilexiconn.llibrary.client.model.tools;

import com.bobmowzie.mowziesmobs.client.render.RenderUtils;
import com.ilexiconn.llibrary.client.model.tools.AdvancedModelBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedModelRenderer
extends ModelRenderer {
    private static final float MINIMUM_SCALE = 1.0E-6f;
    public float defaultRotationX;
    public float defaultRotationY;
    public float defaultRotationZ;
    public float defaultPositionX;
    public float defaultPositionY;
    public float defaultPositionZ;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public float opacity = 1.0f;
    public boolean scaleChildren;
    private final AdvancedModelBase model;
    private AdvancedModelRenderer parent;
    private boolean doubleSided = true;
    private boolean hasLighting = true;
    private boolean isHidden = false;
    public ObjectList<ModelPart> field_78804_l;
    public ObjectList<ModelRenderer> field_78805_m;
    public int field_78803_o;
    public int field_78813_p;
    private float textureWidth;
    private float textureHeight;
    private Matrix3f mat3Override;
    private Matrix4f mat4Override;

    public AdvancedModelRenderer(AdvancedModelBase model) {
        this(model, 0, 0);
    }

    public AdvancedModelRenderer(AdvancedModelBase model, int textureOffsetX, int textureOffsetY) {
        super((Model)model, textureOffsetX, textureOffsetY);
        this.model = model;
        this.textureWidth = model.field_78090_t;
        this.textureHeight = model.field_78089_u;
        this.field_78803_o = textureOffsetX;
        this.field_78813_p = textureOffsetY;
        this.field_78804_l = new ObjectArrayList();
        this.field_78805_m = new ObjectArrayList();
    }

    public AdvancedModelRenderer(AdvancedModelRenderer copyFrom) {
        this(copyFrom.getModel(), copyFrom.field_78803_o, copyFrom.field_78813_p);
        this.field_78800_c = copyFrom.field_78800_c;
        this.field_78797_d = copyFrom.field_78797_d;
        this.field_78798_e = copyFrom.field_78798_e;
        this.field_78795_f = copyFrom.field_78795_f;
        this.field_78796_g = copyFrom.field_78796_g;
        this.field_78808_h = copyFrom.field_78808_h;
        this.scaleX = copyFrom.scaleX;
        this.scaleY = copyFrom.scaleY;
        this.scaleZ = copyFrom.scaleZ;
        this.defaultPositionX = copyFrom.defaultPositionX;
        this.defaultPositionY = copyFrom.defaultPositionY;
        this.defaultPositionZ = copyFrom.defaultPositionZ;
        this.defaultRotationX = copyFrom.defaultRotationX;
        this.defaultRotationY = copyFrom.defaultRotationY;
        this.defaultRotationZ = copyFrom.defaultRotationZ;
        this.scaleChildren = copyFrom.scaleChildren;
        this.field_78804_l.addAll(copyFrom.field_78804_l);
        this.field_78805_m = copyFrom.field_78805_m;
    }

    public ModelRenderer func_78787_b(int textureWidthIn, int textureHeightIn) {
        this.textureWidth = textureWidthIn;
        this.textureHeight = textureHeightIn;
        return super.func_78787_b(textureWidthIn, textureHeightIn);
    }

    public ModelRenderer func_78784_a(int x, int y) {
        this.field_78803_o = x;
        this.field_78813_p = y;
        return super.func_78784_a(x, y);
    }

    public AdvancedModelRenderer addBox(String partName, float x, float y, float z, int width, int height, int depth, float delta, int texX, int texY) {
        this.func_78784_a(texX, texY);
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, delta, delta, delta, this.field_78809_i, false);
        return this;
    }

    public AdvancedModelRenderer addBox(float x, float y, float z, float width, float height, float depth) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, 0.0f, 0.0f, 0.0f, this.field_78809_i, false);
        return this;
    }

    public AdvancedModelRenderer addBox(float x, float y, float z, float width, float height, float depth, boolean mirrorIn) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, 0.0f, 0.0f, 0.0f, mirrorIn, false);
        return this;
    }

    public void func_228301_a_(float x, float y, float z, float width, float height, float depth, float delta) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, delta, delta, delta, this.field_78809_i, false);
    }

    public void func_228302_a_(float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, this.field_78809_i, false);
    }

    public void func_228303_a_(float x, float y, float z, float width, float height, float depth, float delta, boolean mirrorIn) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, delta, delta, delta, mirrorIn, false);
    }

    private void addBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirror, boolean p_228305_13_) {
        this.field_78804_l.add((Object)new ModelBox(texOffX, texOffY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, mirror, this.textureWidth, this.textureHeight));
    }

    public void setShouldScaleChildren(boolean scaleChildren) {
        this.scaleChildren = scaleChildren;
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
        this.setScaleZ(scaleZ);
    }

    public void setScale(float scale) {
        this.setScaleX(scale);
        this.setScaleY(scale);
        this.setScaleZ(scale);
    }

    public void setScaleX(float scaleX) {
        this.scaleX = Math.max(1.0E-6f, scaleX);
    }

    public void setScaleY(float scaleY) {
        this.scaleY = Math.max(1.0E-6f, scaleY);
    }

    public void setScaleZ(float scaleZ) {
        this.scaleZ = Math.max(1.0E-6f, scaleZ);
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public void setHasLighting(boolean hasLighting) {
        this.hasLighting = hasLighting;
    }

    public void setDoubleSided(boolean doubleSided) {
        this.doubleSided = doubleSided;
    }

    public void setIsHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public float getTextureWidth() {
        return this.textureWidth;
    }

    public float getTextureHeight() {
        return this.textureHeight;
    }

    public void updateDefaultPose() {
        this.defaultRotationX = this.field_78795_f;
        this.defaultRotationY = this.field_78796_g;
        this.defaultRotationZ = this.field_78808_h;
        this.defaultPositionX = this.field_78800_c;
        this.defaultPositionY = this.field_78797_d;
        this.defaultPositionZ = this.field_78798_e;
    }

    public void resetToDefaultPose() {
        this.field_78795_f = this.defaultRotationX;
        this.field_78796_g = this.defaultRotationY;
        this.field_78808_h = this.defaultRotationZ;
        this.field_78800_c = this.defaultPositionX;
        this.field_78797_d = this.defaultPositionY;
        this.field_78798_e = this.defaultPositionZ;
    }

    public void func_78792_a(ModelRenderer renderer) {
        super.func_78792_a(renderer);
        this.field_78805_m.add((Object)renderer);
        if (renderer instanceof AdvancedModelRenderer) {
            AdvancedModelRenderer advancedChild = (AdvancedModelRenderer)renderer;
            advancedChild.setParent(this);
        }
    }

    public AdvancedModelRenderer getParent() {
        return this.parent;
    }

    public void setParent(AdvancedModelRenderer parent) {
        this.parent = parent;
    }

    public void func_228307_a_(MatrixStack matrixStackIn) {
        AdvancedModelRenderer parent = this.getParent();
        if (parent != null && !parent.scaleChildren) {
            matrixStackIn.func_227862_a_(1.0f / parent.scaleX, 1.0f / parent.scaleY, 1.0f / parent.scaleZ);
        }
        super.func_228307_a_(matrixStackIn);
        matrixStackIn.func_227862_a_(this.scaleX, this.scaleY, this.scaleZ);
    }

    public void func_228309_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (!(!this.field_78806_j || this.field_78804_l.isEmpty() && this.field_78805_m.isEmpty())) {
            matrixStackIn.func_227860_a_();
            this.func_228307_a_(matrixStackIn);
            if (!this.isHidden) {
                this.func_228306_a_(matrixStackIn.func_227866_c_(), bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha * this.opacity);
            }
            for (ModelRenderer modelrenderer : this.field_78805_m) {
                modelrenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    protected void func_228306_a_(MatrixStack.Entry matrixEntryIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixEntryIn.func_227870_a_();
        Matrix3f matrix3f = matrixEntryIn.func_227872_b_();
        if (this.mat3Override != null) {
            matrix3f = this.mat3Override;
        }
        if (this.mat4Override != null) {
            matrix4f = this.mat4Override;
        }
        for (ModelPart modelrenderer$modelbox : this.field_78804_l) {
            modelrenderer$modelbox.render(matrix4f, matrix3f, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }

    public AdvancedModelBase getModel() {
        return this.model;
    }

    private float calculateRotation(float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        float movementScale = this.model.getMovementScale();
        float rotation = MathHelper.func_76134_b((float)(f * (speed * movementScale) + offset)) * (degree * movementScale) * f1 + weight * f1;
        return invert ? -rotation : rotation;
    }

    public void walk(float speed, float degree, boolean invert, float offset, float weight, float walk, float walkAmount) {
        this.field_78795_f += this.calculateRotation(speed, degree, invert, offset, weight, walk, walkAmount);
    }

    public void flap(float speed, float degree, boolean invert, float offset, float weight, float flap, float flapAmount) {
        this.field_78808_h += this.calculateRotation(speed, degree, invert, offset, weight, flap, flapAmount);
    }

    public void swing(float speed, float degree, boolean invert, float offset, float weight, float swing, float swingAmount) {
        this.field_78796_g += this.calculateRotation(speed, degree, invert, offset, weight, swing, swingAmount);
    }

    public void bob(float speed, float degree, boolean bounce, float f, float f1) {
        float movementScale = this.model.getMovementScale();
        float bob = (float)(Math.sin(f * (speed *= movementScale)) * (double)f1 * (double)(degree *= movementScale) - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(Math.sin(f * speed) * (double)f1 * (double)degree));
        }
        this.field_78797_d += bob;
    }

    public void transitionTo(AdvancedModelRenderer to, float timer, float maxTime) {
        this.field_78795_f += (to.field_78795_f - this.field_78795_f) / maxTime * timer;
        this.field_78796_g += (to.field_78796_g - this.field_78796_g) / maxTime * timer;
        this.field_78808_h += (to.field_78808_h - this.field_78808_h) / maxTime * timer;
        this.field_78800_c += (to.field_78800_c - this.field_78800_c) / maxTime * timer;
        this.field_78797_d += (to.field_78797_d - this.field_78797_d) / maxTime * timer;
        this.field_78798_e += (to.field_78798_e - this.field_78798_e) / maxTime * timer;
    }

    public void setMatrixOverrides(Matrix3f mat3Override, Matrix4f mat4Override) {
        this.mat4Override = mat4Override;
        this.mat3Override = mat3Override;
    }

    public void clearMatrixOverrides() {
        this.mat3Override = null;
        this.mat4Override = null;
    }

    public void getMatrixStack(MatrixStack matrixStack) {
        AdvancedModelRenderer parent = this.getParent();
        if (parent != null) {
            parent.getMatrixStack(matrixStack);
        }
        this.func_228307_a_(matrixStack);
    }

    public Vector3d getWorldPos(Entity entity, float delta) {
        MatrixStack matrixStack = new MatrixStack();
        float dx = (float)(entity.field_70169_q + (entity.func_226277_ct_() - entity.field_70169_q) * (double)delta);
        float dy = (float)(entity.field_70167_r + (entity.func_226278_cu_() - entity.field_70167_r) * (double)delta);
        float dz = (float)(entity.field_70166_s + (entity.func_226281_cx_() - entity.field_70166_s) * (double)delta);
        matrixStack.func_227861_a_((double)dx, (double)dy, (double)dz);
        float dYaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * delta;
        matrixStack.func_227863_a_(new Quaternion(0.0f, -dYaw + 180.0f, 0.0f, true));
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStack.func_227861_a_(0.0, -1.5, 0.0);
        RenderUtils.matrixStackFromModel(matrixStack, this);
        MatrixStack.Entry matrixEntry = matrixStack.func_227866_c_();
        Matrix4f matrix4f = matrixEntry.func_227870_a_();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.func_229372_a_(matrix4f);
        return new Vector3d((double)vec.func_195910_a(), (double)vec.func_195913_b(), (double)vec.func_195914_c());
    }

    public void setWorldPos(Entity entity, Vector3d worldPos, float delta) {
        MatrixStack matrixStack = new MatrixStack();
        float dx = (float)(entity.field_70169_q + (entity.func_226277_ct_() - entity.field_70169_q) * (double)delta);
        float dy = (float)(entity.field_70167_r + (entity.func_226278_cu_() - entity.field_70167_r) * (double)delta);
        float dz = (float)(entity.field_70166_s + (entity.func_226281_cx_() - entity.field_70166_s) * (double)delta);
        matrixStack.func_227861_a_((double)dx, (double)dy, (double)dz);
        float dYaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * delta;
        matrixStack.func_227863_a_(new Quaternion(0.0f, -dYaw + 180.0f, 0.0f, true));
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStack.func_227861_a_(0.0, -1.5, 0.0);
        MatrixStack.Entry matrixEntry = matrixStack.func_227866_c_();
        Matrix4f matrix4f = matrixEntry.func_227870_a_();
        matrix4f.func_226600_c_();
        Vector4f vec = new Vector4f((float)worldPos.func_82615_a(), (float)worldPos.func_82617_b(), (float)worldPos.func_82616_c(), 1.0f);
        vec.func_229372_a_(matrix4f);
        this.field_78800_c = vec.func_195910_a() * 16.0f;
        this.field_78797_d = vec.func_195913_b() * 16.0f;
        this.field_78798_e = vec.func_195914_c() * 16.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class TexturedQuad {
        public final PositionTextureVertex[] vertexPositions;
        public final Vector3f normal;

        public TexturedQuad(PositionTextureVertex[] positionsIn, float u1, float v1, float u2, float v2, float texWidth, float texHeight, boolean mirrorIn, Direction directionIn) {
            this.vertexPositions = positionsIn;
            float f = 0.0f / texWidth;
            float f1 = 0.0f / texHeight;
            positionsIn[0] = positionsIn[0].setTextureUV(u2 / texWidth - f, v1 / texHeight + f1);
            positionsIn[1] = positionsIn[1].setTextureUV(u1 / texWidth + f, v1 / texHeight + f1);
            positionsIn[2] = positionsIn[2].setTextureUV(u1 / texWidth + f, v2 / texHeight - f1);
            positionsIn[3] = positionsIn[3].setTextureUV(u2 / texWidth - f, v2 / texHeight - f1);
            if (mirrorIn) {
                int i = positionsIn.length;
                for (int j = 0; j < i / 2; ++j) {
                    PositionTextureVertex modelrenderer$positiontexturevertex = positionsIn[j];
                    positionsIn[j] = positionsIn[i - 1 - j];
                    positionsIn[i - 1 - j] = modelrenderer$positiontexturevertex;
                }
            }
            this.normal = directionIn.func_229386_k_();
            if (mirrorIn) {
                this.normal.func_229192_b_(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class PositionTextureVertex {
        public final Vector3f position;
        public final float textureU;
        public final float textureV;

        public PositionTextureVertex(float x, float y, float z, float texU, float texV) {
            this(new Vector3f(x, y, z), texU, texV);
        }

        public PositionTextureVertex setTextureUV(float texU, float texV) {
            return new PositionTextureVertex(this.position, texU, texV);
        }

        public PositionTextureVertex(Vector3f posIn, float texU, float texV) {
            this.position = posIn;
            this.textureU = texU;
            this.textureV = texV;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ModelBox
    extends ModelPart {
        protected final TexturedQuad[] quads;
        public final float posX1;
        public final float posY1;
        public final float posZ1;
        public final float posX2;
        public final float posY2;
        public final float posZ2;

        public ModelBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirror, float texWidth, float texHeight) {
            this.posX1 = x;
            this.posY1 = y;
            this.posZ1 = z;
            this.posX2 = x + width;
            this.posY2 = y + height;
            this.posZ2 = z + depth;
            this.quads = new TexturedQuad[6];
            float f = x + width;
            float f1 = y + height;
            float f2 = z + depth;
            x -= deltaX;
            y -= deltaY;
            z -= deltaZ;
            f += deltaX;
            f1 += deltaY;
            f2 += deltaZ;
            if (mirror) {
                float f3 = f;
                f = x;
                x = f3;
            }
            PositionTextureVertex modelrenderer$positiontexturevertex7 = new PositionTextureVertex(x, y, z, 0.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex = new PositionTextureVertex(f, y, z, 0.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex1 = new PositionTextureVertex(f, f1, z, 8.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex2 = new PositionTextureVertex(x, f1, z, 8.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex3 = new PositionTextureVertex(x, y, f2, 0.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex4 = new PositionTextureVertex(f, y, f2, 0.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex5 = new PositionTextureVertex(f, f1, f2, 8.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex6 = new PositionTextureVertex(x, f1, f2, 8.0f, 0.0f);
            float f4 = texOffX;
            float f5 = (float)texOffX + depth;
            float f6 = (float)texOffX + depth + width;
            float f7 = (float)texOffX + depth + width + width;
            float f8 = (float)texOffX + depth + width + depth;
            float f9 = (float)texOffX + depth + width + depth + width;
            float f10 = texOffY;
            float f11 = (float)texOffY + depth;
            float f12 = (float)texOffY + depth + height;
            this.quads[2] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex}, f5, f10, f6, f11, texWidth, texHeight, mirror, Direction.DOWN);
            this.quads[3] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex1, modelrenderer$positiontexturevertex2, modelrenderer$positiontexturevertex6, modelrenderer$positiontexturevertex5}, f6, f11, f7, f10, texWidth, texHeight, mirror, Direction.UP);
            this.quads[1] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex6, modelrenderer$positiontexturevertex2}, f4, f11, f5, f12, texWidth, texHeight, mirror, Direction.WEST);
            this.quads[4] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex, modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex2, modelrenderer$positiontexturevertex1}, f5, f11, f6, f12, texWidth, texHeight, mirror, Direction.NORTH);
            this.quads[0] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex, modelrenderer$positiontexturevertex1, modelrenderer$positiontexturevertex5}, f6, f11, f8, f12, texWidth, texHeight, mirror, Direction.EAST);
            this.quads[5] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex5, modelrenderer$positiontexturevertex6}, f8, f11, f9, f12, texWidth, texHeight, mirror, Direction.SOUTH);
        }

        @Override
        public void render(Matrix4f matrix4f, Matrix3f matrix3f, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            for (TexturedQuad modelrenderer$texturedquad : this.quads) {
                Vector3f vector3f = modelrenderer$texturedquad.normal.func_229195_e_();
                vector3f.func_229188_a_(matrix3f);
                float f = vector3f.func_195899_a();
                float f1 = vector3f.func_195900_b();
                float f2 = vector3f.func_195902_c();
                for (int i = 0; i < 4; ++i) {
                    PositionTextureVertex modelrenderer$positiontexturevertex = modelrenderer$texturedquad.vertexPositions[i];
                    float f3 = modelrenderer$positiontexturevertex.position.func_195899_a() / 16.0f;
                    float f4 = modelrenderer$positiontexturevertex.position.func_195900_b() / 16.0f;
                    float f5 = modelrenderer$positiontexturevertex.position.func_195902_c() / 16.0f;
                    Vector4f vector4f = new Vector4f(f3, f4, f5, 1.0f);
                    vector4f.func_229372_a_(matrix4f);
                    bufferIn.func_225588_a_(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c(), red, green, blue, alpha, modelrenderer$positiontexturevertex.textureU, modelrenderer$positiontexturevertex.textureV, packedOverlayIn, packedLightIn, f, f1, f2);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class ModelPart {
        public void render(Matrix4f mat4, Matrix3f mat3, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        }
    }
}

