/*
 * Decompiled with CFR 0.152.
 */
package net.sirdizarm.nightlantern.objects.blocks;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.sirdizarm.nightlantern.init.TileEntitiesInit;
import net.sirdizarm.nightlantern.tileentity.TileEntityLanternLight;

public class LanternBlockBig
extends Block {
    public static final BooleanProperty LIT = BooleanProperty.func_177716_a((String)"lit");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape shape = Stream.of(Block.func_208617_a((double)8.0, (double)13.0, (double)6.5, (double)8.0, (double)15.0, (double)9.5), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), Block.func_208617_a((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), Block.func_208617_a((double)6.5, (double)13.0, (double)8.0, (double)9.5, (double)15.0, (double)8.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public LanternBlockBig(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean hasItFlies(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityLanternLight) {
            return ((TileEntityLanternLight)tileentity).hasflies;
        }
        return false;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        for (Direction direction : context.func_196009_e()) {
            BlockState blockstate;
            IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
            if (direction.func_176740_k() != Direction.Axis.Y || !(blockstate = (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(!context.func_195991_k().func_201675_m().isDaytime()))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a))).func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return blockstate;
        }
        return null;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        if (itemstack.func_190926_b()) {
            return ActionResultType.PASS;
        }
        boolean i = (Boolean)state.func_177229_b((IProperty)WATERLOGGED);
        Item item = itemstack.func_77973_b();
        if (item == Items.field_151131_as) {
            if (!i && !worldIn.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(handIn, new ItemStack((IItemProvider)Items.field_151133_ar));
                }
                this.setWaterLevel(worldIn, pos, state, true);
                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return ActionResultType.SUCCESS;
        }
        if (item == Items.field_151133_ar) {
            if (i && !worldIn.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                    if (itemstack.func_190926_b()) {
                        player.func_184611_a(handIn, new ItemStack((IItemProvider)Items.field_151131_as));
                    } else if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151131_as))) {
                        player.func_71019_a(new ItemStack((IItemProvider)Items.field_151131_as), false);
                    }
                }
                this.setWaterLevel(worldIn, pos, state, false);
                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void setWaterLevel(World worldIn, BlockPos pos, BlockState state, boolean level) {
        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(level)));
    }

    public static void updatePower(BlockState state, World world, BlockPos pos) {
        if (!world.field_73011_w.isDaytime()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
        } else {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntitiesInit.NIGHTLANTERN_BIG_TE.get()).func_200968_a();
    }

    public int func_149750_m(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? super.func_149750_m(state) : 0;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return shape;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{LIT, WATERLOGGED});
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = LanternBlockBig.func_220277_j(state).func_176734_d();
        BlockPos dust_pos = pos.func_177977_b();
        BlockState other = worldIn.func_180495_p(dust_pos);
        Block block = other.func_177230_c();
        if (block == Blocks.field_189881_dj) {
            return true;
        }
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177972_a(direction), (Direction)direction.func_176734_d());
    }

    protected static Direction func_220277_j(BlockState p_220277_0_) {
        return Direction.UP;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 30;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return LanternBlockBig.func_220277_j(stateIn).func_176734_d() == facing && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

