/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.block;

import com.infinityraider.infinitylib.block.BlockBase;
import com.infinityraider.infinitylib.block.ICustomRenderedBlock;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.render.block.IBlockRenderingHandler;
import com.infinityraider.ninjagear.api.v1.IRopeAttachable;
import com.infinityraider.ninjagear.item.ItemRope;
import com.infinityraider.ninjagear.registry.ItemRegistry;
import com.infinityraider.ninjagear.render.block.RenderBlockRope;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
public class BlockRope
extends BlockBase
implements ICustomRenderedBlock,
IRopeAttachable {
    private final AxisAlignedBB box;

    public BlockRope() {
        super("ropeBlock", Material.field_151582_l);
        float u = 0.0625f;
        this.box = new AxisAlignedBB(7.5 * (double)u, 0.0, 7.5 * (double)u, 8.5 * (double)u, 1.0, 8.5 * (double)u);
        this.func_149647_a(null);
    }

    public List<String> getOreTags() {
        return Collections.emptyList();
    }

    protected InfinityProperty[] getPropertyArray() {
        return new InfinityProperty[0];
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.canRopeStay(world, pos)) {
            this.breakRope(world, pos, state, false);
        }
    }

    public boolean canRopeStay(World world, BlockPos pos) {
        BlockPos up = pos.func_177984_a();
        IBlockState state = world.func_180495_p(up);
        if (state.isSideSolid((IBlockAccess)world, up, EnumFacing.DOWN)) {
            return true;
        }
        if (state.func_177230_c() instanceof IRopeAttachable) {
            IRopeAttachable attachable = (IRopeAttachable)state.func_177230_c();
            return attachable.canAttachRope(world, up, state);
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && this.canRopeStay(world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BlockPos up = pos.func_177984_a();
        IBlockState stateUp = world.func_180495_p(up);
        if (stateUp.func_177230_c() instanceof IRopeAttachable) {
            ((IRopeAttachable)stateUp.func_177230_c()).onRopeAttached(world, up, stateUp);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K && heldItem.func_77973_b() instanceof ItemRope && this.extendRope(world, pos) && !player.field_71075_bZ.field_75098_d) {
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
        }
        return false;
    }

    public boolean extendRope(World world, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        IBlockState state = world.func_180495_p(below);
        if (state.func_177230_c() instanceof BlockRope) {
            return ((BlockRope)state.func_177230_c()).extendRope(world, below);
        }
        if (this.func_176196_c(world, below)) {
            world.func_180501_a(below, this.func_176223_P(), 3);
            return true;
        }
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        this.breakRope(world, pos, world.func_180495_p(pos), player.func_70093_af());
    }

    public void breakRope(World world, BlockPos pos, IBlockState state, boolean propagateUp) {
        if (propagateUp) {
            this.propagateRopeBreak(world, pos, true);
        } else {
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, state, 0);
        }
    }

    private void propagateRopeBreak(World world, BlockPos pos, boolean up) {
        if (!world.field_72995_K) {
            BlockPos posAt = pos.func_177982_a(0, up ? 1 : -1, 0);
            IBlockState state = world.func_180495_p(posAt);
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, state, 0);
            if (state.func_177230_c() instanceof BlockRope) {
                ((BlockRope)state.func_177230_c()).propagateRopeBreak(world, posAt, up);
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.box;
    }

    @Deprecated
    @ParametersAreNonnullByDefault
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(ItemRegistry.getInstance().itemRope);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemRegistry.getInstance().itemRope;
    }

    public boolean func_181623_g() {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP || side == EnumFacing.DOWN;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return true;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockRenderingHandler getRenderer() {
        return new RenderBlockRope(this);
    }

    public ModelResourceLocation getBlockModelResourceLocation() {
        return new ModelResourceLocation("ninjagear", this.getInternalName());
    }

    @Override
    public boolean canAttachRope(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public void onRopeAttached(World world, BlockPos pos, IBlockState state) {
    }
}

