/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.block;

import com.infinityraider.infinitylib.block.BlockBase;
import com.infinityraider.infinitylib.block.ICustomRenderedBlock;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.render.block.IBlockRenderingHandler;
import com.infinityraider.infinitylib.render.block.RenderBlockEmpty;
import com.infinityraider.ninjagear.handler.ConfigurationHandler;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSmoke
extends BlockBase
implements ICustomRenderedBlock {
    public static final InfinityProperty<Integer> PROPERTY_AGE = new InfinityProperty((IProperty)PropertyInteger.func_177719_a((String)"age", (int)0, (int)15), (Comparable)Integer.valueOf(0));
    @SideOnly(value=Side.CLIENT)
    private IBlockRenderingHandler<BlockSmoke> renderer;

    public BlockSmoke() {
        super("smoke", Material.field_151579_a);
        this.func_149647_a(null);
        this.field_149787_q = false;
        this.field_149789_z = true;
        this.field_149785_s = true;
    }

    public int func_149738_a(World world) {
        return ConfigurationHandler.getInstance().smokeCloudDispersionFactor;
    }

    @ParametersAreNonnullByDefault
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        int meta = this.func_176201_c(state);
        if (meta < 15) {
            world.func_180501_a(pos, this.func_176203_a(Math.min(meta + 2 + random.nextInt(3), 15)), 6);
        } else {
            world.func_175698_g(pos);
        }
    }

    @ParametersAreNonnullByDefault
    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 16 - this.func_176201_c(state);
    }

    @ParametersAreNonnullByDefault
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    public List<String> getOreTags() {
        return Collections.emptyList();
    }

    protected InfinityProperty[] getPropertyArray() {
        return new InfinityProperty[]{PROPERTY_AGE};
    }

    public IBlockState func_176203_a(int meta) {
        return PROPERTY_AGE.applyToBlockState(this.func_176223_P(), (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)PROPERTY_AGE.getValue(state);
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_149703_v() {
        return false;
    }

    public boolean func_181623_g() {
        return false;
    }

    public boolean isAir(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @ParametersAreNonnullByDefault
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean flag) {
    }

    protected RayTraceResult func_185503_a(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB boundingBox) {
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockRenderingHandler<BlockSmoke> getRenderer() {
        if (this.renderer == null) {
            this.renderer = RenderBlockEmpty.createEmptyRender((BlockBase)this);
        }
        return this.renderer;
    }

    public ModelResourceLocation getBlockModelResourceLocation() {
        return new ModelResourceLocation("ninjagear", this.getInternalName());
    }
}

