/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.entity;

import com.infinityraider.ninjagear.block.BlockRope;
import com.infinityraider.ninjagear.handler.ConfigurationHandler;
import com.infinityraider.ninjagear.registry.BlockRegistry;
import com.infinityraider.ninjagear.registry.ItemRegistry;
import com.infinityraider.ninjagear.render.entity.RenderEntityRopeCoil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRopeCoil
extends EntityThrowable {
    public EntityRopeCoil(World world) {
        super(world);
    }

    public EntityRopeCoil(World world, EntityPlayer thrower) {
        super(world, (EntityLivingBase)thrower);
        Vec3d vec = thrower.func_70040_Z();
        this.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 2.0f, 0.2f);
    }

    public EntityPlayer getThrower() {
        return (EntityPlayer)super.func_85052_h();
    }

    protected float func_70185_h() {
        return 0.1f;
    }

    protected void func_70184_a(RayTraceResult impact) {
        if (impact.field_72308_g != null) {
            return;
        }
        World world = this.func_130014_f_();
        if (!world.field_72995_K) {
            BlockPos pos = this.getBlockPosFromImpact(impact);
            IBlockState state = this.func_130014_f_().func_180495_p(pos);
            BlockRope rope = (BlockRope)BlockRegistry.getInstance().blockRope;
            if (state.func_177230_c() instanceof BlockRope) {
                this.addRemainingToInventory(this.extendRope(world, pos, ConfigurationHandler.getInstance().ropeCoilLength));
            } else if (rope.func_176196_c(world, pos)) {
                this.addRemainingToInventory(this.placeRope(world, pos, ConfigurationHandler.getInstance().ropeCoilLength));
            } else {
                this.dropAsItem(impact.field_72307_f.field_72450_a, impact.field_72307_f.field_72448_b, impact.field_72307_f.field_72449_c);
            }
        }
    }

    public void dropAsItem(double x, double y, double z) {
        EntityItem item = new EntityItem(this.func_130014_f_(), x, y, z, new ItemStack(ItemRegistry.getInstance().itemRopeCoil));
        this.func_130014_f_().func_72838_d((Entity)item);
        this.func_70106_y();
    }

    private BlockPos getBlockPosFromImpact(RayTraceResult impact) {
        if (impact.field_72308_g != null) {
            return impact.field_72308_g.func_180425_c();
        }
        IBlockState state = this.func_130014_f_().func_180495_p(impact.func_178782_a());
        if (state.func_177230_c() instanceof BlockRope) {
            return impact.func_178782_a();
        }
        return impact.func_178782_a().func_177972_a(impact.field_178784_b);
    }

    private int placeRope(World world, BlockPos pos, int ropeCount) {
        BlockRope rope = (BlockRope)BlockRegistry.getInstance().blockRope;
        world.func_180501_a(pos, rope.func_176223_P(), 3);
        if (--ropeCount > 0) {
            BlockPos down = pos.func_177977_b();
            if (rope.func_176196_c(world, down)) {
                return this.placeRope(world, down, ropeCount);
            }
            return ropeCount;
        }
        return 0;
    }

    private int extendRope(World world, BlockPos pos, int ropeCount) {
        BlockRope rope = (BlockRope)BlockRegistry.getInstance().blockRope;
        boolean flag = true;
        while (flag && ropeCount > 0) {
            flag = rope.extendRope(world, pos);
            if (!flag) continue;
            --ropeCount;
        }
        return ropeCount;
    }

    private void addRemainingToInventory(int remaining) {
        if (remaining > 0) {
            ItemStack stack = new ItemStack(ItemRegistry.getInstance().itemRope, remaining);
            if (this.getThrower() != null && !this.getThrower().field_71071_by.func_70441_a(stack)) {
                EntityItem item = new EntityItem(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
                this.func_130014_f_().func_72838_d((Entity)item);
            }
        }
        this.func_70106_y();
    }

    public static class RenderFactory
    implements IRenderFactory<EntityRopeCoil> {
        private static final RenderFactory INSTANCE = new RenderFactory();

        public static RenderFactory getInstance() {
            return INSTANCE;
        }

        private RenderFactory() {
        }

        @SideOnly(value=Side.CLIENT)
        public Render<? super EntityRopeCoil> createRenderFor(RenderManager manager) {
            return new RenderEntityRopeCoil(manager);
        }
    }
}

