/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.entity;

import com.infinityraider.ninjagear.handler.ConfigurationHandler;
import com.infinityraider.ninjagear.registry.ItemRegistry;
import com.infinityraider.ninjagear.render.entity.RenderEntityShuriken;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityShuriken
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    private float crit;
    private int timer;
    private Vec3d direction;

    public EntityShuriken(World world) {
        super(world);
    }

    public EntityShuriken(World world, EntityLivingBase thrower, boolean crit) {
        super(world, thrower);
        this.direction = thrower.func_70040_Z();
        this.func_70186_c(this.direction.field_72450_a, this.direction.field_72448_b, this.direction.field_72449_c, 4.0f, 0.2f);
        this.crit = crit ? ConfigurationHandler.getInstance().critMultiplier : 1.0f;
        this.timer = 0;
    }

    public Vec3d getDirection() {
        return this.direction;
    }

    protected float func_70185_h() {
        return 0.3f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K) {
            ++this.timer;
            if (this.timer > 5000) {
                this.dropAsItem(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        }
    }

    protected void func_70184_a(RayTraceResult impact) {
        DamageSource damage;
        Entity hit = impact.field_72308_g;
        if (hit == this.func_85052_h()) {
            return;
        }
        if (hit != null && !hit.func_180431_b(damage = DamageSource.func_76356_a((Entity)this.func_85052_h(), (Entity)this))) {
            float crit = this.crit;
            hit.func_70097_a(damage, 3.0f + ConfigurationHandler.getInstance().shurikenDamage * crit);
        }
        World world = this.func_130014_f_();
        if (!world.field_72995_K && impact.field_72307_f != null) {
            this.dropAsItem(impact.field_72307_f.field_72450_a, impact.field_72307_f.field_72448_b, impact.field_72307_f.field_72449_c);
        }
    }

    public void dropAsItem(double x, double y, double z) {
        EntityItem item = new EntityItem(this.func_130014_f_(), x, y, z, new ItemStack(ItemRegistry.getInstance().itemShuriken));
        this.func_130014_f_().func_72838_d((Entity)item);
        this.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74776_a("NG_crit", this.crit);
        tag.func_74780_a("NG_X", this.direction.field_72450_a);
        tag.func_74780_a("NG_Y", this.direction.field_72448_b);
        tag.func_74780_a("NG_Z", this.direction.field_72449_c);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.crit = tag.func_74760_g("NG_crit");
        this.direction = new Vec3d(tag.func_74769_h("NG_X"), tag.func_74769_h("NG_Y"), tag.func_74769_h("NG_Z"));
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.crit);
        buffer.writeDouble(this.direction.field_72450_a);
        buffer.writeDouble(this.direction.field_72448_b);
        buffer.writeDouble(this.direction.field_72449_c);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.crit = buffer.readFloat();
        this.direction = new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public static class RenderFactory
    implements IRenderFactory<EntityShuriken> {
        private static final RenderFactory INSTANCE = new RenderFactory();

        public static RenderFactory getInstance() {
            return INSTANCE;
        }

        @SideOnly(value=Side.CLIENT)
        public Render<? super EntityShuriken> createRenderFor(RenderManager manager) {
            return new RenderEntityShuriken(manager);
        }
    }
}

