/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.entity;

import com.infinityraider.ninjagear.handler.ConfigurationHandler;
import com.infinityraider.ninjagear.registry.BlockRegistry;
import com.infinityraider.ninjagear.registry.PotionRegistry;
import com.infinityraider.ninjagear.render.entity.RenderEntitySmokeBomb;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySmokeBomb
extends EntityThrowable {
    public EntitySmokeBomb(World world) {
        super(world);
    }

    public EntitySmokeBomb(World world, EntityLivingBase thrower, float velocity) {
        super(world, thrower);
        Vec3d vec = thrower.func_70040_Z();
        this.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, velocity, 0.2f);
    }

    protected float func_70185_h() {
        return 0.1f;
    }

    @ParametersAreNonnullByDefault
    protected void func_70184_a(RayTraceResult impact) {
        World world = this.func_130014_f_();
        BlockPos pos = this.getBlockPosFromImpact(impact);
        this.clearRevealedStatus(world, pos);
        this.createSmokeCloud(world, pos);
    }

    private BlockPos getBlockPosFromImpact(RayTraceResult impact) {
        if (impact.field_72308_g != null) {
            return impact.field_72308_g.func_180425_c();
        }
        return impact.func_178782_a().func_177972_a(impact.field_178784_b);
    }

    private void clearRevealedStatus(World world, BlockPos pos) {
        world.func_72839_b(null, new AxisAlignedBB(pos.func_177982_a(-4, -4, -4), pos.func_177982_a(4, 4, 4))).stream().filter(entity -> entity != null && entity instanceof EntityLivingBase).forEach(entity -> {
            EntityLivingBase living = (EntityLivingBase)entity;
            if (living.func_70644_a(PotionRegistry.getInstance().potionNinjaRevealed)) {
                living.func_184589_d(PotionRegistry.getInstance().potionNinjaRevealed);
            }
        });
    }

    private void createSmokeCloud(World world, BlockPos pos) {
        int r = ConfigurationHandler.getInstance().smokeCloudRadius;
        for (int x = -r; x <= r; ++x) {
            for (int y = -r; y <= r; ++y) {
                for (int z = -r; z <= r; ++z) {
                    BlockPos posAt;
                    IBlockState state;
                    int radius = x * x + y * y + z * z;
                    if (radius > r * r || (state = world.func_180495_p(posAt = pos.func_177982_a(x, y, z))).func_185904_a() != Material.field_151579_a) continue;
                    if (world.field_72995_K) {
                        this.spawnSmokeParticle(posAt);
                        continue;
                    }
                    world.func_180501_a(posAt, BlockRegistry.getInstance().blockSmoke.func_176203_a(this.getDarknessValue(radius, world.field_73012_v)), 3);
                }
            }
        }
    }

    private int getDarknessValue(int radius, Random rand) {
        if (radius <= 5) {
            return rand.nextInt(2);
        }
        if (radius <= 10) {
            return 1 + rand.nextInt(2);
        }
        if (radius <= 15) {
            return 2 + rand.nextInt(2);
        }
        if (radius <= 20) {
            return 2 + rand.nextInt(3);
        }
        return 3 + rand.nextInt(2);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnSmokeParticle(BlockPos pos) {
        if (ConfigurationHandler.getInstance().disableSmokeParticles) {
            return;
        }
        Minecraft.func_71410_x().field_71438_f.func_180442_a(EnumParticleTypes.SMOKE_LARGE.func_179348_c(), true, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[]{50});
    }

    public static class RenderFactory
    implements IRenderFactory<EntitySmokeBomb> {
        private static final RenderFactory INSTANCE = new RenderFactory();

        public static RenderFactory getInstance() {
            return INSTANCE;
        }

        private RenderFactory() {
        }

        @SideOnly(value=Side.CLIENT)
        public Render<? super EntitySmokeBomb> createRenderFor(RenderManager manager) {
            return new RenderEntitySmokeBomb(manager);
        }
    }
}

