/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.handler;

import com.infinityraider.ninjagear.NinjaGear;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConfigurationHandler {
    private static final ConfigurationHandler INSTANCE = new ConfigurationHandler();
    private Configuration config;
    public float katanaDamage;
    public float saiDamage;
    public float shurikenDamage;
    public float critMultiplier;
    public int brightnessLimit;
    public int hidingCoolDown;
    public int smokeCloudRadius;
    public int smokeCloudDispersionFactor;
    public int ropeCoilLength;
    public boolean debug;
    @SideOnly(value=Side.CLIENT)
    public boolean disableSmokeParticles;
    @SideOnly(value=Side.CLIENT)
    public boolean renderGadgets;

    private ConfigurationHandler() {
    }

    public static ConfigurationHandler getInstance() {
        return INSTANCE;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void init(FMLPreInitializationEvent event) {
        if (this.config == null) {
            this.config = new Configuration(event.getSuggestedConfigurationFile());
        }
        this.loadConfiguration();
        if (this.config.hasChanged()) {
            this.config.save();
        }
        NinjaGear.instance.getLogger().debug("Configuration Loaded", new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void initClientConfigs(FMLPreInitializationEvent event) {
        if (this.config == null) {
            this.config = new Configuration(event.getSuggestedConfigurationFile());
        }
        this.loadClientConfiguration();
        if (this.config.hasChanged()) {
            this.config.save();
        }
        NinjaGear.instance.getLogger().debug("Client configuration Loaded", new Object[0]);
    }

    private void loadConfiguration() {
        this.katanaDamage = this.config.getFloat("katana damage", Categories.COMBAT.getName(), 5.0f, 1.0f, 20.0f, "The damage output of the katana.");
        this.saiDamage = this.config.getFloat("sai damage", Categories.COMBAT.getName(), 3.0f, 1.0f, 20.0f, "The damage output of the sai.");
        this.shurikenDamage = this.config.getFloat("shuriken damage", Categories.COMBAT.getName(), 4.0f, 1.0f, 20.0f, "The damage output of the shuriken.");
        this.critMultiplier = this.config.getFloat("critical hit multiplier", Categories.COMBAT.getName(), 3.5f, 1.0f, 10.0f, "The multiplier for critical hits");
        this.brightnessLimit = this.config.getInt("brightness limit", Categories.INVISIBILITY.getName(), 8, 0, 16, "When the brightness is below this value it is possible to hide (0 means it is never possible to hide, 16 means it is always possible to hide).");
        this.hidingCoolDown = this.config.getInt("hiding cool down", Categories.INVISIBILITY.getName(), 60, 0, 600, "The cool down time in ticks before a ninja can hide again after being revealed.");
        this.smokeCloudRadius = this.config.getInt("smoke cloud radius", Categories.SMOKE_BOMB.getName(), 4, 2, 5, "The radius of the smoke cloud created by smoke bombs");
        this.smokeCloudDispersionFactor = this.config.getInt("smoke cloud dispersion", Categories.SMOKE_BOMB.getName(), 5, 1, 20, "Smoke cloud dispersion factor, the lower this is, the faster smoke clouds will disperse and disappear");
        this.ropeCoilLength = this.config.getInt("rope coil length", Categories.ROPE.getName(), 10, 1, 16, "The length of a rope coil");
        this.debug = this.config.getBoolean("debug", Categories.DEBUG.getName(), false, "Set to true if you wish to enable debug mode.");
    }

    public int getPotionEffectId(String name, int defaultId) {
        int id = this.config.getInt(name, Categories.POTION.getName(), defaultId, 0, 255, "Id for the " + name + " potion effect, this potion effect is generated on the first run by detecting a free potion id.");
        if (this.config.hasChanged()) {
            this.config.save();
        }
        return id;
    }

    @SideOnly(value=Side.CLIENT)
    private void loadClientConfiguration() {
        this.disableSmokeParticles = this.config.getBoolean("Disable smoke bomb particles", Categories.CLIENT.getName(), false, "Set this to false to disable the spawning of smoke bomb particles");
        this.renderGadgets = this.config.getBoolean("Render gadgets", Categories.CLIENT.getName(), true, "Set to false to disable the rendering of ninja gadgets onto player models");
    }

    public static enum Categories {
        COMBAT("combat"),
        SMOKE_BOMB("smoke bomb"),
        INVISIBILITY("invisibility"),
        POTION("potion"),
        ROPE("rope"),
        DEBUG("debug"),
        CLIENT("client");

        private final String name;

        private Categories(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

