/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.handler;

import com.infinityraider.ninjagear.api.v1.IHiddenItem;
import com.infinityraider.ninjagear.handler.ConfigurationHandler;
import com.infinityraider.ninjagear.item.ItemNinjaArmor;
import com.infinityraider.ninjagear.network.MessageInvisibility;
import com.infinityraider.ninjagear.registry.PotionRegistry;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NinjaAuraHandler {
    private static final NinjaAuraHandler INSTANCE = new NinjaAuraHandler();

    public static NinjaAuraHandler getInstance() {
        return INSTANCE;
    }

    private NinjaAuraHandler() {
    }

    public void revealEntity(EntityPlayer player, int duration) {
        player.func_70690_d(new PotionEffect(new PotionEffect(PotionRegistry.getInstance().potionNinjaRevealed, duration, 0, false, true)));
    }

    private boolean shouldRemoveEffect(EntityPlayer player) {
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        if (!(helmet.func_77973_b() instanceof ItemNinjaArmor)) {
            return true;
        }
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (!(chest.func_77973_b() instanceof ItemNinjaArmor)) {
            return true;
        }
        ItemStack leggings = player.func_184582_a(EntityEquipmentSlot.LEGS);
        if (!(leggings.func_77973_b() instanceof ItemNinjaArmor)) {
            return true;
        }
        ItemStack boots = player.func_184582_a(EntityEquipmentSlot.FEET);
        return !(boots.func_77973_b() instanceof ItemNinjaArmor);
    }

    private boolean shouldBeHidden(EntityPlayer player) {
        int light;
        if (!player.func_70644_a(PotionRegistry.getInstance().potionNinjaAura)) {
            return false;
        }
        if (player.func_70644_a(PotionRegistry.getInstance().potionNinjaRevealed)) {
            return false;
        }
        if (!player.func_70093_af()) {
            return false;
        }
        ItemStack mainHand = player.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack offHand = player.func_184586_b(EnumHand.OFF_HAND);
        if (!(mainHand.func_190926_b() || mainHand.func_77973_b() instanceof IHiddenItem && !((IHiddenItem)mainHand.func_77973_b()).shouldRevealPlayerWhenEquipped(player, mainHand))) {
            return false;
        }
        if (!(offHand.func_190926_b() || offHand.func_77973_b() instanceof IHiddenItem && !((IHiddenItem)offHand.func_77973_b()).shouldRevealPlayerWhenEquipped(player, offHand))) {
            return false;
        }
        int light_block = player.func_130014_f_().func_175642_b(EnumSkyBlock.BLOCK, player.func_180425_c());
        boolean day = player.func_130014_f_().func_72935_r();
        if (day) {
            int light_sky = player.func_130014_f_().func_175642_b(EnumSkyBlock.SKY, player.func_180425_c());
            light = Math.max(light_sky, light_block);
        } else {
            light = light_block;
        }
        return light < ConfigurationHandler.getInstance().brightnessLimit;
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null || entity.func_130014_f_().field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (this.shouldRemoveEffect(player)) {
            player.func_184589_d(PotionRegistry.getInstance().potionNinjaAura);
            if (player.func_70644_a(PotionRegistry.getInstance().potionNinjaHidden)) {
                player.func_184589_d(PotionRegistry.getInstance().potionNinjaHidden);
            }
            if (player.func_70644_a(PotionRegistry.getInstance().potionNinjaRevealed)) {
                player.func_184589_d(PotionRegistry.getInstance().potionNinjaRevealed);
            }
        } else {
            boolean isHidden;
            boolean shouldBeHidden = this.shouldBeHidden(player);
            if (shouldBeHidden != (isHidden = player.func_70644_a(PotionRegistry.getInstance().potionNinjaHidden))) {
                if (shouldBeHidden) {
                    player.func_70690_d(new PotionEffect(PotionRegistry.getInstance().potionNinjaHidden, Integer.MAX_VALUE, 0, false, true));
                    new MessageInvisibility(player, true).sendToAll();
                } else {
                    player.func_184589_d(PotionRegistry.getInstance().potionNinjaHidden);
                    this.revealEntity(player, ConfigurationHandler.getInstance().hidingCoolDown);
                    new MessageInvisibility(player, false).sendToAll();
                }
            }
        }
    }
}

