/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.handler;

import com.infinityraider.ninjagear.NinjaGear;
import com.infinityraider.ninjagear.item.ItemNinjaArmor;
import com.infinityraider.ninjagear.network.MessageUpdateGadgetRenderMaskServer;
import com.infinityraider.ninjagear.registry.ItemRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class NinjaGadgetHandler {
    private static final NinjaGadgetHandler INSTANCE = new NinjaGadgetHandler();
    private boolean hasSent = false;

    public static NinjaGadgetHandler getInstance() {
        return INSTANCE;
    }

    private NinjaGadgetHandler() {
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END) {
            EntityPlayer player = NinjaGear.proxy.getClientPlayer();
            if (player == null) {
                return;
            }
            ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
            if (chest != null && chest.func_77973_b() instanceof ItemNinjaArmor) {
                for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    Gadgets gadget;
                    ItemStack stack;
                    if (i == player.field_71071_by.field_70461_c || (stack = player.field_71071_by.func_70301_a(i)) == null || (gadget = Gadgets.getGadgetFromItem(stack.func_77973_b())) == null) continue;
                    gadget.increment();
                }
            }
            boolean flag = false;
            for (Gadgets gadget : Gadgets.values()) {
                if (!gadget.updateAndCheckForChanges()) continue;
                flag = true;
            }
            if (flag || !this.hasSent) {
                new MessageUpdateGadgetRenderMaskServer(Gadgets.getRenderMask()).sendToServer();
                this.hasSent = true;
            }
        }
    }

    public static enum Gadgets {
        KATANA(ItemRegistry.getInstance().itemKatana),
        SAI(ItemRegistry.getInstance().itemSai),
        SHURIKEN(ItemRegistry.getInstance().itemShuriken),
        SMOKE_BOMB(ItemRegistry.getInstance().itemSmokeBomb),
        ROPE_COIL(ItemRegistry.getInstance().itemRopeCoil);

        private final Item item;
        private int counter;
        private int prevCount;

        private Gadgets(Item item) {
            this.item = item;
        }

        public Item getItem() {
            return this.item;
        }

        public void increment() {
            ++this.counter;
        }

        public boolean updateAndCheckForChanges() {
            if (this.counter != this.prevCount) {
                this.prevCount = this.counter;
                this.counter = 0;
                return true;
            }
            this.prevCount = this.counter;
            this.counter = 0;
            return false;
        }

        public static boolean[] getRenderMask() {
            return new boolean[]{Gadgets.KATANA.prevCount > 0, Gadgets.shouldRenderSai((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Gadgets.SAI.prevCount, false), Gadgets.shouldRenderSai((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Gadgets.SAI.prevCount, true), Gadgets.SHURIKEN.prevCount > 0, Gadgets.SMOKE_BOMB.prevCount > 0, Gadgets.ROPE_COIL.prevCount > 0};
        }

        private static boolean shouldRenderSai(EntityPlayer player, int itemCount, boolean left) {
            boolean hasLeft;
            if (itemCount <= 0) {
                return false;
            }
            if (itemCount >= 2) {
                return true;
            }
            ItemStack main = player.func_184582_a(EntityEquipmentSlot.MAINHAND);
            ItemStack off = player.func_184582_a(EntityEquipmentSlot.OFFHAND);
            boolean hasRight = main != null && main.func_77973_b() == SAI.getItem();
            boolean bl = hasLeft = off != null && off.func_77973_b() == SAI.getItem();
            if (hasLeft) {
                return !left;
            }
            if (hasRight) {
                return left;
            }
            return !left;
        }

        public static Gadgets getGadgetFromItem(Item item) {
            if (item == null) {
                return null;
            }
            for (Gadgets gadget : Gadgets.values()) {
                if (gadget.getItem() != item) continue;
                return gadget;
            }
            return null;
        }
    }
}

