/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.handler;

import com.infinityraider.ninjagear.registry.PotionRegistry;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderPlayerHandler {
    private static final RenderPlayerHandler INSTANCE = new RenderPlayerHandler();
    private HashMap<UUID, Boolean> invisibilityMap = new HashMap();

    public static RenderPlayerHandler getInstance() {
        return INSTANCE;
    }

    private RenderPlayerHandler() {
    }

    public void setPlayerInvisibilityStatus(EntityPlayer player, boolean invisible) {
        this.invisibilityMap.put(player.func_110124_au(), invisible);
    }

    public boolean isInvisible(EntityPlayer player) {
        if (player == Minecraft.func_71410_x().field_71439_g) {
            return player.func_70644_a(PotionRegistry.getInstance().potionNinjaHidden);
        }
        return this.invisibilityMap.containsKey(player.func_110124_au()) && this.invisibilityMap.get(player.func_110124_au()) != false;
    }

    @SubscribeEvent
    public void onRenderLivingEvent(RenderLivingEvent.Pre event) {
        EntityLivingBase entity = event.getEntity();
        if (entity instanceof EntityPlayer && this.isInvisible((EntityPlayer)entity)) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onRenderLivingSpecialsEvent(RenderLivingEvent.Specials.Pre event) {
        EntityLivingBase entity = event.getEntity();
        if (entity instanceof EntityPlayer && this.isInvisible((EntityPlayer)entity)) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }
}

