/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.handler;

import com.infinityraider.infinitylib.utility.TranslationHelper;
import com.infinityraider.ninjagear.api.v1.IHiddenItem;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TooltipHandler {
    private static final TooltipHandler INSTANCE = new TooltipHandler();

    public static TooltipHandler getInstance() {
        return INSTANCE;
    }

    private TooltipHandler() {
    }

    @SubscribeEvent
    public void onTooltipEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack == null) {
            return;
        }
        if (stack.func_77973_b() instanceof IHiddenItem) {
            this.addTooltipForHiddenItem(event.getToolTip(), (IHiddenItem)stack.func_77973_b(), stack, event.getEntityPlayer());
        }
    }

    private void addTooltipForHiddenItem(List<String> tooltip, IHiddenItem item, ItemStack stack, EntityPlayer player) {
        if (!item.shouldRevealPlayerWhenEquipped(player, stack)) {
            tooltip.add("");
            tooltip.add(TranslationHelper.translateToLocal((String)"ninjagear.tooltip:hiddenItem_L1"));
        }
    }
}

