/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.item;

import com.google.common.collect.Multimap;
import com.infinityraider.infinitylib.item.IItemWithModel;
import com.infinityraider.infinitylib.item.ItemBase;
import com.infinityraider.infinitylib.utility.IRecipeRegister;
import com.infinityraider.infinitylib.utility.TranslationHelper;
import com.infinityraider.ninjagear.handler.ConfigurationHandler;
import com.infinityraider.ninjagear.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

@MethodsReturnNonnullByDefault
public class ItemKatana
extends ItemBase
implements IRecipeRegister,
IItemWithModel {
    private ItemStack repairItem;

    public ItemKatana() {
        super("katana");
        this.func_77656_e(1000);
        this.func_77625_d(1);
        this.func_77637_a(ItemRegistry.CREATIVE_TAB);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)blockIn.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(2, entityLiving);
        }
        return true;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return blockIn.func_177230_c() == Blocks.field_150321_G;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return 15;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.getRepairItemStack();
        return mat != null && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false) || super.func_82789_a(toRepair, repair);
    }

    public ItemStack getRepairItemStack() {
        if (this.repairItem == null) {
            NonNullList steel = OreDictionary.getOres((String)"ingotSteel");
            this.repairItem = steel.size() > 0 ? (ItemStack)steel.get(0) : new ItemStack(Items.field_151042_j);
        }
        return this.repairItem;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (player.func_184582_a(EntityEquipmentSlot.OFFHAND) != null) {
            player.func_110140_aT().func_111147_b(this.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack, false));
        } else {
            player.func_110140_aT().func_111147_b(this.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack, true));
        }
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack, boolean effective) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 3.0 + (double)(effective ? ConfigurationHandler.getInstance().katanaDamage : 0.0f), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)(effective ? 1 : -2), 0));
        }
        return multimap;
    }

    @ParametersAreNonnullByDefault
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return this.getAttributeModifiers(slot, stack, true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(TranslationHelper.translateToLocal((String)("ninjagear.tooltip:" + this.getInternalName() + "_L1")));
        tooltip.add(TranslationHelper.translateToLocal((String)("ninjagear.tooltip:" + this.getInternalName() + "_L2")));
        tooltip.add(TranslationHelper.translateToLocal((String)("ninjagear.tooltip:" + this.getInternalName() + "_L3")));
    }

    public void registerRecipes() {
        this.getRecipes().forEach(GameRegistry::addRecipe);
    }

    public List<IRecipe> getRecipes() {
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        String steel = OreDictionary.doesOreNameExist((String)"ingotSteel") ? "ingotSteel" : "ingotIron";
        list.add((IRecipe)new ShapedOreRecipe((Item)this, new Object[]{" i ", "gsg", "wiw", Character.valueOf('i'), steel, Character.valueOf('g'), "ingotGold", Character.valueOf('s'), Items.field_151040_l, Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)}));
        return list;
    }

    public List<String> getOreTags() {
        return Collections.emptyList();
    }

    public List<Tuple<Integer, ModelResourceLocation>> getModelDefinitions() {
        ArrayList<Tuple<Integer, ModelResourceLocation>> list = new ArrayList<Tuple<Integer, ModelResourceLocation>>();
        list.add(new Tuple((Object)0, (Object)new ModelResourceLocation("ninjagear".toLowerCase() + ":" + this.getInternalName(), "inventory")));
        return list;
    }
}

