/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.item;

import com.infinityraider.infinitylib.item.IInfinityItem;
import com.infinityraider.infinitylib.item.IItemWithModel;
import com.infinityraider.infinitylib.utility.IRecipeRegister;
import com.infinityraider.infinitylib.utility.TranslationHelper;
import com.infinityraider.ninjagear.registry.ItemRegistry;
import com.infinityraider.ninjagear.registry.PotionRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ItemNinjaArmor
extends ItemArmor
implements IInfinityItem,
IItemWithModel,
IRecipeRegister {
    private static ItemArmor.ArmorMaterial ninjaCloth;
    private final String internalName;

    public ItemNinjaArmor(String name, int renderIndex, EntityEquipmentSlot equipmentSlot) {
        super(ItemNinjaArmor.getMaterial(), renderIndex, equipmentSlot);
        this.internalName = name;
        this.func_77637_a(ItemRegistry.CREATIVE_TAB);
    }

    public String getInternalName() {
        return this.internalName;
    }

    public List<String> getOreTags() {
        return Collections.emptyList();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        int layer = slot == EntityEquipmentSlot.LEGS ? 2 : 1;
        return "ninjagear:textures/models/armor/ninjagear_layer_" + layer + ".png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (this.field_77881_a != EntityEquipmentSlot.CHEST) {
            return;
        }
        if (!world.field_72995_K && !player.func_70644_a(PotionRegistry.getInstance().potionNinjaAura)) {
            ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
            if (helmet == null) {
                return;
            }
            ItemStack leggings = player.func_184582_a(EntityEquipmentSlot.LEGS);
            if (leggings == null) {
                return;
            }
            ItemStack boots = player.func_184582_a(EntityEquipmentSlot.FEET);
            if (boots == null) {
                return;
            }
            if (helmet.func_77973_b() instanceof ItemNinjaArmor && leggings.func_77973_b() instanceof ItemNinjaArmor && boots.func_77973_b() instanceof ItemNinjaArmor) {
                PotionEffect effect = new PotionEffect(PotionRegistry.getInstance().potionNinjaAura, Integer.MAX_VALUE, 0, false, false);
                player.func_70690_d(effect);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(TranslationHelper.translateToLocal((String)("ninjagear.tooltip:" + this.getInternalName() + "_L1")));
        tooltip.add(TranslationHelper.translateToLocal((String)"ninjagear.tooltip:ninjaGear_L1"));
    }

    @SideOnly(value=Side.CLIENT)
    public List<Tuple<Integer, ModelResourceLocation>> getModelDefinitions() {
        ArrayList<Tuple<Integer, ModelResourceLocation>> list = new ArrayList<Tuple<Integer, ModelResourceLocation>>();
        list.add(new Tuple((Object)0, (Object)new ModelResourceLocation("ninjagear".toLowerCase() + ":" + this.internalName, "inventory")));
        return list;
    }

    public static ItemArmor.ArmorMaterial getMaterial() {
        if (ninjaCloth == null && (ninjaCloth = EnumHelper.addArmorMaterial((String)"ninjaCloth", (String)"ninja_cloth", (int)15, (int[])new int[]{2, 3, 4, 2}, (int)12, (SoundEvent)SoundEvents.field_187728_s, (float)1.0f)) != null) {
            ItemNinjaArmor.ninjaCloth.repairMaterial = new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE);
        }
        return ninjaCloth == null ? ItemArmor.ArmorMaterial.LEATHER : ninjaCloth;
    }

    public boolean isEnabled() {
        return true;
    }

    public void registerRecipes() {
        this.getRecipes().forEach(GameRegistry::addRecipe);
    }

    public List<IRecipe> getRecipes() {
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        switch (this.field_77881_a) {
            case HEAD: {
                list.add((IRecipe)new ShapedOreRecipe((Item)this, new Object[]{"dhd", "sls", Character.valueOf('d'), "dyeBlack", Character.valueOf('h'), Items.field_151024_Q, Character.valueOf('s'), "string", Character.valueOf('l'), "leather"}));
                break;
            }
            case CHEST: {
                list.add((IRecipe)new ShapedOreRecipe((Item)this, new Object[]{"dsd", "lcl", "lsl", Character.valueOf('d'), "dyeBlack", Character.valueOf('c'), Items.field_151027_R, Character.valueOf('s'), "string", Character.valueOf('l'), "leather"}));
                break;
            }
            case LEGS: {
                list.add((IRecipe)new ShapedOreRecipe((Item)this, new Object[]{"dpd", "lsl", "lsl", Character.valueOf('d'), "dyeBlack", Character.valueOf('p'), Items.field_151026_S, Character.valueOf('s'), "string", Character.valueOf('l'), "leather"}));
                break;
            }
            case FEET: {
                list.add((IRecipe)new ShapedOreRecipe((Item)this, new Object[]{"s s", "dbd", "lll", Character.valueOf('d'), "dyeBlack", Character.valueOf('b'), Items.field_151021_T, Character.valueOf('s'), "string", Character.valueOf('l'), "leather"}));
            }
        }
        return list;
    }
}

