/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.item;

import com.infinityraider.infinitylib.item.IItemWithModel;
import com.infinityraider.infinitylib.item.ItemBase;
import com.infinityraider.infinitylib.utility.IRecipeRegister;
import com.infinityraider.infinitylib.utility.TranslationHelper;
import com.infinityraider.ninjagear.api.v1.IHiddenItem;
import com.infinityraider.ninjagear.block.BlockRope;
import com.infinityraider.ninjagear.handler.ConfigurationHandler;
import com.infinityraider.ninjagear.registry.BlockRegistry;
import com.infinityraider.ninjagear.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@MethodsReturnNonnullByDefault
public class ItemRope
extends ItemBase
implements IItemWithModel,
IHiddenItem,
IRecipeRegister {
    private final BlockRope block;

    public ItemRope() {
        super("ropeItem");
        this.block = (BlockRope)BlockRegistry.getInstance().blockRope;
        this.func_77637_a(ItemRegistry.CREATIVE_TAB);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockRope) {
            return EnumActionResult.PASS;
        }
        if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(face);
        }
        if ((stack = player.func_184586_b(hand)).func_190916_E() != 0 && player.func_175151_a(pos, face, stack) && world.func_190527_a((Block)this.block, pos, false, face, null)) {
            int i = this.func_77647_b(stack.func_77960_j());
            IBlockState newState = this.block.getStateForPlacement(world, pos, face, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
            if (this.block.func_176196_c(world, pos) && this.placeBlockAt(stack, player, world, pos, newState)) {
                SoundType soundtype = this.block.getSoundType(state, world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                stack.func_190920_e(stack.func_190916_E() - 1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @ParametersAreNonnullByDefault
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (world.field_72995_K) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            this.attemptToCreateRopeCoil(player);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void attemptToCreateRopeCoil(EntityPlayer player) {
        ItemStack coil;
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack.func_77973_b() instanceof ItemRope && stack.func_190916_E() >= ConfigurationHandler.getInstance().ropeCoilLength && player.field_71071_by.func_70441_a(coil = new ItemStack(ItemRegistry.getInstance().itemRopeCoil, 1, 0)) && !player.field_71075_bZ.field_75098_d) {
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, ConfigurationHandler.getInstance().ropeCoilLength);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(TranslationHelper.translateToLocal((String)("ninjagear.tooltip:" + this.getInternalName() + "_L1")));
        tooltip.add(TranslationHelper.translateToLocal((String)("ninjagear.tooltip:" + this.getInternalName() + "_L2")));
        tooltip.add(TranslationHelper.translateToLocal((String)("ninjagear.tooltip:" + this.getInternalName() + "_L3")));
        tooltip.add(TranslationHelper.translateToLocal((String)("ninjagear.tooltip:" + this.getInternalName() + "_L4")));
        tooltip.add(TranslationHelper.translateToLocal((String)("ninjagear.tooltip:" + this.getInternalName() + "_L5")));
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 3)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.block) {
            this.block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
        }
        return true;
    }

    @Override
    public boolean shouldRevealPlayerWhenEquipped(EntityPlayer entity, ItemStack stack) {
        return false;
    }

    public void registerRecipes() {
        this.getRecipes().forEach(GameRegistry::addRecipe);
    }

    public List<IRecipe> getRecipes() {
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        list.add((IRecipe)new ShapedOreRecipe(new ItemStack((Item)this, 8), new Object[]{"s  ", "sss", "  s", Character.valueOf('s'), "string"}));
        list.add((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)this, ConfigurationHandler.getInstance().ropeCoilLength), new Object[]{ItemRegistry.getInstance().itemRopeCoil}));
        return list;
    }

    public List<Tuple<Integer, ModelResourceLocation>> getModelDefinitions() {
        ArrayList<Tuple<Integer, ModelResourceLocation>> list = new ArrayList<Tuple<Integer, ModelResourceLocation>>();
        list.add(new Tuple((Object)0, (Object)new ModelResourceLocation("ninjagear".toLowerCase() + ":" + this.getInternalName(), "inventory")));
        return list;
    }

    public List<String> getOreTags() {
        return Collections.emptyList();
    }
}

