/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.item;

import com.google.common.collect.Multimap;
import com.infinityraider.infinitylib.item.IItemWithModel;
import com.infinityraider.infinitylib.item.ItemBase;
import com.infinityraider.infinitylib.utility.IRecipeRegister;
import com.infinityraider.infinitylib.utility.TranslationHelper;
import com.infinityraider.ninjagear.api.v1.IHiddenItem;
import com.infinityraider.ninjagear.handler.ConfigurationHandler;
import com.infinityraider.ninjagear.handler.NinjaAuraHandler;
import com.infinityraider.ninjagear.registry.ItemRegistry;
import com.infinityraider.ninjagear.registry.PotionRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

@MethodsReturnNonnullByDefault
public class ItemSai
extends ItemBase
implements IHiddenItem,
IRecipeRegister,
IItemWithModel {
    private ItemStack repairItem;

    public ItemSai() {
        super("sai");
        this.func_77656_e(1000);
        this.func_77625_d(1);
        this.func_77637_a(ItemRegistry.CREATIVE_TAB);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer) {
            NinjaAuraHandler.getInstance().revealEntity((EntityPlayer)attacker, ConfigurationHandler.getInstance().hidingCoolDown);
        }
        stack.func_77972_a(1, attacker);
        ItemStack offhand = attacker.func_184582_a(EntityEquipmentSlot.OFFHAND);
        if (offhand != null && offhand.func_77973_b() instanceof ItemSai) {
            offhand.func_77972_a(1, attacker);
        }
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)blockIn.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(2, entityLiving);
        }
        return true;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return blockIn.func_177230_c() == Blocks.field_150321_G;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return 15;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.getRepairItemStack();
        return OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false) || super.func_82789_a(toRepair, repair);
    }

    public ItemStack getRepairItemStack() {
        if (this.repairItem == null) {
            NonNullList steel = OreDictionary.getOres((String)"ingotSteel");
            this.repairItem = steel.size() > 0 ? (ItemStack)steel.get(0) : new ItemStack(Items.field_151042_j);
        }
        return this.repairItem;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        ItemStack offHand = player.func_184582_a(EntityEquipmentSlot.OFFHAND);
        boolean crit = player.func_70644_a(PotionRegistry.getInstance().potionNinjaHidden);
        if (offHand != null && offHand.func_77973_b() == this) {
            player.func_110140_aT().func_111147_b(this.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack, true, crit));
        } else {
            player.func_110140_aT().func_111147_b(this.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack, false, false));
        }
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack, boolean effective, boolean crit) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            float multiplier = crit ? ConfigurationHandler.getInstance().critMultiplier : 1.0f;
            float damage = (effective ? ConfigurationHandler.getInstance().saiDamage : 0.0f) * multiplier;
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 3.0 + (double)damage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)(effective ? 1 : -2), 0));
        }
        return multimap;
    }

    @ParametersAreNonnullByDefault
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return this.getAttributeModifiers(slot, stack, true, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(TranslationHelper.translateToLocal((String)("ninjagear.tooltip:" + this.getInternalName() + "_L1")));
        tooltip.add(TranslationHelper.translateToLocal((String)("ninjagear.tooltip:" + this.getInternalName() + "_L2")));
        tooltip.add(TranslationHelper.translateToLocal((String)("ninjagear.tooltip:" + this.getInternalName() + "_L3")));
        tooltip.add(TranslationHelper.translateToLocal((String)("ninjagear.tooltip:" + this.getInternalName() + "_L4")));
    }

    @Override
    public boolean shouldRevealPlayerWhenEquipped(EntityPlayer entity, ItemStack stack) {
        return false;
    }

    public void registerRecipes() {
        this.getRecipes().forEach(GameRegistry::addRecipe);
    }

    public List<IRecipe> getRecipes() {
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        String steel = OreDictionary.doesOreNameExist((String)"ingotSteel") ? "ingotSteel" : "ingotIron";
        list.add((IRecipe)new ShapedOreRecipe((Item)this, new Object[]{" s ", "sis", " h ", Character.valueOf('s'), Items.field_151040_l, Character.valueOf('i'), steel, Character.valueOf('h'), "stickWood"}));
        return list;
    }

    public List<String> getOreTags() {
        return Collections.emptyList();
    }

    public List<Tuple<Integer, ModelResourceLocation>> getModelDefinitions() {
        ArrayList<Tuple<Integer, ModelResourceLocation>> list = new ArrayList<Tuple<Integer, ModelResourceLocation>>();
        list.add(new Tuple((Object)0, (Object)new ModelResourceLocation("ninjagear".toLowerCase() + ":" + this.getInternalName(), "inventory")));
        return list;
    }
}

