/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.registry;

import com.infinityraider.ninjagear.handler.ConfigurationHandler;
import com.infinityraider.ninjagear.potion.PotionNinjaAura;
import com.infinityraider.ninjagear.potion.PotionNinjaHidden;
import com.infinityraider.ninjagear.potion.PotionNinjaRevealed;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;

public class PotionRegistry {
    private static final PotionRegistry INSTANCE = new PotionRegistry();
    private final RegistryNamespaced<ResourceLocation, Potion> potionRegistry = Potion.field_188414_b;
    private int lastId = -1;
    public Potion potionNinjaAura;
    public Potion potionNinjaHidden;
    public Potion potionNinjaRevealed;

    public static PotionRegistry getInstance() {
        return INSTANCE;
    }

    private PotionRegistry() {
        this.getNextId();
    }

    public void init() {
        this.potionNinjaAura = this.registerPotion(new PotionNinjaAura());
        this.potionNinjaHidden = this.registerPotion(new PotionNinjaHidden());
        this.potionNinjaRevealed = this.registerPotion(new PotionNinjaRevealed());
    }

    public Potion registerPotion(Potion potion) {
        String name = potion.func_76393_a();
        int id = ConfigurationHandler.getInstance().getPotionEffectId(name, this.getNextId());
        this.potionRegistry.func_177775_a(id, (Object)new ResourceLocation("ninjagear", name), (Object)potion);
        return potion;
    }

    private int getNextId() {
        int id = this.lastId;
        boolean flag = false;
        while (!flag) {
            Potion potion;
            if ((potion = (Potion)this.potionRegistry.func_148754_a(++id)) != null) continue;
            flag = true;
        }
        this.lastId = id;
        return id;
    }
}

