/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.ninjagear.render.player;

import com.infinityraider.infinitylib.render.RenderUtilBase;
import com.infinityraider.ninjagear.NinjaGear;
import com.infinityraider.ninjagear.handler.RenderPlayerHandler;
import com.infinityraider.ninjagear.registry.ItemRegistry;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderNinjaGadget
extends RenderUtilBase {
    private static final RenderNinjaGadget INSTANCE = new RenderNinjaGadget();
    private final HashMap<UUID, boolean[]> renderMap = new HashMap();
    private final ItemStack[] itemsToRender;
    private static final int ID_KATANA = 0;
    private static final int ID_SAI_RIGHT = 1;
    private static final int ID_SAI_LEFT = 2;
    private static final int ID_SHURIKEN = 3;
    private static final int ID_SMOKE_BOMB = 4;
    private static final int ID_ROPE_COIL = 5;

    public static RenderNinjaGadget getInstance() {
        return INSTANCE;
    }

    private RenderNinjaGadget() {
        this.itemsToRender = new ItemStack[]{new ItemStack(ItemRegistry.getInstance().itemKatana), new ItemStack(ItemRegistry.getInstance().itemSai), new ItemStack(ItemRegistry.getInstance().itemSai), new ItemStack(ItemRegistry.getInstance().itemShuriken), new ItemStack(ItemRegistry.getInstance().itemSmokeBomb), new ItemStack(ItemRegistry.getInstance().itemRopeCoil)};
    }

    public void updateRenderMask(EntityPlayer player, boolean[] renderMask) {
        if (player == null) {
            return;
        }
        if (renderMask == null || renderMask.length != this.itemsToRender.length || this.isMaskEmpty(renderMask)) {
            this.renderMap.remove(player.func_110124_au());
        }
        this.renderMap.put(player.func_110124_au(), renderMask);
    }

    private boolean isMaskEmpty(boolean[] mask) {
        for (boolean b : mask) {
            if (!b) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void onRenderPlayerEvent(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        if (RenderPlayerHandler.getInstance().isInvisible(player)) {
            return;
        }
        if (!this.renderMap.containsKey(player.func_110124_au())) {
            return;
        }
        boolean[] renderMask = this.renderMap.get(player.func_110124_au());
        float f = event.getPartialRenderTick();
        GlStateManager.func_179094_E();
        if (player != NinjaGear.proxy.getClientPlayer()) {
            EntityPlayer local = NinjaGear.proxy.getClientPlayer();
            double dx = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f - (local.field_70169_q + (local.field_70165_t - local.field_70169_q) * (double)f);
            double dy = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f - (local.field_70167_r + (local.field_70163_u - local.field_70167_r) * (double)f);
            double dz = player.field_70166_s + (player.field_70165_t - player.field_70169_q) * (double)f - (local.field_70166_s + (local.field_70161_v - local.field_70166_s) * (double)f);
            GlStateManager.func_179137_b((double)dx, (double)dy, (double)dz);
        }
        float yaw = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * f;
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        if (player.func_70093_af()) {
            GlStateManager.func_179137_b((double)0.0, (double)-0.375, (double)0.0);
            GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.8);
        }
        block8: for (int i = 0; i < renderMask.length; ++i) {
            if (!renderMask[i]) continue;
            switch (i) {
                case 0: {
                    this.renderKatana(i);
                    continue block8;
                }
                case 1: {
                    this.renderSaiRight(i);
                    continue block8;
                }
                case 2: {
                    this.renderSaiLeft(i);
                    continue block8;
                }
                case 3: {
                    this.renderShuriken(i);
                    continue block8;
                }
                case 4: {
                    this.renderSmokeBomb(i);
                    continue block8;
                }
                case 5: {
                    this.renderRopeCoil(i);
                }
            }
        }
        GlStateManager.func_179121_F();
    }

    private void renderKatana(int id) {
        RenderItem renderer = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.2);
        GlStateManager.func_179137_b((double)0.0, (double)1.125, (double)0.0);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)1.0);
        renderer.func_181564_a(this.itemsToRender[id], ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    private void renderSaiLeft(int id) {
        RenderItem renderer = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.1);
        GlStateManager.func_179137_b((double)0.0, (double)0.625, (double)0.0);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.275, (double)0.0, (double)0.0);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        renderer.func_181564_a(this.itemsToRender[id], ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    private void renderSaiRight(int id) {
        RenderItem renderer = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.1);
        GlStateManager.func_179137_b((double)0.0, (double)0.625, (double)0.0);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.275, (double)0.0, (double)0.0);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        renderer.func_181564_a(this.itemsToRender[id], ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    private void renderShuriken(int id) {
        RenderItem renderer = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.2);
        GlStateManager.func_179137_b((double)0.0, (double)0.75, (double)0.0);
        GlStateManager.func_179137_b((double)-0.15, (double)0.0, (double)0.0);
        GlStateManager.func_179139_a((double)0.2, (double)0.2, (double)0.5);
        renderer.func_181564_a(this.itemsToRender[id], ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    private void renderSmokeBomb(int id) {
        RenderItem renderer = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.2);
        GlStateManager.func_179137_b((double)0.0, (double)0.75, (double)0.0);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.125, (double)0.0, (double)0.0);
        GlStateManager.func_179139_a((double)0.3, (double)0.3, (double)1.0);
        renderer.func_181564_a(this.itemsToRender[id], ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    private void renderRopeCoil(int id) {
        RenderItem renderer = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.15);
        GlStateManager.func_179137_b((double)0.0, (double)1.25, (double)0.0);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.3, (double)0.0, (double)0.0);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)1.0);
        renderer.func_181564_a(this.itemsToRender[id], ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }
}

