/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft;

import com.song.nuclear_craft.blocks.BlockList;
import com.song.nuclear_craft.blocks.container.ContainerTypeList;
import com.song.nuclear_craft.blocks.tileentity.TileEntityRegister;
import com.song.nuclear_craft.client.ClientSetup;
import com.song.nuclear_craft.effects.EffectRegister;
import com.song.nuclear_craft.entities.EntityRegister;
import com.song.nuclear_craft.items.Ammo.AmmoSize;
import com.song.nuclear_craft.items.Ammo.AmmoType;
import com.song.nuclear_craft.items.ItemList;
import com.song.nuclear_craft.misc.ConfigClient;
import com.song.nuclear_craft.misc.ConfigCommon;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.particles.BigSmokeParticle;
import com.song.nuclear_craft.particles.ExplodeCoreParticle;
import com.song.nuclear_craft.particles.ParticleRegister;
import com.song.nuclear_craft.particles.RestrictedSmokeParticle;
import com.song.nuclear_craft.particles.ShockWaveParticle;
import com.song.nuclear_craft.villagers.PointOfInterestTypes;
import com.song.nuclear_craft.villagers.ProfessionTypes;
import com.song.nuclear_craft.villagers.VillagerUtil;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="nuclear_craft")
public class NuclearCraft {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "nuclear_craft";
    public static final ItemGroup ITEM_GROUP = new ItemGroup("weapons"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemList.ATOMIC_BOMB_ROCKET.get());
        }
    };
    public static final ItemGroup AMMO_ITEM_GROUP = new ItemGroup("bullets"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemList.AMMO_REGISTRIES_TYPE.get((Object)AmmoSize.SIZE_127).get((Object)AmmoType.NORMAL).get());
        }
    };

    public NuclearCraft() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        EntityRegister.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ParticleRegister.PARTICLES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ItemList.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BlockList.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ProfessionTypes.VILLAGER_PROFESSION.register(FMLJavaModLoadingContext.get().getModEventBus());
        PointOfInterestTypes.POINT_OF_INTEREST_TYPE.register(FMLJavaModLoadingContext.get().getModEventBus());
        EffectRegister.EFFECTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigClient.CLIENT);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigCommon.COMMON);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
        LOGGER.info("DIRT BLOCK >> {}", (Object)Blocks.field_150346_d.getRegistryName());
        VillagerUtil.fixPOITypeBlockStates((PointOfInterestType)PointOfInterestTypes.RIFLE_AMMO_SELLER.get());
        VillagerUtil.fixPOITypeBlockStates((PointOfInterestType)PointOfInterestTypes.SHOTGUN_AMMO_SELLER.get());
        VillagerUtil.fixPOITypeBlockStates((PointOfInterestType)PointOfInterestTypes.GUN_SELLER.get());
        VillagerUtil.fixPOITypeBlockStates((PointOfInterestType)PointOfInterestTypes.ROCKET_MASTER.get());
        VillagerUtil.fixPOITypeBlockStates((PointOfInterestType)PointOfInterestTypes.EXPLOSIVE_MASTER.get());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ClientSetup.clientSetup(event);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            LOGGER.info("HELLO from Register Block");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{BlockList.C4_ATOMIC_BOMB, BlockList.C4_HIGH_EXPLOSIVE, BlockList.C4_INCENDIARY, BlockList.C4_SMOKE});
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            LOGGER.info("HELLO from Register Item");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ItemList.C4_ATOMIC_BOMB, ItemList.C4_HIGH_EXPLOSIVE, ItemList.C4_INCENDIARY, ItemList.C4_SMOKE});
        }

        @SubscribeEvent
        public static void onEntityRegistry(RegistryEvent.Register<EntityType<?>> event) {
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{TileEntityRegister.C4_ATOMIC_BOMB_TE_TYPE, TileEntityRegister.C4_HIGH_EXPLOSIVE_TE_TYPE, TileEntityRegister.C4_INCENDIARY_TE_TYPE, TileEntityRegister.C4_SMOKE_TE_TYPE});
        }

        @SubscribeEvent
        public static void onParticleRegistry(RegistryEvent.Register<ParticleType<?>> event) {
        }

        @SubscribeEvent
        public static void onParticleFactoryRegistry(ParticleFactoryRegisterEvent event) {
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegister.NUKE_PARTICLE_SMOKE.get(), BigSmokeParticle.NukeParticleFactory::new);
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegister.NUKE_PARTICLE_FIRE.get(), BigSmokeParticle.NukeParticleFactory::new);
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegister.BIG_SMOKE.get(), BigSmokeParticle.BigSmokeFactory::new);
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegister.RESTRICTED_HEIGHT_SMOKE_PARTICLE.get(), RestrictedSmokeParticle.RestrictedHeightFactory::new);
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegister.MUSHROOM_SMOKE_PARTICLE.get(), RestrictedSmokeParticle.MushroomFactory::new);
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegister.SHOCK_WAVE.get(), ShockWaveParticle.Factory::new);
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegister.EXPLODE_CORE.get(), ExplodeCoreParticle.Factory::new);
        }

        @SubscribeEvent
        public static void onContainerTypeRegistry(RegistryEvent.Register<ContainerType<?>> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{ContainerTypeList.C4_BOMB_CONTAINER_TYPE});
        }

        @SubscribeEvent
        public static void doBothStuff(FMLCommonSetupEvent event) {
            NuclearCraftPacketHandler.register();
        }
    }
}

