/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.blocks;

import com.song.nuclear_craft.blocks.tileentity.C4BombTileEntity;
import com.song.nuclear_craft.items.defuse_kit.DefuseKit;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.network.SoundPacket;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class C4Bomb
extends HorizontalFaceBlock {
    protected static final VoxelShape FLOOR_H_X = Block.func_208617_a((double)4.125, (double)0.0, (double)1.0, (double)12.0, (double)4.0, (double)15.0);
    protected static final VoxelShape FLOOR_H_Z = Block.func_208617_a((double)1.0, (double)0.0, (double)4.125, (double)15.0, (double)4.0, (double)12.0);
    protected static final VoxelShape CEIL_H_X = Block.func_208617_a((double)4.125, (double)12.0, (double)1.0, (double)12.0, (double)16.0, (double)15.0);
    protected static final VoxelShape CEIL_H_Z = Block.func_208617_a((double)1.0, (double)12.0, (double)4.125, (double)15.0, (double)16.0, (double)12.0);
    protected static final VoxelShape WALL_E = Block.func_208617_a((double)0.0, (double)4.125, (double)1.0, (double)4.0, (double)12.0, (double)15.0);
    protected static final VoxelShape WALL_W = Block.func_208617_a((double)12.0, (double)4.125, (double)1.0, (double)16.0, (double)12.0, (double)15.0);
    protected static final VoxelShape WALL_S = Block.func_208617_a((double)1.0, (double)4.125, (double)0.0, (double)15.0, (double)12.0, (double)4.0);
    protected static final VoxelShape WALL_N = Block.func_208617_a((double)1.0, (double)4.125, (double)12.0, (double)15.0, (double)12.0, (double)16.0);

    public C4Bomb(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)field_196366_M, (Comparable)AttachFace.WALL));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public abstract TileEntity createTileEntity(BlockState var1, IBlockReader var2);

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        TileEntity entity;
        if (worldIn.func_175640_z(pos) && (entity = worldIn.func_175625_s(pos)) instanceof C4BombTileEntity) {
            ((C4BombTileEntity)entity).activate();
        }
    }

    public void explode(World world, double x, double y, double z) {
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)field_185512_D);
        switch ((AttachFace)state.func_177229_b((Property)field_196366_M)) {
            case FLOOR: {
                if (direction.func_176740_k() == Direction.Axis.X) {
                    return FLOOR_H_X;
                }
                return FLOOR_H_Z;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return WALL_E;
                    }
                    case WEST: {
                        return WALL_W;
                    }
                    case SOUTH: {
                        return WALL_S;
                    }
                }
                return WALL_N;
            }
        }
        if (direction.func_176740_k() == Direction.Axis.X) {
            return CEIL_H_X;
        }
        return CEIL_H_Z;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, field_196366_M});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            this.func_220069_a(state, worldIn, pos, (Block)this, pos, false);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemStack = player.func_184586_b(Hand.MAIN_HAND);
        if (itemStack.func_77973_b() instanceof DefuseKit) {
            C4BombTileEntity c4BombTileEntity;
            if (!worldIn.func_201670_d() && (c4BombTileEntity = (C4BombTileEntity)worldIn.func_175625_s(pos)) != null && c4BombTileEntity.currentDefuseStatus < 0) {
                c4BombTileEntity.currentDefuseStatus = 0;
                c4BombTileEntity.defuseTime = ((DefuseKit)itemStack.func_77973_b()).getDefuseTick();
                c4BombTileEntity.defusingEntityID = player.func_145782_y();
                c4BombTileEntity.defusingTool = Objects.requireNonNull(itemStack.func_77973_b().getRegistryName()).toString();
                NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)21.0, (RegistryKey)worldIn.func_234923_W_())), (Object)new SoundPacket(pos, "defusing"));
            }
            return ActionResultType.PASS;
        }
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof C4BombTileEntity) {
            ((C4BombTileEntity)tileentity).synToClient();
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((C4BombTileEntity)tileentity), (BlockPos)pos);
        }
        return ActionResultType.CONSUME;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return true;
    }
}

