/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.entities;

import com.song.nuclear_craft.effects.EffectRegister;
import com.song.nuclear_craft.entities.EntityRegister;
import com.song.nuclear_craft.entities.ExplosionUtils;
import com.song.nuclear_craft.misc.ConfigCommon;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.network.NukeMushroomCloudPacket;
import com.song.nuclear_craft.network.NukeRisingSmokePacket;
import com.song.nuclear_craft.network.ParticlePacket;
import com.song.nuclear_craft.network.ShockWaveParticleChannel;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.fml.network.PacketDistributor;

public class NukeExplosionHandler
extends Entity {
    private int age = 0;

    public NukeExplosionHandler(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public NukeExplosionHandler(double x, double y, double z, World world) {
        super((EntityType)EntityRegister.NUKE_EXPLOSION_HANDLER_TYPE.get(), world);
        this.func_70107_b(x, y, z);
        this.onSpawn();
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.age = compound.func_74762_e("age");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("age", this.age);
    }

    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }

    public boolean func_190530_aW() {
        return true;
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
    }

    private void onSpawn() {
        if (!this.field_70170_p.func_201670_d()) {
            for (PlayerEntity player : this.field_70170_p.func_217369_A()) {
                if (!(this.getDistanceSquare(player) < NukeExplosionHandler.getVisionEffectDist())) continue;
                player.func_195064_c(new EffectInstance((Effect)EffectRegister.RADIOACTIVE.get(), 1600, 1));
            }
            NuclearCraftPacketHandler.PARTICLE_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ParticlePacket(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), "nuke_core"));
        }
    }

    private double getDistanceSquare(PlayerEntity player) {
        return player.func_70032_d((Entity)this);
    }

    private static double getVisionEffectDist() {
        return 400.0;
    }

    public static float getBlastRadius() {
        return ((Double)ConfigCommon.NUKE_RADIUS.get()).floatValue();
    }

    public static int getStageOneTick() {
        return 20;
    }

    public static int getStageTwoTick() {
        return 80;
    }

    public static int getStageThreeTick() {
        return 560;
    }

    public void shockWave() {
        if (!this.field_70170_p.func_201670_d()) {
            float multiplier = 2.0f;
            int effectiveHeight = 15;
            int effectRadius = (int)(multiplier * NukeExplosionHandler.getBlastRadius());
            for (int dx = -effectRadius; dx <= effectRadius; ++dx) {
                int yMax = (int)Math.sqrt(effectRadius * effectRadius - dx * dx);
                block1: for (int dz = -yMax; dz <= yMax; ++dz) {
                    int y = this.field_70170_p.func_201676_a(Heightmap.Type.WORLD_SURFACE, (int)this.func_226277_ct_() + dx, (int)this.func_226281_cx_() + dz);
                    BlockPos interested = new BlockPos((int)this.func_226277_ct_() + dx, y - 1, (int)this.func_226281_cx_() + dz);
                    if (!((double)y - this.func_226278_cu_() < (double)effectiveHeight) && !((double)y - this.func_226278_cu_() > (double)(-effectiveHeight))) continue;
                    while ((double)y - this.func_226278_cu_() > (double)(-effectiveHeight)) {
                        BlockPos interested1 = new BlockPos((int)this.func_226277_ct_() + dx, y - 1, (int)this.func_226281_cx_() + dz);
                        BlockState blockState = this.field_70170_p.func_180495_p(interested);
                        this.field_70170_p.func_175655_b(interested1, false);
                        if (blockState.func_185904_a() != Material.field_151575_d && blockState.func_185904_a() != Material.field_151584_j) continue block1;
                        --y;
                    }
                }
            }
        }
    }

    public void effectCore() {
        if (!this.field_70170_p.func_201670_d()) {
            float multiplier = 2.0f;
            int effectiveHeight = 15;
            int effectRadius = (int)(multiplier * NukeExplosionHandler.getBlastRadius());
            for (int dx = -effectRadius; dx <= effectRadius; ++dx) {
                int yMax = (int)Math.sqrt(effectRadius * effectRadius - dx * dx);
                for (int dz = -yMax; dz <= yMax; ++dz) {
                    int y = this.field_70170_p.func_201676_a(Heightmap.Type.WORLD_SURFACE, (int)this.func_226277_ct_() + dx, (int)this.func_226281_cx_() + dz);
                    BlockPos interested = new BlockPos((int)this.func_226277_ct_() + dx, y - 1, (int)this.func_226281_cx_() + dz);
                    if (!((float)(dx * dx + dz * dz) < NukeExplosionHandler.getBlastRadius() * NukeExplosionHandler.getBlastRadius())) continue;
                    if ((double)this.field_70146_Z.nextFloat() < 0.5) {
                        this.field_70170_p.func_175656_a(interested, Blocks.field_150424_aL.func_176223_P());
                        if ((double)this.field_70146_Z.nextFloat() < 0.2) {
                            this.field_70170_p.func_175656_a(interested.func_177972_a(Direction.UP), Blocks.field_150480_ab.func_176223_P());
                        }
                    }
                    if (!((double)this.field_70146_Z.nextFloat() < 0.05)) continue;
                    this.field_70170_p.func_175656_a(interested, Blocks.field_150353_l.func_176223_P());
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.func_201670_d()) {
            if (this.age == NukeExplosionHandler.getStageOneTick()) {
                ExplosionUtils.oldNukeExplode(this.field_70170_p, null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), NukeExplosionHandler.getBlastRadius(), false, (Double)ConfigCommon.NUKE_BLAST_POWER.get());
                this.effectCore();
            }
            if (this.age == NukeExplosionHandler.getStageTwoTick() - 15) {
                NuclearCraftPacketHandler.PARTICLE_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ShockWaveParticleChannel(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), NukeExplosionHandler.getBlastRadius()));
            }
            if (this.age == NukeExplosionHandler.getStageTwoTick() + 10) {
                this.shockWave();
            }
            if (this.age >= NukeExplosionHandler.getStageTwoTick() && this.age % 10 == 0) {
                NuclearCraftPacketHandler.PARTICLE_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new NukeRisingSmokePacket(this.func_226277_ct_(), this.func_226278_cu_() - (double)(NukeExplosionHandler.getBlastRadius() / 1.5f) + 1.0, this.func_226281_cx_(), 0.1 * (double)NukeExplosionHandler.getBlastRadius()));
            }
            if (this.age >= NukeExplosionHandler.getStageThreeTick() && this.age % 10 == 0) {
                NuclearCraftPacketHandler.PARTICLE_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new NukeMushroomCloudPacket(this.func_226277_ct_(), this.func_226278_cu_() + 1.75 * (double)NukeExplosionHandler.getBlastRadius() - (double)(NukeExplosionHandler.getBlastRadius() / 1.5f) + 1.0, this.func_226281_cx_(), 0.25 * (double)NukeExplosionHandler.getBlastRadius()));
            }
            ++this.age;
            if (this.age >= 3000) {
                this.func_70106_y();
            }
        }
    }
}

