/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.entities.rocket_entities;

import com.song.nuclear_craft.entities.ExplosionUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class WaterDropRocketEntity
extends FireworkRocketEntity {
    private int meltCD = 7;
    private final int maxLife;
    private int age = 0;

    public WaterDropRocketEntity(World world, ItemStack itemStack, Entity entity, double v, double v1, double v2, boolean b) {
        super(world, itemStack, entity, v, v1, v2, b);
        this.maxLife = 10000;
    }

    public WaterDropRocketEntity(World world, ItemStack itemStack, Entity entity, double v, double v1, double v2, boolean b, int maxLife) {
        super(world, itemStack, entity, v, v1, v2, b);
        this.maxLife = maxLife;
    }

    protected void func_213868_a(EntityRayTraceResult rayTraceResult) {
        Vector3d hitPoint = rayTraceResult.func_216347_e();
        this.meltDown(this.field_70170_p, hitPoint.field_72450_a, hitPoint.field_72448_b, hitPoint.field_72449_c);
        this.meltCD = 2;
    }

    protected void func_230299_a_(BlockRayTraceResult rayTraceResult) {
        Vector3d hitPoint = rayTraceResult.func_216347_e();
        this.meltDown(this.field_70170_p, hitPoint.field_72450_a, hitPoint.field_72448_b, hitPoint.field_72449_c);
        this.meltCD = 2;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (--this.meltCD == 0) {
            this.meltDown(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            this.meltCD = 2;
        }
        if (!this.field_70170_p.field_72995_K) {
            ++this.age;
            if (this.func_226278_cu_() > 300.0 && this.func_213322_ci().func_82617_b() > 0.0) {
                this.func_70106_y();
            }
            if (this.age > this.maxLife) {
                this.func_70106_y();
            }
        }
    }

    private void meltDown(World world, double x, double y, double z) {
        if (!world.field_72995_K) {
            float radius = 10.0f;
            List<BlockPos> affectedBlockPositions = ExplosionUtils.getAffectedBlockPositions(world, x, y, z, radius, 3600002.0);
            for (BlockPos blockPos : affectedBlockPositions) {
                if (blockPos.func_218141_a(new Vector3i(x, y, z), (double)(radius / 4.0f))) {
                    world.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
                    continue;
                }
                Block block = world.func_180495_p(blockPos).func_177230_c();
                if (block == Blocks.field_150348_b) {
                    world.func_175656_a(blockPos, Blocks.field_235406_np_.func_176223_P());
                    continue;
                }
                if (BlockTags.field_200031_h.func_230235_a_((Object)block)) {
                    world.func_175656_a(blockPos, Blocks.field_150402_ci.func_176223_P());
                    continue;
                }
                if (block == Blocks.field_150357_h) {
                    world.func_175656_a(blockPos, Blocks.field_150343_Z.func_176223_P());
                    continue;
                }
                if ((double)this.field_70146_Z.nextFloat() < 0.95) {
                    world.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
                    continue;
                }
                world.func_175656_a(blockPos, (BlockState)Blocks.field_150353_l.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208132_ag, (Comparable)Integer.valueOf(15)));
            }
        }
    }
}

