/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.events;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.song.nuclear_craft.blocks.container.C4BombContainer;
import com.song.nuclear_craft.blocks.container.C4BombContainerScreen;
import com.song.nuclear_craft.client.ScopeZoomGui;
import com.song.nuclear_craft.items.guns.AbstractGunItem;
import com.song.nuclear_craft.misc.SoundEventList;
import com.song.nuclear_craft.network.C4BombSettingPacket;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nuclear_craft", value={Dist.CLIENT})
public class ClientEventForgeSubscriber {
    private static final ResourceLocation BUTTON_X = new ResourceLocation("nuclear_craft", "textures/gui/button/button_x.png");
    private static final ResourceLocation BUTTON_SKELETON = new ResourceLocation("nuclear_craft", "textures/gui/button/button_skeleton.png");
    public static KeyBinding gunReload;
    public static KeyBinding zoom;
    private static int zoomState;
    private static int prevZoomState;
    private static double mouseSensitivityBefore;
    private static final float fovBefore = 1.0f;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        MatrixStack matrixStack = event.getMatrixStack();
        matrixStack.func_227860_a_();
        IVertexBuilder builder = renderTypeBuffer.getBuffer(RenderType.func_228645_f_());
        builder.func_227885_a_(255.0f, 0.0f, 0.0f, 255.0f);
        renderTypeBuffer.func_228462_a_(RenderType.func_228645_f_());
        matrixStack.func_227865_b_();
    }

    @SubscribeEvent
    public void onInitGuiEvent(GuiScreenEvent.InitGuiEvent event) {
        Screen gui = event.getGui();
        if (gui instanceof C4BombContainerScreen) {
            int i = (gui.field_230708_k_ - ((C4BombContainerScreen)gui).getXSize()) / 2;
            int j = (gui.field_230709_l_ - ((C4BombContainerScreen)gui).getYSize()) / 2;
            int input_id = 1;
            block0: for (int row = 0; row <= 2; ++row) {
                for (int col = 0; col <= 3; ++col) {
                    int finalInput_id = input_id;
                    event.addWidget((Widget)new Button(i + 14 + col * 30, j + 57 + row * 30, 20, 20, (ITextComponent)new StringTextComponent("" + input_id), button -> NuclearCraftPacketHandler.C4_SETTING_CHANNEL.sendToServer((Object)new C4BombSettingPacket(((C4BombContainer)((C4BombContainerScreen)gui).func_212873_a_()).tileEntity.func_174877_v(), "add_" + finalInput_id))));
                    ++input_id;
                    if (row != 2) continue;
                    ++row;
                    continue block0;
                }
            }
            event.addWidget((Widget)new Button(i + 44, j + 117, 20, 20, (ITextComponent)new StringTextComponent("0"), button -> NuclearCraftPacketHandler.C4_SETTING_CHANNEL.sendToServer((Object)new C4BombSettingPacket(((C4BombContainer)((C4BombContainerScreen)gui).func_212873_a_()).tileEntity.func_174877_v(), "add_0"))));
            event.addWidget((Widget)new ImageButton(i + 74, j + 117, 20, 20, 0, 0, 2, BUTTON_X, 20, 20, button -> NuclearCraftPacketHandler.C4_SETTING_CHANNEL.sendToServer((Object)new C4BombSettingPacket(((C4BombContainer)((C4BombContainerScreen)gui).func_212873_a_()).tileEntity.func_174877_v(), "delete"))));
            event.addWidget((Widget)new ImageButton(i + 104, j + 117, 20, 20, 0, 0, 2, BUTTON_SKELETON, 20, 20, button -> NuclearCraftPacketHandler.C4_SETTING_CHANNEL.sendToServer((Object)new C4BombSettingPacket(((C4BombContainer)((C4BombContainerScreen)gui).func_212873_a_()).tileEntity.func_174877_v(), "activate"))));
        }
    }

    @SubscribeEvent
    public void onFovUpdate(FOVUpdateEvent event) {
        PlayerEntity entity = event.getEntity();
        Item item = entity.func_184614_ca().func_77973_b();
        if (zoom.func_151468_f()) {
            if (item instanceof AbstractGunItem && ((AbstractGunItem)item).canUseScope()) {
                zoomState = (zoomState + 1) % 3;
                entity.func_184185_a(SoundEventList.ZOOM, 1.0f, 1.0f);
            }
        } else if (!(item instanceof AbstractGunItem) || !((AbstractGunItem)item).canUseScope()) {
            zoomState = 0;
        }
        switch (zoomState) {
            default: {
                if (prevZoomState != 0) {
                    Minecraft.func_71410_x().field_71474_y.field_74341_c = mouseSensitivityBefore;
                } else {
                    mouseSensitivityBefore = Minecraft.func_71410_x().field_71474_y.field_74341_c;
                }
                prevZoomState = 0;
                break;
            }
            case 1: {
                event.setNewfov(0.33f);
                Minecraft.func_71410_x().field_71474_y.field_74341_c = 0.33 * mouseSensitivityBefore;
                prevZoomState = 1;
                break;
            }
            case 2: {
                event.setNewfov(0.1f);
                Minecraft.func_71410_x().field_71474_y.field_74341_c = 0.1 * mouseSensitivityBefore;
                prevZoomState = 2;
            }
        }
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent event) {
        if (zoomState > 0) {
            MainWindow window = event.getWindow();
            new ScopeZoomGui(Minecraft.func_71410_x()).drawGuiContainerBackgroundLayer(event.getMatrixStack(), window.func_198099_q(), window.func_198079_r(), window.func_198107_o(), window.func_198087_p());
        }
    }

    @SubscribeEvent
    public void onPlayerRender(RenderPlayerEvent event) {
        PlayerEntity playerEntity = event.getPlayer();
        if (playerEntity.func_184614_ca().func_77973_b() instanceof AbstractGunItem && event.isCancelable()) {
            ((PlayerModel)event.getRenderer().func_217764_d()).field_187076_m = BipedModel.ArmPose.CROSSBOW_HOLD;
            ((PlayerModel)event.getRenderer().func_217764_d()).field_187076_m = BipedModel.ArmPose.CROSSBOW_HOLD;
        }
    }

    @SubscribeEvent
    public void onHandRender(RenderHandEvent event) {
        if (zoomState > 0) {
            event.setCanceled(true);
        }
    }

    static {
        zoomState = 0;
        prevZoomState = 0;
        mouseSensitivityBefore = Minecraft.func_71410_x().field_71474_y.field_74341_c;
    }
}

