/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.items.Ammo;

import com.song.nuclear_craft.items.AbstractAmmo;
import com.song.nuclear_craft.items.ItemList;
import javax.annotation.Nonnull;

public enum AmmoType {
    ANTI_GRAVITY("Anti-Gravity", "anti_gravity", 5.0f, 25.0f, 0.0f),
    EXPLOSIVE("Explosive", "explosive", 5.0f, 20.0f, 0.03f),
    INCENDIARY("Incendiary", "incendiary", 5.0f, 20.0f, 0.03f),
    NORMAL("Normal", "normal", 5.0f, 27.0f, 0.03f),
    NUKE("Nuke", "nuke", 6.0f, 30.0f, 0.03f),
    SILVER("Silver", "silver", 7.0f, 40.0f, 0.03f),
    TUNGSTEN("Tungsten", "tungsten", 8.0f, 50.0f, 0.03f),
    SHORT_GUN_NORMAL("Normal", "short_gun_normal", 5.0f, 7.0f, 0.03f, 10),
    SHORT_GUN_BLIGHT("Blight", "short_gun_blight", 5.0f, 7.0f, 0.03f, 10),
    SHORT_GUN_DESOLATOR("Desolator", "short_gun_desolator", 5.0f, 7.0f, 0.03f, 10);

    private final String description;
    private final String registerString;
    private final float speed;
    private final float damage;
    private final float gravity;
    private int birdShotCount = 0;

    private AmmoType(String description, String registerString, float speed, float damage, float gravity) {
        this.description = description;
        this.registerString = registerString;
        this.speed = speed;
        this.damage = damage;
        this.gravity = gravity;
    }

    private AmmoType(String description, String registerString, float speed, float damage, float gravity, int birdShotCount) {
        this(description, registerString, speed, damage, gravity);
        this.birdShotCount = birdShotCount;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public String getRegisterString() {
        return this.registerString;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getGravity() {
        return this.gravity;
    }

    public int getBirdShotCount() {
        return this.birdShotCount;
    }

    public static AbstractAmmo getBirdShotFromType(AmmoType ammoType) {
        return (AbstractAmmo)ItemList.BIRD_SHOT_MAP.get((Object)ammoType).get();
    }
}

