/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.items.guns;

import com.song.nuclear_craft.entities.AbstractAmmoEntity;
import com.song.nuclear_craft.entities.AmmoEntities.IAmmoEntityFactory;
import com.song.nuclear_craft.events.ClientEventForgeSubscriber;
import com.song.nuclear_craft.items.AbstractAmmo;
import com.song.nuclear_craft.items.Ammo.AmmoPossibleCombination;
import com.song.nuclear_craft.items.Ammo.AmmoSize;
import com.song.nuclear_craft.items.Ammo.AmmoType;
import com.song.nuclear_craft.items.ItemList;
import com.song.nuclear_craft.items.RocketLauncherWithAmmo;
import com.song.nuclear_craft.network.GunLoadingPacket;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.network.SoundPacket;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class AbstractGunItem
extends Item {
    protected int coolDown;

    public AbstractGunItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        ItemStack heldItemStack = playerIn.func_184586_b(handIn);
        if (heldItemStack.func_77973_b() instanceof AbstractGunItem) {
            AbstractGunItem gunItem = (AbstractGunItem)heldItemStack.func_77973_b();
            if (!worldIn.field_72995_K && AbstractGunItem.hasAmmo(heldItemStack)) {
                AmmoType ammoType = AbstractGunItem.getAmmoType(heldItemStack);
                assert (ammoType != null);
                AmmoSize ammoSize = this.compatibleSize();
                if (gunItem.getCoolDown() > 0) {
                    playerIn.func_184811_cZ().func_185145_a(heldItemStack.func_77973_b(), gunItem.getCoolDown());
                }
                AbstractAmmo ammoItem = gunItem.getAmmoItem(ammoType, ammoSize);
                ItemStack toBeFired = new ItemStack((IItemProvider)ammoItem);
                Vector3d lookVec = playerIn.func_70040_Z();
                for (int i = 0; i < this.getBirdShotCount(ammoType); ++i) {
                    AbstractAmmoEntity entity = this.getAmmoEntity(gunItem, playerIn, lookVec, toBeFired, worldIn, ammoItem, ammoType, ammoSize);
                    entity.func_70186_c(lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c, ammoItem.getBaseSpeed() * this.getSpeedModifier(), this.getInaccuracy(worldIn, playerIn));
                    worldIn.func_217376_c((Entity)entity);
                }
                BlockPos pos = playerIn.func_233580_cy_();
                NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)this.getGunSoundDist(), (RegistryKey)playerIn.field_70170_p.func_234923_W_())), (Object)new SoundPacket(pos, this.getShootActionString()));
                AbstractGunItem.shrinkAmmoNBT(heldItemStack);
                return ActionResult.func_233538_a_((Object)heldItemStack, (boolean)worldIn.func_201670_d());
            }
            if (!worldIn.field_72995_K) {
                BlockPos pos = playerIn.func_233580_cy_();
                NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)4.0, (RegistryKey)playerIn.field_70170_p.func_234923_W_())), (Object)new SoundPacket(pos, "no_ammo"));
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private AbstractAmmoEntity getAmmoEntity(AbstractGunItem gunItem, PlayerEntity playerIn, Vector3d lookVec, ItemStack toBeFired, World worldIn, AbstractAmmo ammoItem, AmmoType ammoType, AmmoSize ammoSize) {
        AbstractAmmoEntity entity = gunItem.getAmmoEntity(playerIn.func_226277_ct_() + lookVec.field_72450_a * 0.1, playerIn.func_226280_cw_() - (double)0.15f + lookVec.field_72448_b * 0.1, playerIn.func_226281_cx_() + lookVec.field_72449_c * 0.1, worldIn, toBeFired, playerIn, ammoType, ammoSize);
        entity.func_174810_b(true);
        entity.func_189654_d(true);
        entity.setGravity(ammoItem.getGravity());
        entity.setBaseDamage(this.getDamageModifier() * entity.getBaseDamage());
        return entity;
    }

    protected float getInaccuracy(World world, PlayerEntity playerEntity) {
        return 0.0f;
    }

    protected int getBirdShotCount(AmmoType ammoType) {
        return 1;
    }

    protected double getGunSoundDist() {
        return 20.0;
    }

    public static boolean hasAmmo(ItemStack itemStack) {
        CompoundNBT nbt = itemStack.func_179543_a("ammo");
        if (nbt == null) {
            return false;
        }
        int nAmmo = nbt.func_74762_e("count");
        if (nAmmo > 0) {
            return true;
        }
        AbstractGunItem.clearAmmoNBT(itemStack);
        return false;
    }

    public static void clearAmmoNBT(ItemStack itemStack) {
        itemStack.func_196083_e("ammo");
    }

    public static int getAmmoCount(ItemStack itemStack) {
        CompoundNBT nbt = itemStack.func_179543_a("ammo");
        if (nbt == null) {
            return 0;
        }
        int nAmmo = nbt.func_74762_e("count");
        if (nAmmo > 0) {
            return nAmmo;
        }
        AbstractGunItem.clearAmmoNBT(itemStack);
        return 0;
    }

    public static void addAmmoNBT(ItemStack itemStack, int n, String type) {
        CompoundNBT nbt = itemStack.func_190925_c("ammo");
        nbt.func_74768_a("count", nbt.func_74762_e("count") + n);
        nbt.func_74778_a("type", type);
    }

    public static void shrinkAmmoNBT(ItemStack itemStack) {
        int nAmmo = AbstractGunItem.getAmmoCount(itemStack);
        int nAmmoAfter = nAmmo - 1;
        if (nAmmoAfter <= 0) {
            AbstractGunItem.clearAmmoNBT(itemStack);
        } else {
            CompoundNBT nbt = itemStack.func_190925_c("ammo");
            nbt.func_74768_a("count", nAmmoAfter);
        }
    }

    public static AmmoType getAmmoType(ItemStack itemStack) {
        CompoundNBT nbt = itemStack.func_179543_a("ammo");
        if (nbt == null) {
            return null;
        }
        return AmmoType.valueOf(nbt.func_74779_i("type"));
    }

    public static String getAmmoShowType(ItemStack itemStack) {
        AmmoType type = AbstractGunItem.getAmmoType(itemStack);
        return type == null ? "none" : type.getDescription();
    }

    public AbstractAmmo getAmmoItem(AmmoType ammoType, AmmoSize ammoSize) {
        if (AmmoPossibleCombination.SHOTGUN_AMMO.getAmmoTypes().contains((Object)ammoType)) {
            return AmmoType.getBirdShotFromType(ammoType);
        }
        return (AbstractAmmo)ItemList.AMMO_REGISTRIES_TYPE.get((Object)ammoSize).get((Object)ammoType).get();
    }

    public abstract int getCoolDown();

    public AbstractAmmoEntity getAmmoEntity(double x, double y, double z, World world, ItemStack toBeFired, PlayerEntity shooter, AmmoType ammoType, AmmoSize ammoSize) {
        return IAmmoEntityFactory.getAmmoEntityFactory(ammoType).create(x, y, z, world, toBeFired, shooter);
    }

    protected int getAmmoCountPerLoad() {
        return -1;
    }

    public void addAmmo(ItemStack offhand, ItemStack mainHand, int slot, PlayerEntity entity) {
        ItemStack ammo = this.findAmmo(offhand, mainHand, slot, entity);
        if (ammo != null) {
            AbstractAmmo ammoItem = (AbstractAmmo)ammo.func_77973_b();
            if (AbstractGunItem.hasAmmo(mainHand) && ammoItem.getType() == AbstractGunItem.getAmmoType(mainHand) || !AbstractGunItem.hasAmmo(mainHand)) {
                int n_load = 0;
                n_load = this.getAmmoCountPerLoad() > 0 ? Math.min(this.getAmmoCountPerLoad(), this.maxAmmo() - AbstractGunItem.getAmmoCount(mainHand)) : Math.min(ammo.func_190916_E(), this.maxAmmo() - AbstractGunItem.getAmmoCount(mainHand));
                if (n_load > 0) {
                    ammo.func_190918_g(n_load);
                    AbstractGunItem.addAmmoNBT(mainHand, n_load, ammoItem.getType().name());
                    entity.func_184811_cZ().func_185145_a(mainHand.func_77973_b(), this.getLoadTime());
                    if (!entity.field_70170_p.field_72995_K) {
                        BlockPos pos = entity.func_233580_cy_();
                        NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)10.0, (RegistryKey)entity.field_70170_p.func_234923_W_())), (Object)new SoundPacket(pos, this.getReloadSound()));
                    }
                }
            }
        }
    }

    public ItemStack findAmmo(ItemStack offhand, ItemStack mainHand, int slot, PlayerEntity entity) {
        if (offhand.func_77973_b() instanceof AbstractAmmo && ((AbstractAmmo)offhand.func_77973_b()).getSize() == this.compatibleSize()) {
            return offhand;
        }
        for (ItemStack stack : entity.field_71071_by.field_70462_a) {
            if (!(stack.func_77973_b() instanceof AbstractAmmo) || ((AbstractAmmo)stack.func_77973_b()).getSize() != this.compatibleSize()) continue;
            return stack;
        }
        return null;
    }

    public abstract String getShootActionString();

    public abstract int maxAmmo();

    public abstract int getLoadTime();

    @Nonnull
    public abstract AmmoSize compatibleSize();

    public abstract float getSpeedModifier();

    public abstract double getDamageModifier();

    public abstract String getReloadSound();

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (isSelected && worldIn.field_72995_K) {
            if (ClientEventForgeSubscriber.gunReload.func_151468_f() && entityIn instanceof PlayerEntity) {
                NuclearCraftPacketHandler.KEY_BIND.sendToServer((Object)new GunLoadingPacket(itemSlot));
            }
            Minecraft.func_71410_x().field_71456_v.func_175188_a((ITextComponent)new TranslationTextComponent(String.format("item.%s.guns.ammo_left", "nuclear_craft")).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(" " + AbstractGunItem.getAmmoCount(stack)).func_240699_a_(TextFormatting.GOLD)), false);
        }
    }

    public static void tryLoadAmmo(ServerWorld world, PlayerEntity entity, int itemSlot) {
        ItemStack itemStackMain = entity.func_184614_ca();
        if (itemStackMain.func_77973_b() instanceof AbstractGunItem && !entity.func_184811_cZ().func_185141_a(itemStackMain.func_77973_b())) {
            ItemStack itemStackOff = entity.func_184592_cb();
            ((AbstractGunItem)itemStackMain.func_77973_b()).addAmmo(itemStackOff, itemStackMain, itemSlot, entity);
        } else if (itemStackMain.func_77973_b() instanceof RocketLauncherWithAmmo) {
            ItemStack itemStackOff = entity.func_184592_cb();
            ((RocketLauncherWithAmmo)itemStackMain.func_77973_b()).addAmmo(itemStackOff, itemStackMain, itemSlot, (Entity)entity);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (AbstractGunItem.hasAmmo(stack)) {
            int n_ammo = AbstractGunItem.getAmmoCount(stack);
            tooltip.add((ITextComponent)new TranslationTextComponent(String.format("item.%s.guns.ammo_left", "nuclear_craft")).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(" " + n_ammo).func_240699_a_(TextFormatting.GOLD)));
            tooltip.add((ITextComponent)new TranslationTextComponent(String.format("item.%s.guns.ammo_type", "nuclear_craft")).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(Objects.requireNonNull(AbstractGunItem.getAmmoType(stack)).getDescription()).func_240699_a_(TextFormatting.GOLD)));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent(String.format("item.%s.guns.compatible_ammo_size", "nuclear_craft")).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(" " + (Object)((Object)this.compatibleSize()))));
        tooltip.add((ITextComponent)new TranslationTextComponent(String.format("item.%s.guns.damage_modifier", "nuclear_craft")).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(String.format(" %.0f", 100.0 * this.getDamageModifier()) + "%")));
        tooltip.add((ITextComponent)new TranslationTextComponent(String.format("item.%s.guns.speed_modifier", "nuclear_craft")).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(String.format(" %.0f", Float.valueOf(100.0f * this.getSpeedModifier())) + "%")));
        if (this.canUseScope()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(String.format("item.%s.guns.use_scope", "nuclear_craft")).func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(" Z")));
        }
    }

    public boolean canUseScope() {
        return false;
    }
}

