/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.misc;

import com.song.nuclear_craft.items.Ammo.AmmoPossibleCombination;
import com.song.nuclear_craft.items.Ammo.AmmoSize;
import com.song.nuclear_craft.items.Ammo.AmmoType;
import com.song.nuclear_craft.items.GunConfigurable;
import java.util.HashMap;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigCommon {
    public static ForgeConfigSpec COMMON;
    public static ForgeConfigSpec.DoubleValue NUKE_RADIUS;
    public static ForgeConfigSpec.DoubleValue HIGH_EXPLOSIVE_RADIUS;
    public static ForgeConfigSpec.DoubleValue SMOKE_RADIUS;
    public static ForgeConfigSpec.IntValue INCENDIARY_COUNT;
    public static ForgeConfigSpec.IntValue HIGH_EXPLOSIVE_MAX_AMMO;
    public static ForgeConfigSpec.IntValue INCENDIARY_MAX_AMMO;
    public static ForgeConfigSpec.IntValue SMOKE_MAX_AMMO;
    public static ForgeConfigSpec.IntValue WATER_DROP_MAX_AMMO;
    public static ForgeConfigSpec.DoubleValue NUKE_BLAST_POWER;
    public static ForgeConfigSpec.DoubleValue HIGH_EXPLOSIVE_BLAST_POWER;
    public static ForgeConfigSpec.DoubleValue AMMO_ANTI_GRAVITY_RICOCHET_LOSS;
    public static ForgeConfigSpec.DoubleValue AMMO_NORMAL_RICOCHET_LOSS;
    public static ForgeConfigSpec.DoubleValue AMMO_SILVER_RICOCHET_LOSS;
    public static ForgeConfigSpec.DoubleValue AMMO_TUNGSTEN_RICOCHET_LOSS;
    public static final HashMap<AmmoSize, HashMap<AmmoType, ForgeConfigSpec.DoubleValue>> DAMAGE_MAP;
    public static final HashMap<AmmoSize, HashMap<AmmoType, ForgeConfigSpec.DoubleValue>> SPEED_MAP;
    public static final HashMap<AmmoSize, HashMap<AmmoType, ForgeConfigSpec.DoubleValue>> GRAVITY_MAP;
    public static final HashMap<AmmoType, ForgeConfigSpec.IntValue> BIRD_SHOT_COUNT_MAP;
    public static final GunConfigurable AK47_CONFIG;
    public static final GunConfigurable DESERT_EAGLE_CONFIG;
    public static final GunConfigurable GLOCK_CONFIG;
    public static final GunConfigurable USP_CONFIG;
    public static final GunConfigurable AWP_CONFIG;
    public static final GunConfigurable BARRETT_CONFIG;
    public static final GunConfigurable M4A4_CONFIG;
    public static final ForgeConfigSpec.DoubleValue AMMO_BLOCK_BREAK_THRESHOLD;
    public static final ForgeConfigSpec.DoubleValue AMMO_SILVER_BLOCK_BREAK_THRESHOLD;
    public static final ForgeConfigSpec.DoubleValue AMMO_TUNGSTEN_BLOCK_BREAK_THRESHOLD;
    public static final HashMap<String, ForgeConfigSpec.IntValue> LEVEL_MAP;
    public static final HashMap<String, ForgeConfigSpec.ConfigValue<String>> PRICE1_MAP;
    public static final HashMap<String, ForgeConfigSpec.ConfigValue<String>> PRICE2_MAP;
    public static final HashMap<String, ForgeConfigSpec.IntValue> PRICE1_MIN;
    public static final HashMap<String, ForgeConfigSpec.IntValue> PRICE2_MIN;
    public static final HashMap<String, ForgeConfigSpec.IntValue> PRICE1_MAX;
    public static final HashMap<String, ForgeConfigSpec.IntValue> PRICE2_MAX;
    public static final ForgeConfigSpec.IntValue WOOD_DEFUSE_KIT_TIME;
    public static final ForgeConfigSpec.IntValue IRON_DEFUSE_KIT_TIME;
    public static final ForgeConfigSpec.IntValue GOLD_DEFUSE_KIT_TIME;
    public static final ForgeConfigSpec.IntValue DIAMOND_DEFUSE_KIT_TIME;
    public static final ForgeConfigSpec.IntValue NETHERITE_DEFUSE_KIT_TIME;

    private static void addTrader(String id, int level, String price1, int price1Min, int price1Max, String price2, int price2Min, int price2Max, ForgeConfigSpec.Builder builder) {
        builder.push(id);
        LEVEL_MAP.put("nuclear_craft:" + id, builder.defineInRange(id + "_level", level, 1, 64));
        PRICE1_MAP.put("nuclear_craft:" + id, (ForgeConfigSpec.ConfigValue<String>)builder.define(id + "_price1", (Object)price1));
        PRICE1_MIN.put("nuclear_craft:" + id, builder.defineInRange(id + "_price1_min", price1Min, 1, 64));
        PRICE1_MAX.put("nuclear_craft:" + id, builder.defineInRange(id + "_price1_max", price1Max, 1, 64));
        PRICE2_MAP.put("nuclear_craft:" + id, (ForgeConfigSpec.ConfigValue<String>)builder.define(id + "_price2", (Object)price2));
        PRICE2_MIN.put("nuclear_craft:" + id, builder.defineInRange(id + "_price2_min", price2Min, 1, 64));
        PRICE2_MAX.put("nuclear_craft:" + id, builder.defineInRange(id + "_price2_max", price2Max, 1, 64));
        builder.pop();
    }

    static {
        HashMap<AmmoType, ForgeConfigSpec.DoubleValue> thisGravityMap;
        HashMap<AmmoType, ForgeConfigSpec.DoubleValue> thisSpeedMap;
        HashMap<AmmoType, ForgeConfigSpec.DoubleValue> thisDamageMap;
        DAMAGE_MAP = new HashMap();
        SPEED_MAP = new HashMap();
        GRAVITY_MAP = new HashMap();
        BIRD_SHOT_COUNT_MAP = new HashMap();
        AK47_CONFIG = new GunConfigurable();
        DESERT_EAGLE_CONFIG = new GunConfigurable();
        GLOCK_CONFIG = new GunConfigurable();
        USP_CONFIG = new GunConfigurable();
        AWP_CONFIG = new GunConfigurable();
        BARRETT_CONFIG = new GunConfigurable();
        M4A4_CONFIG = new GunConfigurable();
        LEVEL_MAP = new HashMap();
        PRICE1_MAP = new HashMap();
        PRICE2_MAP = new HashMap();
        PRICE1_MIN = new HashMap();
        PRICE2_MIN = new HashMap();
        PRICE1_MAX = new HashMap();
        PRICE2_MAX = new HashMap();
        ForgeConfigSpec.Builder CONFIG_BUILDER = new ForgeConfigSpec.Builder();
        CONFIG_BUILDER.comment("Ammo destroying block settings").push("ammo_break_block");
        AMMO_BLOCK_BREAK_THRESHOLD = CONFIG_BUILDER.comment("Normal ammo can break blocks with blast resist lower than this value").defineInRange("ammo_block_break_threshold", 3.0, -10.0, 99999.0);
        AMMO_SILVER_BLOCK_BREAK_THRESHOLD = CONFIG_BUILDER.comment("Silver ammo can break blocks with blast resist lower than this value").defineInRange("ammo_silver_block_break_threshold", 6.0, -10.0, 99999.0);
        AMMO_TUNGSTEN_BLOCK_BREAK_THRESHOLD = CONFIG_BUILDER.comment("Tungsten ammo can break blocks with blast resist lower than this value").defineInRange("ammo_tungsten_block_break_threshold", 6.0, -10.0, 99999.0);
        CONFIG_BUILDER.pop();
        CONFIG_BUILDER.comment("Rocket ammo number settings").push("rocket_ammo_number");
        HIGH_EXPLOSIVE_MAX_AMMO = CONFIG_BUILDER.comment("Max number of ammo of high explosive rocket launcher").defineInRange("high_explosive_ammo", 1, 0, Short.MAX_VALUE);
        INCENDIARY_MAX_AMMO = CONFIG_BUILDER.comment("Max number of ammo of incendiary rocket launcher").defineInRange("incendiary_ammo", 1, 0, Short.MAX_VALUE);
        SMOKE_MAX_AMMO = CONFIG_BUILDER.comment("Max number of ammo of smoke rocket launcher").defineInRange("smoke_ammo", 1, 0, Short.MAX_VALUE);
        WATER_DROP_MAX_AMMO = CONFIG_BUILDER.comment("Max number of ammo of water drop rocket launcher").defineInRange("water_drop_ammo", 1, 0, Short.MAX_VALUE);
        CONFIG_BUILDER.pop();
        CONFIG_BUILDER.comment("Explosion settings").push("explosion");
        NUKE_RADIUS = CONFIG_BUILDER.comment("Atomic bomb explosion radius").defineInRange("nuke_radius", 50.0, 0.0, 256.0);
        HIGH_EXPLOSIVE_RADIUS = CONFIG_BUILDER.comment("High explosive bomb radius").defineInRange("high_explosive", 10.0, 0.0, 80.0);
        SMOKE_RADIUS = CONFIG_BUILDER.comment("Smoke bomb radius").defineInRange("smoke_bomb", 30.0, 0.0, 256.0);
        NUKE_BLAST_POWER = CONFIG_BUILDER.comment("Atomic bomb explosion power(i.e. max blast resistance block to break) 3,600,000 for bedrock, 1200 for obsidian, 100 for water").defineInRange("nuke_blast_power", 1500.0, 0.0, 9.99999999E8);
        HIGH_EXPLOSIVE_BLAST_POWER = CONFIG_BUILDER.comment("High explosive bomb explosion power(i.e. max blast resistance block to break) 3,600,000 for bedrock, 1200 for obsidian, 100 for water").defineInRange("high_explosive_blast_power", 101.0, 0.0, 9.99999999E8);
        CONFIG_BUILDER.pop();
        CONFIG_BUILDER.comment("Ricochet, gravity, incendiary fire count").push("misc");
        INCENDIARY_COUNT = CONFIG_BUILDER.comment("Number of flames from incendiary").defineInRange("incendiary_bomb", 100, 0, 10000);
        AMMO_ANTI_GRAVITY_RICOCHET_LOSS = CONFIG_BUILDER.comment("Energy loss of ammo (Anti-Gravity) after ricochet (bouncing on hard surfaces)").defineInRange("ammo_anti_gravity_ricochet_loss", 0.5, 0.0, 1.0);
        AMMO_NORMAL_RICOCHET_LOSS = CONFIG_BUILDER.comment("Energy loss of ammo (Normal) after ricochet (bouncing on hard surfaces)").defineInRange("ammo_normal_ricochet_loss", 0.5, 0.0, 1.0);
        AMMO_SILVER_RICOCHET_LOSS = CONFIG_BUILDER.comment("Energy loss of ammo (SILVER) after ricochet (bouncing on hard surfaces)").defineInRange("ammo_silver_ricochet_loss", 0.5, 0.0, 1.0);
        AMMO_TUNGSTEN_RICOCHET_LOSS = CONFIG_BUILDER.comment("Energy loss of ammo (TUNGSTEN) after ricochet (bouncing on hard surfaces)").defineInRange("ammo_tungsten_ricochet_loss", 0.5, 0.0, 1.0);
        CONFIG_BUILDER.pop();
        CONFIG_BUILDER.comment("Rifle Ammo Speed and Damage").push("rifle_ammo");
        for (AmmoSize ammoSize : AmmoPossibleCombination.RIFLE_AMMO.getAmmoSizes()) {
            CONFIG_BUILDER.push(ammoSize.getRegisterString());
            thisDamageMap = new HashMap<AmmoType, ForgeConfigSpec.DoubleValue>();
            thisSpeedMap = new HashMap<AmmoType, ForgeConfigSpec.DoubleValue>();
            thisGravityMap = new HashMap<AmmoType, ForgeConfigSpec.DoubleValue>();
            for (AmmoType ammoType : AmmoPossibleCombination.RIFLE_AMMO.getAmmoTypes()) {
                thisDamageMap.put(ammoType, CONFIG_BUILDER.comment("Base damage, base speed(m/tick) and gravity(m/tick^2) of ammo: " + ammoType.getDescription() + " " + ammoSize.getDescription()).defineInRange("damage_" + ammoType.getRegisterString() + "_" + ammoSize.getRegisterString(), (double)(ammoType.getDamage() * ammoSize.getDamageModify()), 0.0, 999999.0));
                thisSpeedMap.put(ammoType, CONFIG_BUILDER.defineInRange("speed_" + ammoType.getRegisterString() + "_" + ammoSize.getRegisterString(), (double)(ammoType.getSpeed() * ammoSize.getSpeedModify()), 0.0, 999999.0));
                thisGravityMap.put(ammoType, CONFIG_BUILDER.defineInRange("gravity_" + ammoType.getRegisterString() + "_" + ammoSize.getRegisterString(), (double)ammoType.getGravity(), 0.0, 999999.0));
            }
            DAMAGE_MAP.put(ammoSize, thisDamageMap);
            SPEED_MAP.put(ammoSize, thisSpeedMap);
            GRAVITY_MAP.put(ammoSize, thisGravityMap);
            CONFIG_BUILDER.pop();
        }
        CONFIG_BUILDER.pop();
        CONFIG_BUILDER.comment("Shotguns Ammo Speed, Damage, bird shots").push("shotgun_ammo");
        for (AmmoSize ammoSize : AmmoPossibleCombination.SHOTGUN_AMMO.getAmmoSizes()) {
            CONFIG_BUILDER.push(ammoSize.getRegisterString());
            thisDamageMap = new HashMap();
            thisSpeedMap = new HashMap();
            thisGravityMap = new HashMap();
            for (AmmoType ammoType : AmmoPossibleCombination.SHOTGUN_AMMO.getAmmoTypes()) {
                thisDamageMap.put(ammoType, CONFIG_BUILDER.comment("Base damage, base speed(m/tick) and gravity(m/tick^2) of ammo: " + ammoType.getDescription() + " " + ammoSize.getDescription()).defineInRange("damage_" + ammoType.getRegisterString() + "_" + ammoSize.getRegisterString(), (double)(ammoType.getDamage() * ammoSize.getDamageModify()), 0.0, 999999.0));
                thisSpeedMap.put(ammoType, CONFIG_BUILDER.defineInRange("speed_" + ammoType.getRegisterString() + "_" + ammoSize.getRegisterString(), (double)(ammoType.getSpeed() * ammoSize.getSpeedModify()), 0.0, 999999.0));
                thisGravityMap.put(ammoType, CONFIG_BUILDER.defineInRange("gravity_" + ammoType.getRegisterString() + "_" + ammoSize.getRegisterString(), (double)ammoType.getGravity(), 0.0, 999999.0));
            }
            DAMAGE_MAP.put(ammoSize, thisDamageMap);
            SPEED_MAP.put(ammoSize, thisSpeedMap);
            GRAVITY_MAP.put(ammoSize, thisGravityMap);
            CONFIG_BUILDER.pop();
        }
        for (AmmoType ammoType : AmmoPossibleCombination.SHOTGUN_AMMO.getAmmoTypes()) {
            BIRD_SHOT_COUNT_MAP.put(ammoType, CONFIG_BUILDER.comment("Number of birdshots in short gun ammo: " + ammoType.getDescription()).defineInRange("n_birdshot_" + ammoType.getRegisterString(), ammoType.getBirdShotCount(), 0, 999999));
        }
        CONFIG_BUILDER.pop();
        CONFIG_BUILDER.comment("Gun Modifiers").push("gun_modifiers");
        AK47_CONFIG.setDamageModify(CONFIG_BUILDER.comment("AK47 damage modify").defineInRange("ak47_damage_modify", 1.7, 0.0, 999999.0));
        AK47_CONFIG.setSpeedModify(CONFIG_BUILDER.comment("AK47 speed modify").defineInRange("ak47_speed_modify", 1.5, 0.0, 999999.0));
        DESERT_EAGLE_CONFIG.setDamageModify(CONFIG_BUILDER.comment("DESERT_EAGLE damage modify").defineInRange("desert_eagle_damage_modify", 1.4, 0.0, 999999.0));
        DESERT_EAGLE_CONFIG.setSpeedModify(CONFIG_BUILDER.comment("DESERT_EAGLE speed modify").defineInRange("desert_eagle_speed_modify", 1.4, 0.0, 999999.0));
        GLOCK_CONFIG.setDamageModify(CONFIG_BUILDER.comment("GLOCK damage modify").defineInRange("glock_damage_modify", 1.1, 0.0, 999999.0));
        GLOCK_CONFIG.setSpeedModify(CONFIG_BUILDER.comment("GLOCK speed modify").defineInRange("glock_speed_modify", 1.0, 0.0, 999999.0));
        USP_CONFIG.setDamageModify(CONFIG_BUILDER.comment("USP damage modify").defineInRange("usp_damage_modify", 1.0, 0.0, 999999.0));
        USP_CONFIG.setSpeedModify(CONFIG_BUILDER.comment("USP speed modify").defineInRange("usp_speed_modify", 1.0, 0.0, 999999.0));
        AWP_CONFIG.setDamageModify(CONFIG_BUILDER.comment("AWP damage modify").defineInRange("awp_damage_modify", 3.0, 0.0, 999999.0));
        AWP_CONFIG.setSpeedModify(CONFIG_BUILDER.comment("AWP speed modify").defineInRange("awp_speed_modify", 2.0, 0.0, 999999.0));
        BARRETT_CONFIG.setDamageModify(CONFIG_BUILDER.comment("BARRETT damage modify").defineInRange("barrett_damage_modify", 5.0, 0.0, 999999.0));
        BARRETT_CONFIG.setSpeedModify(CONFIG_BUILDER.comment("BARRETT speed modify").defineInRange("barrett_speed_modify", 4.0, 0.0, 999999.0));
        M4A4_CONFIG.setDamageModify(CONFIG_BUILDER.comment("M4A4 damage modify").defineInRange("m4a4_damage_modify", 1.3, 0.0, 999999.0));
        M4A4_CONFIG.setSpeedModify(CONFIG_BUILDER.comment("M4A4 speed modify").defineInRange("m4a4_speed_modify", 1.35, 0.0, 999999.0));
        CONFIG_BUILDER.pop();
        CONFIG_BUILDER.comment("Tradings").push("tradings");
        ConfigCommon.addTrader("rocket_launcher", 1, "minecraft:diamond", 30, 40, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("incendiary_rocket", 1, "minecraft:diamond", 1, 2, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("smoke_rocket", 2, "minecraft:diamond", 2, 3, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("high_explosive_rocket", 3, "minecraft:diamond", 3, 4, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("atomic_bomb_rocket", 4, "minecraft:diamond", 40, 50, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("water_drop_rocket", 4, "minecraft:nether_star", 40, 50, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("c4_incendiary", 1, "minecraft:diamond", 2, 3, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("wood_defuse_kit", 1, "minecraft:wood", 2, 3, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("c4_smoke", 2, "minecraft:diamond", 4, 5, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("iron_defuse_kit", 2, "minecraft:iron_ingot", 5, 8, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("c4_high_explosive", 3, "minecraft:diamond", 5, 10, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("gold_defuse_kit", 3, "minecraft:gold_ingot", 5, 8, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("c4_atomic_bomb", 4, "minecraft:diamond", 40, 50, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("diamond_defuse_kit", 4, "minecraft:diamond", 5, 8, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("netherite_defuse_kit", 5, "minecraft:netherite_ingot", 5, 8, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("glock", 1, "minecraft:diamond", 10, 10, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("usp", 1, "minecraft:diamond", 10, 10, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("desert_eagle", 2, "minecraft:diamond", 20, 30, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("nova", 2, "minecraft:diamond", 20, 30, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("m4a4", 3, "minecraft:diamond", 30, 40, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("xm1014", 3, "minecraft:diamond", 30, 40, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("ak47", 4, "minecraft:diamond", 40, 50, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("awp", 4, "minecraft:diamond", 40, 50, "null", 1, 1, CONFIG_BUILDER);
        ConfigCommon.addTrader("barrett", 5, "minecraft:diamond", 50, 64, "null", 1, 1, CONFIG_BUILDER);
        for (AmmoSize ammoSize : AmmoPossibleCombination.SHOTGUN_AMMO.getAmmoSizes()) {
            ConfigCommon.addTrader("ammo_" + ammoSize.getRegisterString() + "_" + AmmoType.SHORT_GUN_NORMAL.getRegisterString(), 1, "minecraft:iron_ingot", 1, 1, "minecraft:gunpowder", 1, 1, CONFIG_BUILDER);
            ConfigCommon.addTrader("ammo_" + ammoSize.getRegisterString() + "_" + AmmoType.SHORT_GUN_BLIGHT.getRegisterString(), 2, "minecraft:iron_ingot", 1, 1, "minecraft:gunpowder", 2, 2, CONFIG_BUILDER);
            ConfigCommon.addTrader("ammo_" + ammoSize.getRegisterString() + "_" + AmmoType.SHORT_GUN_DESOLATOR.getRegisterString(), 3, "minecraft:iron_ingot", 5, 10, "minecraft:gunpowder", 2, 4, CONFIG_BUILDER);
        }
        for (AmmoSize ammoSize : AmmoPossibleCombination.RIFLE_AMMO.getAmmoSizes()) {
            ConfigCommon.addTrader("ammo_" + ammoSize.getRegisterString() + "_" + AmmoType.NORMAL.getRegisterString(), 1, "minecraft:iron_ingot", 1, 1, "minecraft:gunpowder", 1, 1, CONFIG_BUILDER);
            ConfigCommon.addTrader("ammo_" + ammoSize.getRegisterString() + "_" + AmmoType.INCENDIARY.getRegisterString(), 1, "minecraft:iron_ingot", 1, 1, "minecraft:gunpowder", 2, 2, CONFIG_BUILDER);
            ConfigCommon.addTrader("ammo_" + ammoSize.getRegisterString() + "_" + AmmoType.ANTI_GRAVITY.getRegisterString(), 2, "minecraft:iron_ingot", 1, 1, "minecraft:gunpowder", 2, 2, CONFIG_BUILDER);
            ConfigCommon.addTrader("ammo_" + ammoSize.getRegisterString() + "_" + AmmoType.SILVER.getRegisterString(), 2, "minecraft:iron_ingot", 1, 1, "minecraft:gunpowder", 2, 2, CONFIG_BUILDER);
            ConfigCommon.addTrader("ammo_" + ammoSize.getRegisterString() + "_" + AmmoType.EXPLOSIVE.getRegisterString(), 3, "minecraft:iron_ingot", 2, 2, "minecraft:gunpowder", 10, 10, CONFIG_BUILDER);
            ConfigCommon.addTrader("ammo_" + ammoSize.getRegisterString() + "_" + AmmoType.TUNGSTEN.getRegisterString(), 4, "minecraft:iron_ingot", 5, 5, "minecraft:gunpowder", 2, 2, CONFIG_BUILDER);
            ConfigCommon.addTrader("ammo_" + ammoSize.getRegisterString() + "_" + AmmoType.NUKE.getRegisterString(), 5, "minecraft:nether_star", 1, 1, "minecraft:gunpowder", 1, 1, CONFIG_BUILDER);
        }
        CONFIG_BUILDER.pop();
        CONFIG_BUILDER.comment("Defuse Time (in tick, 20ticks = 1 second)").push("defuse_time");
        WOOD_DEFUSE_KIT_TIME = CONFIG_BUILDER.defineInRange("wood_defuse_kit_time", 400, 1, 999999999);
        IRON_DEFUSE_KIT_TIME = CONFIG_BUILDER.defineInRange("iron_defuse_kit_time", 200, 1, 999999999);
        GOLD_DEFUSE_KIT_TIME = CONFIG_BUILDER.defineInRange("gold_defuse_kit_time", 60, 1, 999999999);
        DIAMOND_DEFUSE_KIT_TIME = CONFIG_BUILDER.defineInRange("diamond_defuse_kit_time", 150, 1, 999999999);
        NETHERITE_DEFUSE_KIT_TIME = CONFIG_BUILDER.defineInRange("netherite_defuse_kit_time", 100, 1, 999999999);
        CONFIG_BUILDER.pop();
        COMMON = CONFIG_BUILDER.build();
    }
}

