/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.network;

import com.song.nuclear_craft.blocks.tileentity.C4BombTileEntity;
import java.util.function.Supplier;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class C4BombSettingPacket {
    public double x;
    public double y;
    public double z;
    public String action;

    public C4BombSettingPacket(BlockPos pos, String action) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.action = action;
    }

    public C4BombSettingPacket(PacketBuffer packetBuffer) {
        this.x = packetBuffer.readDouble();
        this.y = packetBuffer.readDouble();
        this.z = packetBuffer.readDouble();
        this.action = packetBuffer.func_150789_c(Short.MAX_VALUE);
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeDouble(this.x);
        packetBuffer.writeDouble(this.y);
        packetBuffer.writeDouble(this.z);
        packetBuffer.func_180714_a(this.action);
    }

    public static void handle(C4BombSettingPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
            INetHandler handler = context.getNetworkManager().func_150729_e();
            if (handler instanceof ServerPlayNetHandler) {
                ServerWorld world = (ServerWorld)((ServerPlayNetHandler)handler).field_147369_b.field_70170_p;
                TileEntity entity = world.func_175625_s(new BlockPos(packet.x, packet.y, packet.z));
                if (!(entity instanceof C4BombTileEntity)) {
                    throw new IllegalArgumentException("entity should be C4bomb, but not: " + entity);
                }
                switch (packet.action.split("_")[0]) {
                    case "add": {
                        ((C4BombTileEntity)entity).addNum(Integer.parseInt(packet.action.split("_")[1]));
                        break;
                    }
                    case "delete": {
                        ((C4BombTileEntity)entity).delete();
                        break;
                    }
                    case "activate": {
                        ((C4BombTileEntity)entity).activate();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("not recognized argument: " + packet.action);
                    }
                }
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }
}

