/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.network;

import com.song.nuclear_craft.misc.ConfigClient;
import com.song.nuclear_craft.particles.ParticleRegister;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class NukeDownSmokePacket {
    public double x;
    public double y;
    public double z;
    public double radius;

    public NukeDownSmokePacket(double x, double y, double z, double radius) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
    }

    public NukeDownSmokePacket(PacketBuffer packetBuffer) {
        this.x = packetBuffer.readDouble();
        this.y = packetBuffer.readDouble();
        this.z = packetBuffer.readDouble();
        this.radius = packetBuffer.readDouble();
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeDouble(this.x);
        packetBuffer.writeDouble(this.y);
        packetBuffer.writeDouble(this.z);
        packetBuffer.writeDouble(this.radius);
    }

    public static int getNumParticles() {
        return 8;
    }

    public static void handle(NukeDownSmokePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            Random random = new Random();
            if (((Boolean)ConfigClient.RENDER_MUSHROOM_CLOUD.get()).booleanValue() && world != null) {
                for (int i = 0; i < NukeDownSmokePacket.getNumParticles(); ++i) {
                    double theta = Math.PI * 2 * random.nextDouble();
                    double speedModifier = 2.0 * random.nextDouble();
                    world.func_195594_a((IParticleData)ParticleRegister.SHOCK_WAVE.get(), packet.x, packet.y, packet.z, speedModifier * packet.radius * Math.cos(theta) / 25.0, 0.0, speedModifier * packet.radius * Math.sin(theta) / 25.0);
                }
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

