/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.network;

import com.song.nuclear_craft.misc.ConfigClient;
import com.song.nuclear_craft.particles.ParticleRegister;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class NukeRisingSmokePacket {
    public double x;
    public double y;
    public double z;
    public double radius;

    public NukeRisingSmokePacket(double x, double y, double z, double radius) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
    }

    public NukeRisingSmokePacket(PacketBuffer packetBuffer) {
        this.x = packetBuffer.readDouble();
        this.y = packetBuffer.readDouble();
        this.z = packetBuffer.readDouble();
        this.radius = packetBuffer.readDouble();
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeDouble(this.x);
        packetBuffer.writeDouble(this.y);
        packetBuffer.writeDouble(this.z);
        packetBuffer.writeDouble(this.radius);
    }

    public static int getNumParticles() {
        return 8;
    }

    public static void handle(NukeRisingSmokePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            Random random = new Random();
            if (((Boolean)ConfigClient.RENDER_MUSHROOM_CLOUD.get()).booleanValue() && world != null) {
                for (int i = 0; i < NukeRisingSmokePacket.getNumParticles(); ++i) {
                    double theta = Math.PI * 2 * ((double)i + 0.2 * random.nextDouble()) / (double)NukeRisingSmokePacket.getNumParticles();
                    double this_x = packet.x + packet.radius * Math.cos(theta);
                    double this_z = packet.z + packet.radius * Math.sin(theta);
                    world.func_195594_a((IParticleData)ParticleRegister.RESTRICTED_HEIGHT_SMOKE_PARTICLE.get(), this_x, packet.y, this_z, packet.radius * Math.cos(theta) / 320.0, packet.radius / 32.0, packet.radius * Math.sin(theta) / 320.0);
                }
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

