/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.network;

import com.song.nuclear_craft.entities.rocket_entities.SmokeRocketEntity;
import com.song.nuclear_craft.particles.ParticleRegister;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class ParticlePacket {
    public double x;
    public double y;
    public double z;
    public String action;

    public ParticlePacket(double x, double y, double z, String action) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.action = action;
    }

    public ParticlePacket(PacketBuffer packetBuffer) {
        this.x = packetBuffer.readDouble();
        this.y = packetBuffer.readDouble();
        this.z = packetBuffer.readDouble();
        this.action = packetBuffer.func_218666_n();
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeDouble(this.x);
        packetBuffer.writeDouble(this.y);
        packetBuffer.writeDouble(this.z);
        packetBuffer.func_180714_a(this.action);
    }

    public static void handle(ParticlePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            switch (packet.action) {
                case "smoke_bomb": {
                    SmokeRocketEntity.generateSmoke(packet.x, packet.y, packet.z);
                    break;
                }
                case "nuke_core": {
                    if (Minecraft.func_71410_x().field_71441_e == null) break;
                    Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)ParticleRegister.EXPLODE_CORE.get(), packet.x, packet.y, packet.z, 0.0, 0.0, 0.0);
                    break;
                }
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

