/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.particles;

import com.song.nuclear_craft.entities.NukeExplosionHandler;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;

public class RestrictedSmokeParticle
extends SpriteTexturedParticle {
    private double yLim;
    private double xLim;
    private double xInit;
    private double yInit;
    private double zInit;
    private double xMotionInit;
    private double yMotionInit;
    private double zMotionInit;
    private boolean canChangeColor = false;

    protected RestrictedSmokeParticle(ClientWorld world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected RestrictedSmokeParticle(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ, double xLim, double yLim, double scale, boolean canChangeColor) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.xInit = x;
        this.yInit = y;
        this.zInit = z;
        this.xLim = xLim;
        this.yLim = yLim;
        this.func_70541_f((float)scale);
        this.field_70547_e = 3000;
        this.field_70545_g = 0.0f;
        this.xMotionInit = motionX;
        this.yMotionInit = motionY;
        this.zMotionInit = motionZ;
        this.canChangeColor = canChangeColor;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.field_187127_g - this.yInit < this.yLim) {
            this.field_187129_i = this.xMotionInit;
            this.field_187130_j = this.yMotionInit;
            this.field_187131_k = this.zMotionInit;
        } else {
            this.func_187112_i();
        }
        if (this.canChangeColor) {
            float factor = 480.0f;
            if ((float)this.field_70546_d > factor) {
                this.func_70538_b(1.0f, 1.0f, 1.0f);
            } else {
                this.func_70538_b(1.0f, (float)this.field_70546_d / 480.0f, (float)this.field_70546_d / 480.0f);
            }
        }
        if ((this.field_187126_f - this.xInit) * (this.field_187126_f - this.xInit) + (this.field_187128_h - this.zInit) * (this.field_187128_h - this.zInit) > this.xLim * this.xLim) {
            this.func_187112_i();
        }
    }

    public int func_189214_a(float partialTick) {
        return 0xF000F0;
    }

    public static class RestrictedHeightFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite iAnimatedSprite;

        public RestrictedHeightFactory(IAnimatedSprite iAnimatedSprite) {
            this.iAnimatedSprite = iAnimatedSprite;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            float radius = NukeExplosionHandler.getBlastRadius();
            RestrictedSmokeParticle nukeParticle = new RestrictedSmokeParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, radius, 2.0f * radius, radius / 3.0f, true);
            nukeParticle.func_217568_a(this.iAnimatedSprite);
            nukeParticle.func_70538_b(1.0f, 1.0f, 1.0f);
            return nukeParticle;
        }
    }

    public static class MushroomFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite iAnimatedSprite;

        public MushroomFactory(IAnimatedSprite iAnimatedSprite) {
            this.iAnimatedSprite = iAnimatedSprite;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            float radius = NukeExplosionHandler.getBlastRadius();
            RestrictedSmokeParticle nukeParticle = new RestrictedSmokeParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, radius, 2.0f * radius, radius / 3.0f, false);
            nukeParticle.func_217568_a(this.iAnimatedSprite);
            nukeParticle.func_70538_b(1.0f, 1.0f, 1.0f);
            return nukeParticle;
        }
    }
}

